
#include "inkey.ch"
#include "box.ch"
#include "getexit.ch"

/*

    Programa demostracin de uso de la libreria de cdigos de
    barras MINI CODE BAR 2.0


    (c) MINGO SOFT 1994
*/

procedure main()

   local cstring, cstr1, cstr2, ccod3, i, acod, asup
   local lprn, cimp, nmod, nden, ctip, getlist := {}
   local c00 := chr( 0 ), cFF := chr( 255 )

   SET CONFIRM ON

   cstring := space( 20 )
   cstr1 := cstr2 := ""
   cimp := "G"
   ctip := "1"

   nmod := 0
   nden := 0

   setCursor( 0 )
   CLS
   setColor( "w+/b" )
   @0,0
   @1,0
   @2,0
   @24,0
   setColor( "gr+/b" )
   @1,  0 SAY padc( alltrim( regVer() ), maxcol() + 1 )
   @24, 0 SAY padc( alltrim( regNom() ), maxcol() + 1 )
   setColor( "w+/b" )
   dispbox( 4, 8, 10, 70, B_SINGLE + " " )

   @5, 10 SAY "Impr. [E]pson, [H]p, [G]rfico  :"
   @6, 10 SAY "Introduzca el tipo              :"
   @7, 10 SAY "Introduzca el modo / densidad   :     [F1]"
   @8, 10 SAY "Introduzca el multiplicador     :"
   @9, 10 SAY "Introduzca el Cdigo            :"

   setcolor( "gr+/n" )

   @11, 10 SAY "Tipos disponibles : (por antiguedad)"

   setcolor( "g+/n" )

   @13, 05 SAY "1 - Cdigo 39."
   @13, 45 SAY "2 - Cdigo 25."
   @14, 05 SAY "3 - Cdigo 25E."
   @14, 45 SAY "4 - Cdigo EAN 13."
   @15, 05 SAY "5 - Cdigo tipo revista (13 + 5)."
   @15, 45 SAY "6 - Cdigo EAN 8."
   @16, 05 SAY "7 - Cdigo EAN 8 + 2."
   @16, 45 SAY "8 - Cdigo DUN 14."
   @17, 05 SAY "9 - Cdigo DUN 16."
   @17, 45 SAY "0 - Cdigo 11."
   @18, 05 SAY "A - Cdigo 128."
   @18, 45 SAY "B - EAN 8 + 5"
   @19, 05 SAY "C - IBMBOX. (Epson)"
   @19, 45 SAY "D - CODABAR."
   @20, 05 SAY "E - Cdigo MSI."
   @20, 45 SAY "F - Cdigo B."
   @21, 45 SAY "G - Cdigo 39e."

   setcolor( "w+/b" )

   @5, 44 GET cimp PICT "!" VALID {|oget| validImp( oget, getlist ) }
   @6, 44 GET ctip PICT "!" VALID ctip $ "1234567890ABCDEFG"
   @7, 44 GET nmod PICT "999"
   @8, 44 GET nden PICT "99"
   @9, 44 GET cstring SEND READER := {|oget| getCRC( oget, getlist ) }

   while( lastkey() != 27 )

      setCursor( 1 )
      cstring := padr( cstring, 20 )
      readmodal( getlist )
      cstring := alltrim( cstring )
      setCursor( 0 )

      lprn := .t.

      printOn()

      do case

      case lastkey() == K_ESC
         lprn := .f.

      case ctip == "1"

         acod := impCodBar( code39( cstring ), nmod, nden, cimp )
         cstr1 := "39"

      case ctip == "2"

         acod := impCodBar( code25( cstring, .f. ), nmod, nden, cimp )
         cstr1 := "25"

      case ctip == "3"

         acod := impCodBar( code25( cstring, .t. ), nmod, nden, cimp )
         cstr1 := "25E"

      case ctip == "4"

         acod := impCodBar( codeEAN13( cstring, .t. ), nmod, nden, cimp )
         cstr1 := "EAN13"

      case ctip == "5"

         lprn := .f.
         cstr1 := strzero( val( substr( cstring, 1, 12 ) ), 12 )
         cstr2 := strzero( val( substr( cstring, 14, 5 ) ), 5 )

         acod := ImpCodBar( codeEAN13( cstr1, .t. ), nmod, nden, cimp )

         /* Cuando se juntan un EAN13/8 con un EAN2/5, el espacio entre
            ambos es exactamente la zona muda del primero, sin embargo,
            en el ejemplo siguiente la he reducido un poco, puesto que
            el lector que he usado para las pruebas no reconoca el
            segundo de alejarlo ms.
         */

         asup := ImpCodBar( repli( c00, 11 ) + codeEAN13( cstr1, .f. ) +;
                            repli( c00, 5 ) + codeEAN5( cstr2 ), nmod, nden, cimp )

         if( cimp == "G" )
            ccod3 := space( 4 ) + substr( cstring, 1, 1 ) + "" + space( 5 )
            for i := 2 to 7
               ccod3 += substr( cstring, i, 1 ) + " "
            next
            ccod3 += space( 4 ) + "" + space( 5 )
            for i := 8 to 12
               ccod3 += substr( cstring, i, 1 ) + " "
            next
            ccod3 += mod10( cstr1 ) + space( 5 ) + ""
            ccod3 += space( 2 )
         else
            ccod3 := ImpCodBar( repli( c00, 11 ) + ;        // Zona Muda
                             cFF + c00 + cFF +;            // Cabecera
                             repli( c00, 42 ) +;           // E. Izda.
                             c00 + cFF + c00 + cFF + c00+; // Intermezzo
                             repli( c00, 42 ) +;           // E. Dcha.
                             cFF + c00 + cFF +;            // Final
                             repli( c00, 5 ) +;            // Zona Muda
                             codeEAN5( cstr2 ), nmod, nden, cimp )[2]
         endif

         if( cimp == "E" )
            @prow() + 1, 0  SAY chr( 27 ) + "!" + c00 + chr( 27 ) + "+" + chr( 35 )
         endif

         @prow() + 1, 0  SAY "EAN13+5:"
         @prow()    , 10 SAY acod[2] + right( cstring, 5 )
         @prow() + 1, 10 SAY asup[2]
         @prow() + 1, 10 SAY asup[2]
         @prow() + 1, 10 SAY ccod3

         if( cimp == "E" )
            devout( chr( 27 ) + "2" )
            devout( chr( 27 ) + "g" )
            @prow() + 1, 14 SAY left( cstr1, 1 ) + ;
                                padc( substr( cstr1, 2, 6 ) + " " + ;
                                      substr( cstr1, 8, 5 ) + ;
                                      mod10( cstr1 ),;
                                      acod[1] * 1.5 )
            devout( chr( 27 ) + "!" + c00 )
         elseif( cimp != "G" )
            @prow() + 1, 9 SAY left( cstr1, 1 ) + ;
                               padc( substr( cstr1, 2, 6 ) + " " + ;
                                     substr( cstr1, 8, 5 ) + ;
                                     mod10( cstr1 ),;
                                     acod[1] )
         endif

         @prow() + 1, 0 SAY " "

      case ctip == "6"

         acod := impCodBar( codeEAN8( cstring, .t. ), nmod, nden, cimp )
         cstr1 := "EAN8"

      case ctip == "7"

         acod := impCodBar( codeEAN8( left( cstring, 7 ), .T. ) +;
                             codeEAN2( right( cstring, 2 ) ), nmod, nden, cimp )
         cstr1 := "EAN8 + 2"

      case ctip == "B"

         acod := impCodBar( codeEAN8( left( cstring, 7 ), .T. ) +;
                             codeEAN5( right( cstring, 5 ) ), nmod, nden, cimp )
         cstr1 := "EAN8 + 5"

      case ctip == "8"

         acod := impCodBar( codeDUN( cstring, 14 ), nmod, nden, cimp )
         cstr1 := "DUN-14"

      case ctip =="9"

         acod := impCodBar( codeDUN( cstring, 16 ), nmod, nden, cimp )
         cstr1 := "DUN-16"

      case ctip =="0"

         acod := impCodBar( code11( cstring ), nmod, nden, cimp )
         cstring += checksum( cstring, "0123456789-" )
         cstr1 := "CODE-11"

      case ctip =="A"

         acod := impCodBar( code128( cstring ), nmod, nden, cimp )
         cstr1 := "CODE-128"

      case ctip =="C"

         lprn := .f.
         pibmbox()

      case ctip == "D"

         acod := impCodBar( codabar( cstring, .t. ), nmod, nden, cimp )
         cstr1 := "CODABAR"

      case ctip == "E"

         acod := impCodBar( codeMSI( cstring, .t. ), nmod, nden, cimp )
         cstr1 := "MSI"

      case ctip == "F"

         acod := impCodBar( codeB( cstring, .t. ), nmod, nden, cimp )
         cstr1 := "CODE-B"

      case ctip == "G"

         acod := impCodBar( code39( code39e( cstring ) ), nmod, nden, cimp )
         cstr1 := "39e"

      endcase

      if( lprn )
         @prow() + 2, 00 SAY cstr1 + ":"
         @prow()    , 10 SAY acod[2]
         @prow() + 1, 10 SAY padc( cstring, max( acod[1], len( cstring ) ) )
      endif

      printOff()

   end

   setCursor( 1 )
   setColor( "w/n" )
   CLS

return

FUNCTION ImpCodBar( ccod, nmod, nden, ctip )

   local aret

   do case
   case ctip == "E"
      aret := IbmCodBar( ccod, nmod, nden )
   case ctip == "H"
      aret := hpCodBar( ccod, nmod, nden )
   OtherWise
      aret := chrCodBar( ccod )
   endcase

RETURN( aret )

procedure printOn()

   SET PRINT ON
   SET DEVICE TO PRINT
   SET CONSOLE OFF

return

procedure printOff()

   SET PRINT OFF
   SET DEVICE TO SCREEN
   SET CONSOLE ON

return

function validImp( oget, getlist )

   static nmodep := 3, ndenep := 3, nmodhp := 75, ndenhp := 1
   local lret := .t., cret := oget:varget(), corg := oget:original

   do case
   case corg == "E"    // Epson
      nmodep := getlist[3]:varGet()
      ndenep := getList[4]:varGet()
   case corg == "H"    // HP
      nmodhp := getList[3]:varGet()
      ndenhp := getList[4]:varGet()
   endcase

   do case
   case cret == "E"    // Epson
      getlist[3]:varPut( nmodep )
      getList[4]:varPut( ndenep )
   case cret == "H"    // HP
      getList[3]:varput( nmodhp )
      getList[4]:varPut( ndenhp )
   case cret == "G"    // Grafica
      getList[3]:varput( 0 )
      getList[4]:varPut( 0 )
   otherwise
      lret := .f.
   endcase

   getlist[3]:display()
   getlist[4]:display()

return lret

procedure help()

   SAVE SCREEN

   setcolor( "n/bg" )

   dispBox( 4, 2, 22, 77, B_SINGLE + " " )
   @5, 4 SAY "MODO HP                             Densidad 75, 100, 150, 300, etc..."
   @6, 4 SAY "MODO EPSON / IBM PROPRINTER"
   @7, 4 SAY "Los modos disponibles son :"
   @8, 6 SAY "Ŀ                           Ŀ"
   @9, 6 SAY "8 agujas                           24agujas"
   @10,6 SAY "Ŀ    Ŀ"
   @11,6 SAY "modo     densidad        ppp     modo     densidad        ppp "
   @12,6 SAY "Ĵ    Ĵ"
   @13,6 SAY "   0     sencilla         60       32     sencilla         60 "
   @14,6 SAY "   1     doble           120       33     doble           120 "
   @15,6 SAY "   2     doble alta vel. 120       38     CRT II           90 "
   @16,6 SAY "   3     Cuadruple       240       39     triple          180 "
   @17,6 SAY "   4     CRT              80       40     alta            360 "
   @18,6 SAY "   5     CRT ?           72     "
   @19,6 SAY "   6     CRT I            90 "
   @20,6 SAY "   7     CRT ?          144 "
   @21,6 SAY ""

   inkey( 0 )

   setcolor( "w+/b" )

   RESTORE SCREEN

return

PROCEDURE GetCRC( oGet, getlist )

   local nmodpos := 0
   local noldpos := 0
   local ccabnum := ""

   local acod := { repli( "!", 20 ), repli( "9", 20 ), repli( "9", 20 ),;
                   repli( "9", 13 ), repli( "9", 18 ), repli( "9", 8 ), ;
                   repli( "9", 10 ), repli( "9", 13 ), repli( "9", 14 ), ;
                   repli( "9", 16 ), repli( "#", 20 ), repli( "x", 20 ), "",;
                   repli( "!", 20 ), repli( "9", 20 ), repli( "9", 20 ),;
                   repli( "x", 20 ) }

   local ccod := "1234567B890ACDEFG"

   local cget2 := getlist[2]:varget()

   @9, 44 SAY space( 20 )

   oget:picture := acod[ at( cget2, ccod ) ]
   oget:varput( transform( oget:varget(), oget:picture ) )
   oget:display()

   IF ( GetPreValidate( oGet ) )

      oGet:setFocus()

      WHILE ( oGet:exitState == GE_NOEXIT )

         IF ( oGet:typeOut )
            oGet:exitState := GE_ENTER
         ENDIF

         do case
         case( cget2 $ "45" )
            nmodpos := 13
         case( cget2 $ "67B" )
            nmodpos := 8
            ccabnum := "0"
         case( cget2 == "8" )
            nmodpos := 14
         case( cget2 == "9" )
            nmodpos := 16
         endcase

         WHILE ( oGet:exitState == GE_NOEXIT )
            if( oget:pos == nmodpos .and. noldpos < oget:pos )
               noldpos := nmodpos
               getApplyKey( oget, asc( mod10( ccabnum +;
                                  left( oget:buffer, nmodpos - 1 ) ) ) )
            else
               noldpos := oget:pos
               GetApplyKey( oGet, inkey( 0 ) )
            endif
         ENDDO

         IF ( !GetPostValidate( oGet ) )
            oGet:exitState := GE_NOEXIT
         ENDIF
      ENDDO

      oGet:killFocus()

   ENDIF

RETURN

/* Ejemplo de uso de IBMBOX

      (c) MINGO SOFT 1994     */

PROCEDURE PIBMBOX()

   LOCAL i

   printOn()

   /* Ponemos la impresora en 8 lneas por pulgada
      Algunas impresora necesitaran del chr(27) + "1"
      en vez del "0".                                 */


   devout( chr(27) + "0" )

   @prow() + 1, 5 SAY "UNA CAJA EN BAJA CALIDAD"

   @prow() + 1, 0 SAY ibmbox( 1, 3 ) + repli( ibmbox( 2, 3 ), 10 ) + ibmbox( 3, 3 )
   for i := 1 to 8
      @prow() + 1, 0 SAY ibmbox( 4, 3 ) + space( 10 ) + ibmbox( 8, 3 )
   next
   @prow() + 1, 0 SAY ibmbox( 7, 3 ) + repli( ibmbox( 6, 3 ), 10 ) + ibmbox( 5, 3 )

   @prow() + 1, 5 SAY "UNA CAJA EN ALTA CALIDAD"
   @prow() + 1, 0 SAY ibmbox( 1, 39 ) + repli( ibmbox( 2, 39 ), 10 ) + ibmbox( 3, 39 )
   for i := 1 to 8
      @prow() + 1, 0 SAY ibmbox( 4, 39 ) + space( 10 ) + ibmbox( 8, 39 )
   next
   @prow() + 1, 0 SAY ibmbox( 7, 39 ) + repli( ibmbox( 6, 39 ), 10 ) + ibmbox( 5, 39 )

   devout( chr(27) + "2" )

   printOff()

RETURN
