#include <iostream.h>
#include <conio.h>
#include <math.h>
#include <stdlib.h>

#include "drmatrix.hpp"

void vector_arith();
void matrix_arith();
void matrix_prop();

int main()
{
	int choice;
	char a[10];
	do {
		clrscr();
		cout << "Please choose an option:\n\n"
			 << "1. Matrix Arithmetic\n"
			 << "2. Matrix Properties\n"
			 << "3. Vector Arithmetic\n"
			 << "0. Exit\n";
		cin >> choice;
		switch(choice)
		{
			case 0:					break;
			case 1: matrix_arith(); break;
			case 2: matrix_prop();  break;
			case 3: vector_arith(); break;
			default: cin.getline(a,10); break;
		}
	} while(choice!=0);
    return 0;
}

void vector_arith()
{
	float r;
	Vector<float> b(3,V_HORIZ);
	clrscr();
	cout << "Please enter the value of b, a 3-vector over R:" << endl;
	cin >> b;
	cout << "\nPlease enter the value of r, a real scalar:" << endl;
	cin >> r;
	clrscr();
	cout << "b:\n" << b << endl << endl << "b Transpose:\n" << b.T()
		 << "\n\nr*b:\n" << r*b << "\nb+b:\n" << b+b << "\nb*bT:\n"
		 << b * b.T() << "\n|b|:\n" << b.abs() << "\nPress any key...\n";
	getch();
}

void matrix_arith()
{
	int rows,cols;
	clrscr();
	cout << "Please select a matrix size (e.g. 2 3 for 2 rows, 3 columns):\n";
	cin  >> rows >> cols;
	Matrix<float> m(rows,cols);
	cout << "Please enter a " << rows << 'x' << cols << " matrix:\n";
	cin  >> m;
	clrscr();
	cout << "M:\n" << m << "\nM Transpose:\n" << m.T()
		 << "\n\nPress any key...\n";
	getch();
	clrscr();
	cout << "3*M:\n" << 3*m << "\nM+M:\n" << m+m
		 << "\n\nPress any key...";
	getch();
	clrscr();
	cout << "M * M Transpose:\n" << m*m.T();
	if(m.square())
		cout << "\nTr{M} (Sum of diagonal):\n" << m.tr() << "\n\n|M|:\n"
			 << m.det();
	cout << "\n\nPress any key to continue...";
	getch();
	clrscr();
	cout << "Stepped matrix equivalent to M:\n" << m.step();
	cout << "\n\nM's equivalent canonized matrix:\n" << m.canon();
	cout << "\n\nRank{M}:\n" << m.rank()
		 << "\n\nPress any key to continue...";
	if(m.reg())
	{
		Matrix<float> minv = m.inv();
		getch();
		clrscr();
		cout << "Regular (reversible) matrix.\n\n"
			 << "M's inverse matrix:\n"
			 << minv
			 << "\n\nPress any key to continue...";
	}
	getch();
}

void matrix_prop()
{
	Matrix<float> m(4,4);
	clrscr();
	cout << "Please enter a 4x4 matrix:\n";
	cin  >> m;
	cout << "\n\n";
	if(m.square())
		cout << "Square matrix\n";
	else
		cout << "Non-square matrix\n";
	if(m.diag())
		cout << "Diagonal matrix\n";
	else
		cout << "Non-diagonal matrix\n";
	if(m.iden())
		cout << "Identity matrix\n";
	if(m.scalar())
		cout << "Scalar matrix\n";
	else
		cout << "Non-scalar matrix\n";
	if(m.sym())
		cout << "Symmetric matrix\n";
	else
		cout << "Not a symmetric matrix\n";
	if(m.antisym())
		cout << "Antisymmetric matrix\n";
	else
		cout << "Not an antisymmetric matrix\n";
	if(m.stepped())
		cout << "Stepped matrix\n";
	else
		cout << "Not a stepped matrix\n";
	if(m.reg())
		cout << "Regular (reversible) matrix\n";
	else
		cout << "Singular (non-reversible) matrix\n";
	cout << "\nPress any key...";
	getch();
}
