//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.
//                  test7.cpp
//  This programs polimorfic coding and decoding using named clases
//  If you Define the simbol DEBUG_BT for compiling, you will see
//  when an object is created and when is deleted



#include <stdio.h>
#include <iostream.h>
#include "dll.h"
#include "btypes.h"

class parent_C {
public:
	char_B data;
	virtual void func1();
};
void parent_C::func1() { printf("parent\n");}

class sun1_C:public parent_C {
public:
	int_B data;
	void func1();
};

void sun1_C::func1() { printf("sun1\n");}


class sun2_C:public parent_C {
public:
	double_B		data;
	void func1();

};


void sun2_C::func1() {
	printf("sun2\n");
}

typedef bt_C<parent_C> parent_B;
name_BT(parent_B,"parent_C");

typedef bt_C<sun1_C> sun1_B;
name_BT(sun1_B,"sun1_C");

typedef bt_C<sun2_C> sun2_B;
name_BT(sun2_B,"sun2_C");

typedef bt_C< dll_C<parent_B> > dll_parent_B;

void disp(dll_parent_B& lista)
{
	printf("\n=========Lista=========\n");
	if(lista.is_void()) return;
	if (lista().first())
		do {
			lista().item()().func1();
		} while (lista().next());
}


int main()
{
	dll_parent_B lista,lista2;
	parent_B parent;
	sun1_B    sun1;
	sun2_B    sun2;
	lista.create();
	lista().out();
	parent.create();
	lista().insert_l(parent);
	sun1.create();
	parent=&sun1;
	lista().insert_l(parent);
	sun2.create();
	lista().insert_l(parent=&sun2);
	parent.create();
	lista().insert_l(parent);

	{
		lista2.forget();
		lista2.clone(lista);
	}

	disp(lista);
	disp(lista2);

	{
		lista2.forget();
		char_B data(BT_BA|BT_CA|BT_AR);
		lista.encode(&data);
		lista2.decode(&data);
	}

	disp(lista);
	disp(lista2);

	{
		lista2.forget();
		FILE* file;
		file=fopen("prueba.xdr","w+b");
		lista.encode(file);
		fseek(file,0,SEEK_SET);
		lista2.decode(file);
		fclose(file);
	}

	disp(lista);
	disp(lista2);


	printf("=========================\n");
	if (lista.equal(lista2)) printf("lista equal lista2\n");
	else printf("lista not equal lista2\n");
	printf("=========================\n");

	return 0;
}
