#ifndef TYPES_H
#define TYPES_H
//DOC_BEGIN
//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.

#include <stdlib.h>
#include "except.h"
#include "gencode.h"
#include "dllbas.h"

//General simbolic constants
#define USE 		1
#define CREATE 	2
#define XDR_CODE 	1    //external data representation
#define LDR_CODE  2    //local data representation
extern char DEF_CODE;    //Default code metod (LDR)
								 //you can change it at run time
								 //or before compiling it definition is in file
								 //types.cpp use XDR_CODE or LDR_CODE to modify it.
#define ENCODE    1    //used to encode
#define DECODE    2    //used to decode
#define ENSIZE    3    //used to calculate the size of the code

//Characteristics of the handler (bt, init_bt bt_s() , set_bt()...)
#define BT_CA   (char)1    //BT  CARE  if this flag is not set
									//the handler will be skipped when coding sizing
									//and decoding are doing.
#define BT_BT   (char)2    //BT  BT the handler is of a type implemented with
									//handlers and general algorithms should be used
#define BT_BA   (char)4    //BT  the handler is of an opaque type a especial
									//coding algorithm should be provided.
//DOC_END
#define BT_AR   (char)8    //BT  Array (internal use only).
#define BT_VI_F  (char)1   //Virtual class (internal use only).

//DOC_BEGIN
//Coding characteristics of the handler
#define ECODE_F  (char)2    //Especial coding tag
#define ECODEA_F (char)4    //Normal coding and especial coding  after normal
									 //conding


void   chknew(void* param);//funtion used to check memory allocation

//class type is used to save type dependant data and metods so it can be used
//by general pointers.
class type_C {
public:
//-------------------type dependent data---------------------------
	char  flags;          //BT characteristics of the type
	char* name;           //name of the type
//-------------------type dependent metods-------------------------
	void* (*s_new)                 (int n);
	void  (*s_delete)              (void * a);
	int   (*s_lsize)               ();
	int   (*s_ecode) (void* a,int n_elements,gencode_C& gencode);
//-----------------------------------------------------------------
type_C();
};
//DOC_END

class dll_BAS_type_C:public dll_BAS<type_C> {
public:
	int find (char* name);
	dll_BAS_type_C();
};

//DOC_BEGIN
class info_C {
public:
	void       *extra;   //extra data member (internal use)
	int       references;//references counter
	int       elements;  //numbet of elements in the array of objects
	int       secure;    //secure counter 0 if is not secured
	void      *ptr;      //pointer to the array of objetcs
	info_C();
};
//DOC_END

//DOC_BEGIN
class types_C {
public:
	static  long   int n_bt;  //number of arrays of objects referenced
									  //by all the handlers
	type_C*        type;      //pointer to type (data type information).
	info_C*        info;      //object control data and
									  // indirect pointer to array of objects.
	char           bt;        //handler characteristics.
									  //can be modified any time.
									  //by default take the creaation characteristics
	char           init_bt;   //handler creation characteristics.
									  //this are specified by a contructor.
									  //by default take the type characteristics
	char           secure_f;  //secure reference flag(internal).
	int  is_void();          //return true if handler reference is invalid.
	int  elements();         //number of elements of the array of objects
									 //referenced by the handler
	int  redim(int n);       //change de size of array of objects to n elements
	void put_bt(char bt); //clear all the characteristics of the handler then
								 //set the this characteristics to the indicated by
								 //bt
	void set_bt(char bt);//set the characteristics of the handler
								//bt conteins the characteristcs to be set
	void reset_bt();         //change the handler characterists to the creation
									 //characterists
	void clear_bt(char param);//clear the characteristics indicated
									  //of the handler
	void secure();            //make a secure reference
	void release();           //unmake a secure reference
	int  size(int op=DEF_CODE);//size in bytes of the genetic code of the objects
	static  int  s_code_real         (void *a,gencode_C& gencode);
	//this function recieves a pointer to a handler in the param a,
	//the gencode param must be previous initialised an ready to work
	//if you are creating a especial code metod you can use the gencode param
	//pased to the especial code metod this is ready to work with it.
	//The s_code_real metod provide access to the general coding algoritm.
	//This metod does not prefix the lenght of the gen. code in the gen. code.
	int  encode(void* dump ,int op=DEF_CODE);//generete the genetic code
														  //of the objects
	int  decode(void* dump ,int op=DEF_CODE);//generete the objects
														  //from the genetic code.
	int  encode(FILE*file ,int op=DEF_CODE);//generete the genetic code
														 //of the objects
	int  decode(FILE*file ,int op=DEF_CODE);//generete the objects
														  //from the genetic code.
			//this methods always use the size of the code as a prefix in the code
			//this size type is int.
			//op parameter can take three diferents values
			//DEF_CODE use the default representation for the genetic code.
			//XDR_CODE use external data representation for the genetic code.
			//LDR_CODE use local data representation for the genetic code.

			//dump parameter is a pointer to a char_B objetc, when encoding if
			// the number of elements if less than is needed the char_B object
			// is redimed, if the reference is void the char_B object is created.

			//file paremeter is a pointer to an open file, make sure that this
			//file is open for writing if you are going to code into it.

//DOC_END
protected:
	static  dll_BAS_type_C TYPES;
	static  int    s_clone  (void *a,void *b);
	static  int    s_equal  (void *a,void *b);
	static  int    s_code   (void* a,void* dump,gencode_C& gencode);
	static  int    s_create (void *a,int n);
	static  int    s_insert_r(void* a,void* b,int pos);
	static  int    s_insert_l(void* a,void* b,int pos);
	static  int    s_del(void* a,int pos,int n);
	static  int    s_redim  (void *a,int n);
	static  void   s_forget (void *a);
	static  void   s_delete_bt(void *a);
	static  int    s_cmp(void* a,void* b);
private:
	static  int  s_equal_real        (void *a,void *b,void* lista);
	static  void s_direct_externals  (void *a,void* lista);
	static  void s_propagate         (void *a);
	static  int  s_no_bt             (void *a);
//DOC_BEGIN
};
//DOC_END

//DOC_BEGIN
template<class T>
class bt_C:public types_C {
public:
	static type_C* s_type; //pointer to the type information
								  //and metods that depend of the type.
	static char&  bt_s();  //characteristics of the handler type
	static char*& name_s();//name of the handler type
	int   create(int n=1);  //create an array of n objects
	void  secure();         //make this a secure reference
	void  secure(bt_C<T>& op);//reference the objects referenced by op
									  //and secure this new reference.
	int   clone(bt_C<T>& a);//make a clone of the objects referenced by
									//and reference it, if the handler previously had
									//a valid reference this previus reference is
									//forgeten.
	bt_C<T> dup();//clone itself and return a new handler that references the
					  //objects cloned
	int   equal(bt_C<T>& a); //compare the info contained by objects
									 //resursivily.
	bt_C<T>& operator=(bt_C<T>& op); // reference the objecst of the handler op
												// and forget the previous reference.
	bt_C<T>& operator=(void* op);//same ass the previous metod but in this case
		//a pointer to a handler is recieved.
		//Yo can sen pointers to bt_C<S> where bt_C<S>  where class S is a class
		//sun of T. T and S must be named data types, in order to use this metod
	int operator==(bt_C<T>& op);
		//compare only the references
	int operator==(void* op);
		//compare only the references op is a pointer to a handler
	T& operator()();
	  //access the first element of the array of objects.
	T& operator()(int n);
	  //access the n element of the array of objects.
	  //n=0 for the first element
	void forget();
	  //forget the reference and make this reference void.
	  //if the handler is secure and is not the last reference to the object
	  //then the forget will not analize if the objetc should be destroyed
	  //if the object is secure you indicate that at least you have one more
	  //external referece(may be indirect) to the object.
	bt_C(char bt=0);
		//handler construtor bt are the handler construction characteristics
	bt_C(bt_C<T>& op,char bt=0);
		//handler constructor bt are the handler construction characteristics
		//the objects referenced by op will be referenced by this new handler
  ~bt_C();
	  //handler destructor.
	  //a forget is made before the handler is destroyed.
//DOC_END
protected:
	static void*  s_new            (int n=1);
	static void   s_delete         (void * a);
	static int    s_lsize();
	int           ecode_type();
	static int    s_ecode (void* a,int n_elements,gencode_C& gencode);
	void init (char bt);
	void init (bt_C<T>& op,char bt);
//DOC_BEGIN
};
//DOC_END

template<class T>
type_C* bt_C<T>::s_type=NULL;

template<class T>
char& bt_C<T>::bt_s()
{
	static char var=BT_BT|BT_CA;
	return var;
}

template<class T>
char*& bt_C<T>::name_s()
{
	static char* var=NULL;
	return var;
}

template<class T>
int bt_C<T>::create(int n)
{
	forget();
	if (n>1) set_bt(BT_AR);
	else clear_bt(BT_AR);
	return s_create(this,n);
}

template<class T>
void bt_C<T>::secure()
{
	types_C::secure();
}

template<class T>
void bt_C<T>::secure(bt_C<T> & op)
{
	operator=(op);
	types_C::secure();
}

template<class T>
int bt_C<T>::clone(bt_C<T>& a)
{
	forget();
	return s_clone(this,&a);
}

template<class T>
bt_C<T> bt_C<T>::dup()
{
	bt_C<T> var;
	var.clone(*this);
	return var;
}

template<class T>
int bt_C<T>::equal(bt_C<T>& a)
{
	return s_equal(this,&a);
}

template<class T>
void* bt_C<T>::s_new(int n)
{
	if (n==0) return NULL;
	return (void*) new T[n];
}

template<class T>
void bt_C<T>::s_delete(void* a)
{
	if (a) delete [] (T*) a;
}

template<class T>
int bt_C<T>::s_lsize()
{
	return sizeof(T);
}

template<class T>
int bt_C<T>::ecode_type()
{
	return 0;
}

template<class T>
int bt_C<T>::s_ecode (void*,int,gencode_C&)
{
	 printf("Error: No especial code metod defined.\n");
	 exit(0);
	 return 1;
}



template<class T>
bt_C<T>& bt_C<T>::operator=(bt_C<T>& op)
{
	if(!op.info)  {
		forget();
		return *this;
	}
	op.info->references++;
	forget();
	info=op.info;
	type=op.type;
	if (op.info->elements>1) set_bt(BT_AR);
	else clear_bt(BT_AR);
	return *this;
}

template<class T>
bt_C<T>& bt_C<T>::operator=(void* op)
{
	if(type!=(*(bt_C<T>*)op).type) {
		forget();
		type=(*(bt_C<T>*)op).type;
	}
	return operator=(*(bt_C<T>*)op);
}


template<class T>
int bt_C<T>::operator==(void* op)
{
	return operator==(*(bt_C<T>*)op);
}

template<class T>
int bt_C<T>::operator==(bt_C<T>& op)
{
	return op.info==info;
}

template<class T>
T& bt_C<T>::operator()()
{
  if (!info) {
		throw types_except_C(VOID_REFERENCE_TYPES_EXCEPT);
  }

  return *(T*)(info->ptr);
}

template<class T>
T& bt_C<T>::operator()(int n)
{
  if (!info) exit(0);
  return ((T*)(info->ptr))[n];
}


template<class T>
void bt_C<T>::init(char bt_param)
{
	info=NULL;
	if(!s_type) {
		int paso=0;
		chknew(s_type= new type_C);
		s_type->s_ecode=s_ecode;
		s_type->s_lsize=s_lsize;
		s_type->s_new=s_new;
		s_type->s_delete=s_delete;
		paso=sizeof(T)%sizeof(types_C);
		if (paso) s_type->flags|=BT_VI_F;
		s_type->flags|=ecode_type();
		if (name_s()) {
			s_type->name=name_s();
#ifdef DEBUG_BT_INIT
			printf("Name_s%s\n",name_s());
#endif
			if (TYPES.find(name_s())) {
				printf("Error: type %s already registred.\n",name_s());
				exit(0);
			}
			TYPES.out();
			TYPES.insert_r(s_type);
		}
	}
	type=s_type;
	if(!bt_param) init_bt=bt_s();
	else init_bt=bt_param;
	bt=init_bt;
	secure_f=0;
}


template<class T>
void bt_C<T>::init(bt_C<T>& op,char bt_param)
{
	init(bt_param);
	operator=(op);
}

template<class T>
void bt_C<T>::forget()
{
	if (info)  {
		 if (info->secure) {
			if(secure_f) release();
			else
			if(info->references>1) {
				info->references--;
				info=NULL;
			}
		}
		if (info){
			if (!info->extra) s_forget(this);
			else s_delete_bt(this);
		}
	}
	info=NULL;
	type=s_type;
	bt=init_bt;
}

template<class T>
bt_C<T>::bt_C(char bt_param)
{
	init(bt_param);
}

template<class T>
bt_C<T>::bt_C(bt_C<T>& op,char bt_param)
{
	init(bt_param);
	operator=(op);
}

template<class T>
bt_C<T>::~bt_C()
{
	forget();
}


//DOC_BEGIN

//general handlers and general handler pointer types
class gen_C {};
typedef bt_C<gen_C> gen_B;
typedef gen_B*      gen_P;


//especializations
#define bt_BT(a,b) char& a::bt_s(){static char var=(b);return var;}
//this macro is used to provide a especial BT
#define name_BT(a,b) char*& a::name_s(){static char* var=(b);return var;}
//this macro is used to name the class
#define ecode(b,c)  int b::ecode_type(){return c;}; \
						  int b::s_ecode(void* a,int n_elements,gencode_C& gencode)
//the function declared whit this macro would recieve three params
//a  pointer to the data
//n_elements the number of elements referenced by the pointer
//gencode a reference to gencode_C class that most be used for the coding
//        operations

//DOC_END
#endif
