1.1.1. Introduction

AS68K is a 680/68010/68020/68030/CPU32 cross-assembler with FPU support which runs under MS-DOS.  Together with the related linker LINK and downloader DL program images may be created to burn into eprom or load onto a diskette.  

The program syntax will be familiar to 680x0 programmers; however there are a couple of things which differ significantly.  First, the familiar 680 syntax for addressing modes is not supported at all.  Addressing modes must be expressed in the 68020 format.  Thus:  

MOVE.B 1(A0),D1

becomes

MOVE.B (1,A0),D1

More importantly, the default size for most instructions is long (.L). Instructions such as MOVE CCR,D0 and  dbra d0,.lp will default to the only available size which is byte in the first case and word in the second case.

AS68K supports multiple code and data sections so that memory may be fragmented in an arbitrary manner.

AS68K fully supports TText, however by default it assumes that an input file will be in ASCII format.  If the TText selector is used as the first byte of the file the file will be assumed to be streamed TText.

@.1.1. 680x0 Coverage

AS68K fully supports processor instructions for the  680/68010/68020/68030/CPU32 processors and additionally the FPU instructions of the 681 FPU coprocessor.  The current implementation does not support the 68851 PMMU coprocessor.  By default only instructions in the base 680 set are accepted for assembly; a command line switch or option in the source file enables other instructions.

2.2.1.  Supported Registers

 The base 680 instruction set supports the following registers:

*7+
w Address Registers:  A0 A1 A2 A3 A4 A5 A6 A7 w
w Data Registers: D0 D1 D2 D3 D4 D5 D6 D7 w
w Control Registers;  CCR SR w
(7)

 The 68010 instruction set additionally supports:

*7+
w Control Registers:  SFC DFC USP VBR w
(7)

 The 68020 instruction set additionally supports:

*7+
w Control Registers:  CACR CAAR MSP ISP w
(7)

 The 68030 instruction set additionally supports:

*7+
 w MMU registers: CRP SRP TCTT0TT1 MMU w
(7)

 The CPU32 instruction set includes all registers up through
 the 68020 support.

The assembler additionally recognizes the register SP as a synonym to A7. In addressing modes, PC and ZPC can be used to force PC-relative addressing.

 The 681 supports:

*7+
w Data Registers: FP0 FP1 FP2 FP3 FP4 FP5 FP6 FP7 w
w Control Registers:  FPCR FPSR FPIAR w
(7)

2.3.1.  Supported Opcodes

Instructions may work on data of various sizes.  In some cases the assembler will be able to implicitly detect the data size of a given instruction;  for example MOVEQ always operates on LONG data.  For other cases where there is ambiguity the assembler always chooses the largest size it can; in most cases this results in a default size of long forintegers and a default size of extended for reals.  However, it is possible to append a size to most instructions to override the default size or clarify it.  Sizes A68k recognize include:

*7+
w .B - Byte w
w .W - Word w
w .L - Long w
w .S - Single precision real w
w .D - Double precision real w
w .X - Extended precision real w
w .P - Packed real w
(7)
To move a byte into D0 one would thus do:

MOVE.B  #DATA,D0


2.3.2  680 opcodes

The base 680 instruction set includes:

*7+
w ABCD BRA DIVSL LSR OR STOP  w
w ADD BSET DIVU MOVE ORI SUB w
w ADDA BSR DIVUL MOVEA PEA SUBA  w
w ADDI BTST EOR MOVEM RESET SUBI  w
w ADDQ CHK EORI MOVEP ROL SUBQ  w
w ADDX CLR EXG MOVEQ ROR SUBX  w
w AND CMP EXT MULS ROXL SWAP  w
w ANDI CMPA ILLEGAL MULU ROXR TAS w
w ASL CMPI JMP NBCD RTE TRAP  w
w ASR CMPM JSR NEG RTR TRAPV w
w B<cc> DB<cc>  LEA NEGX RTS TST w
w BCHG DBRA LINK NOP S<cc> UNLK  w
w BCLR DIVS LSL NOT SBCD w
(7)

AS68K will automatically detect when a quick or immediate or address version of a function is useable if the generic form of the instruction is used.

In the above instructions, <cc> is a shortcut to specify the possible
condition codes and may be any of:

*7+
w CC CS EQ F GE GT HI HS LE LO LS LT MI NE PL T VC VSw
(7)

An exception is that for B<cc> the conditions F and T are not supported.Conditions HS and LO are equivalent to CC and CS respectively.  In addition the assembler recognizes DBRA as a synonym of DBF.

Backward branches use the smallest size that will fit.  Forward branches may be suffixed as normal to select a size; otherwise they default to word size.


2.3.3. 68010 opcodes

The 68010 instruction set additionally includes:

*7+
w MOVEC MOVES RTD w
(7)


2.3.4 68020 opcodes

The 68020 instruction set additionally includes:

*7+
w BFCHG BFO BFTST CAS CMP2 RTM w
w BFCLR BFINS BKPT CAS2 EXTB TRAP<cc> w
w BFEXTS  BFSET CALLM CHK2 PACK UNPK w
w BFEXTU w
(7)

<cc> is as given for the 680.  When 68020 processing is
enabled forward branches default to longword size instead of word size.
Again they can be overriden with a size suffix.

2.3.5.  68030 opcodes
 
The 68030 supports all 68020 instructions except for CALLM and RETM and adds the following MMU instructions:

*7+
 w PFLUSH  PMOVE PTESTR  w
 w PFLUSHA PLOAD PTESTW  w
 w PFLUSHFD w
(7)

2.3.6.  68040 opcodes

The 68040 supports all 68020 instructions except for CALLM and RETM and
adds the following MMUinstructions:

*7+
 w CINV PFLUSH  PFLUSHA  PTESTRw
 w CPUSH PFLUSHN PFLUSHAN PTESTWw
(7)

The 68040 also supports 681 FPUopcodes (see section 2.3.7.) and adds
the following FPUinstructions.  Some FPUinstructions are not implemented
in hardware on the 68040 and require software support.

 *7+
w FSABS FSDIV FSMUL FSSQRT  w
 w FDABS FDDIV FDMUL FDSQRT  w
 w FSADD FSMOVE  FSNEG FSSUB w
 w FDADD FDMOVE  FDNEG FDSUB w
(7)

2.3.7.  CPU32 opcodes

The CPU32 processor executes all 68020 instructions EXCEPT:

*7+
 wBFCHG BFO CALLM PACK  w
 }BFCLR BFINS CAS UNPK  w
 wBFEXTS  BFSET CAS2 w
 wBFEXTU  BFTST RTM w
 (7)

Additionally it supports the following new instructions:

 
 BGND TBLS
 LPSTOP

 
 


2.3.8.  681 FPU opcodes
 
The 681 FPU supports the following instructions:

*7+
wFABS FCOS FINT FMOVE FS<fcc> FSQRT w
wFCOS FCOSH FINTRZ  FMOVECR FSAVE FSUB w
wFADD FDB<fcc> FMOVEM  FSCALE  FTAN w
wFASIN FDIV FLOG10  FMUL FSGLDIV FTANH w
wFATAN FETOX FLOG2 FNEG FSGLMUL FTENTOX w
wFATANH  FETOXM1 FLOGN FNOP FSIN FTRAP<fcc> w
wFB<fcc> FGETEXP FLOGNP1 FREM FSINCOS FTST w
wFCMP FGETMAN FMOD FRESTORE FSINH  FTWOTOX w
(7)

In these instructions, <fcc> is replaced by any of the floating point condition names:

*7+
wEQ GLE NE NGT OGL OR ST UGT w
wF GT NGE NLE OGT SEQ T ULE w
wGE LE NGL NLT OLE SF UEQ ULT w
wGL LT NGLE OGE OLT SNE UGE UN  w
(7)

2.4.1.  Supported addressing Modes

A68K does not support 680 style syntax for addressing modes.  Instead, use the 68020 syntax.  However, A68K will discriminate addressing modes that are for a processor which has not been enabled and generate an error message.


The following notation is used in describing addressing modes:

*7+
wNotation Meaning w
z3N3x
wDn S Data Register (D0-D7) w
wAn S Address Register (A0-A7) w
wXn S Index register.  Any data or address w
w S register with optional size and scale. w
w S e.g. D1, A3, D1.L, A3.W, D4.L*2, A2.W*4 w
wd8 S 8 bit signed value w
wd16 S 16 bit signed value w
wd32 S 32 bit signed value w
wc S constant w
wa S address.  Size may be forced with (a).W w
w S or (a).L w
wbd S Base displacement.  d8, d16, or d32 w
wod S Outer displacement.  d8, d16, or d32 w
(7@7)


2.4.2. 680 addressing modes

The base 680 instruction set allows the following addressing modes:

*7+
wNotation Meaning w
z3N3x
wDn S Data register direct w
wAn S Address register direct w
w(An) S Address register indirect w
w(An)+ S Indirect with postincrement w
w-(An) S Indirect with predecrement w
w(d16,An) S Indirect with displacement w
w(d16,PC) S PC-relative with displacement w
w(d8,An,Xn) S Indirect with index w
w(d8,PC,Xn) S PC-indirect with index w
w#c S Immediate data w
wa S Absolute address w
(7@7)


2.4.3. 68020 addressing modes

The 68020 instruction set allows the following additional addressing modes:

*7+
wNotation Meaning w
z3N3x
w(bd,An,Xn) SIndirect with index w
w(bd,PC,Xn) SPC-indirect with index w
w([bd,An],Xn,od)SMemory indirect postindexed w
w([bd,PC],Xn,od)SPC Memory indirect postindexed w
w([bd,An,Xn],od)SMemory indirect preindexed w
w([bd,PC,Xn],od)SPC Memory indirect preindexed  w
(7@7)


2.4.4. CPU32 addressing modes

The CPU32 instruct set addressing modes are a subset of the 68020addressing modes.  They include all base 680 addressing modes and the following addtions:

*7+
 wNotation Meaning w
z3N3x
 w(bd,An,Xn)  S Indirect with index w
 w(bd,PC,Xn)  S PC-indirect with index w
(7@7)


2.4.4. Comments on addressing modes

ZPC may be used in place of PC.  Any time PC is used as the base register, the assembler computes the relative displacement from the current program counter.  The resulting relative expression must fit in the designated size.

Indirect displacements use the smallest size that will hold them.  In the case of forward references the assembler cannot compute the size and defaults to the longest size available.  The bd and od indexes may have their size forced, e.g. (bd).L or (od).W.  

Index registers default to size long, scale 1.  Note that scaling
is only available on the 68020 and above.  

In operand forms which include "bd" all parts are optional.  For example;

 ([A4],D3)
 ([$70],D2,$20)
 ([$70,A4],D2,$20)
 ([$70],$20)

For the MOVEM command, individual register names are seperated by the '/' and '-' characters.  For example:

 A0/D0 registers A0 and D0
 A0-A3 registers A0, A1, A2, A3
 A0/A2-A3/D4-D7  registers A0, A2, A3, D4, D5, D6, D7
3.1.1. Assembler directives

AS68K supports a wide variety of assembler directives for generating code and data.

3.2.1.  Values and Expressions

Values are numbers and are assumed to be of type integer unless a '.' character explictly appears in the number.  When a number is used as an address or as an index the upper bit is always used as a sign bit.  

An expression is any combination of numbers, and symbols combined with mathematical operators.  When an expression appears in lieu of a number, the assembler will evaluate the expression and use the resulting value.

Expressions may in general be used anywhere the assembler expects an integer value.  When an expression is used as the index for an addressing mode it must evaluate to be of proper size to fit or an error will be generated.  Global values may be used in expressions; however such expressions are actually evaluated by the linker rather than the assembler.  At present the assembler can only pass global expressions which contain addition and subtraction to the linker; care must be taken not to try to pass other types of operations to the linker as the evaluation will not proceed properly.

AS68K does not currently support evaluation of floating-point expressions.  

3.2.2. Number bases

Number bases can be applied to integer numbers but not to floating-point numbers.

For ASCII input files only three number bases are supported; base 2, base 10, and base 16.  TText input files additionally support base 8.  The default base for numbers that A68K encounters is base 10; however numbers may be prefixed with a symbol to specify the base.  Such symbols are:

 % or J Base 2
 K Base 8
 I Base 10
 $ Base 16

Other bases are not supported.  All floating point numbers must be entered in base 10.

3.2.3. Symbols

A symbol consists of a string of alphanumeric characters and the characteres '.' and '_'.  Symbols may not start with a '.'.  Symbols areused to make code more readable; any constant or expression may be assigned to a symbol with the 'EQU', 'SET' or '=' keywords.

3.2.4. Unary operators

Unary operators take precedence over binary operators.  The following unary operators are supported:

*7+
w + unary plus w
w - unary minus (negation) w
w ~ bitwise complement w
w ! logical complement w
w `SIZEOF take the size of an expression w
(7)

'SIZEOF returns the size of a label.  A label's size is only defined if the label is on a line with a DC, DS, DCB, or .STRUCT.  In each case thesize is the total size of all data described on that line or within the structure.

3.2.5. Binary operators

Binary operators each have associated precedence levels; operators
with a lower precedence will be evaluated prior to operators with a higher
precedence.  The following binary operators are supported:  


 1 >> or { shift right
 1 << or z shift left
 2 & bitwise and
 2 | bitwise or
 2 ^ bitwise xor

 3 * multiplication
 3 / division
 3 % modulus
 4 + addition
 4 - subtraction

 5 > Greater than.  Note that comparison symbols 
 will handle strings
 5 < Less than
 5 >= or 3 Greater than or equal to
 5 <= or 2 Less than or equal to
 6 == or ! Equal to
 6 != or % not equal to

 7 && Logical and
 8 || Logical or

Symbols and labels can be used in expressions.  If you use an expression as part of a pc-relative addressing mode, the result will be modified to be pc-relative.  It is unclear how useful such expressions will be.  

3.2.6.  Strings and characters

 This assembler follows the 'C' convention.  Single characterstrings are delimited by ' ' and multi-character strings are delimited by"".

3.3.1. Comments

Comments may start anywhere on a line and begin with a ';' character.  They continue until the end of the line.  Alternately if the file is TText format comments may be double boxed and code may occur after the comment completes.  An exception is that in macros comments must always appear at the end of a line.  Valid comments are:

 ; This is a comment

*7+
w This is a comment w
(7)

3.4.1. Labels and Sections

Labels are used to control the location of branches.  Sections are used to partition different parts of a single source file in such a way that they may be relocated independently of one another; this is the basis of a powerful system for managing target addresses that is continued in the linker.  

3.4.2. Labels

Labels must be the first thing on a line and may consist of any combination of alphanumeric characters, '.' and '_'.  Any label starting with a '.' has local context only, thus it will only be recognized between the preceding label without a '.' and the next label without a '.'.

The character ':' may be used after a label to clarify that it is a label; however this is optional.  This feature may cause some amount of confusion; for example a mispelling of the word 'nop' as 'nod' will cause th

e assembler to generate a label 'nod' rather than generating the code for 'nop'.

Labels may appear on a line by themselves.

Note that assembler keywords may not be used as a label.

3.4.3. SECTION and .REGION keywords

 The assembler keyword SECTION or REGION may be used to start a new section.  The default section is MAIN.  The section may be changed at any time, for example:

 SECTION code

Changes code generation to a section named Zcode[.  An arbitary section name can be used but must consist of alphanumeric characters.  The section name may be used in the linker specification file to control grouping ofsections in memory.  At link time the linker will combine all sections of the same name from different input files prior to evaluating grouping rules defined in the linker specification file.  There is no provision for specifying the load address of a program in the assembler; it assumes 0.  The linker relocates each section to the address specified in the specification file.


3.4.4. OFFSET keyword

The keyword OFFSET may be used to exit all sections.  For example:

 OFFSET  $C0

will exit the current section and default the program counter to $C0. At this time no code or data may be generated; however DS may be used toallocate space and labels may be defined.  Such labels are equivalent toEQU statements.  For example:

 OFFSET  $90
based:

is equivalent to:

based EQU $90.

This is also one way to generate a structure; for example:

 OFFSET 0
q.name  DS.B 10
q.link  DS.W 1
q.val DS.L 1
qREC:

defines a structure of length qREC with elements q.name, q.link, and q.val.

To resume code generation at the point it left off, use an appropriate
SECTION statement.

3.5.1. Data definition

The assembler recognizes two different types of data declarations.  The first is for symbolic definitions and the second is for embedding data within a section.  The keywords EQU, = and SET may be used to define a symbolic representation for things; the keywords DC, DS, DCB and TTEXT control embedding data in a section.  The TTEXT keyword is the only assembler function that is not available when the input file is ASCII.  

3.5.2. EQU and REG keywords

This is used to define a unique value to a symbol.  A value can be integer, real, a valid addressing mode, or a group of registers for use in the MOVEM opcode.  Values defined with EQU may not be redefined.  Examples are:

one EQU 1
two EQU 2.0
predec7  EQU -(A7)
saveregs REG A0/A2-A4/D3-d6

3.5.3. SET and = keywords

These assign a numeric value to a symbol.  Such symbols may be redefined at any time.  Examples are:

one = 1
two SET 2.0

3.5.4 DC keyword

This must be qualified with a size; e.g. DC.L or DC.X.  It takes a variable number of arguments and converts them to binary format.  If thesize is integer (.B, .W, .L) then each argument may be either a number or 
a string enclosed in '"' characters.  If the size is floating point 
(.S, .D. .X, .P) each argument is converted to extended format internally,
and then converted to the appropriate floating point format.

When the argument is a character string, the results will differ depending on the integer size selected.  Normally ASCII character strings will be embedded directly using a DC.B directive.  This results in the normal ASCII character string.  Use of a DC.W results in each character being of word size (e.g.) a zero is placed prior to each consecutive character.  Use of DC.L results in each character being of long size; thus three leading zeros are placed prior to each consecutive character.

When the input file is TText format, characters in strings are encoded slightly differently than the normal ASCII format.  Each word or long sized character will encompass the entire TText flat character, including
appropriate attribute fields.  

Examples:

 DC.B 10,13,"Hello World", 10, 13, 0
 DC.W 5,10,15,20
 DC.L 77,88,33,22
 DC.S 5.4, 2.2
 DC.D 7.93, 3.14
 DC.X 8.72E3, 77.0e-3
 DC.P 77.0, 33.1E2

3.5.5. DS keyword

This is used to reserve space.  The single argument is multiplied by thenumber of bytes in the size and the result is the number of bytes which are reserved.  For example:

 DS.B 4 ; reserves 4 bytes
 DS.W 3 ; reserves 6 bytes
 DS.L 2 ; reserves 8 bytes

3.5.6. DCB keyword

This is used to define a block of data with a common value.  It takes two arguments; the first is the number of items declared and the second is the item value.  The size of each item is given by the size specified in thedirective.  For example:

 DCB.W 10,50 ; reserves 10 words, each of which gets a value
 ; of 50.

3.5.7. TText keyword

This is used to generate a streamed TText string.  The string is enclosed in quotes; the assembler generates a streamed TText string which includes the current attributes as defined by the input stream.  This directive is only available when the input file is TText formatted.

Example:

 TText "TText string",0

3.5.8. MODE keyword

Mode is used to set the default data mode of data output in expressions defined with the DC keyword.  It can be used for example to define data as 'little endian' or 'big endian', but a wide variety of modes are supported.  The default does not affect any numbers other than those in DC and DCB statements; however modes can be individually applied to any number anywhere.  Using modes on numbers used in code generation may have adverse affects since the 680 series expects all numbers to be Big-Endian.  Modes can not be applied to floationg point numbers.  

Valid modes start with a '`' character.  Modes may be used in conjunction with any number anywhere; however the MODE command sets the default for DC and DCB commands.  Following is a list of valid modes:

`x
`xx
`x
`x 
 Each x is a number from 0-3.  The x values select the byte of a longword to select.  For example `0 selects the low byte.  `3210 selects the entire word with no bytes reversed.  `01 selects the low two bytes, zeros the upper twobytes, and swaps the lower two bytes
`LO Same as `0
`HI Same as `1
`NSame as `3210
`HSame as `10
`LSame as `01
`HHSame as `3210
`HLSame as `2301
`LHSame as `1032
`LLSame as `0123


3.6.1. Globals

 Using multi-module sources for large projects can help keep code manageable.  AS68K supports this with global references.

 Two types of global variables are supported; public references and external references.  Public references define labels that may be referenced in other modules.  External references define references to labels in other modules.  

3.6.2. XDEF keyword

 XDEF makes a variable global.  Other modules may use the variable and the linker will merge such references together.  Multiple symbols may be specified with the XDEF keyword; for example:  

 XDEF  a1,a2,a3,a4

3.6.3. XREF keyword

 XREF imports global labels defined in another file.  The assembler can work with such labels but it defers processing to the linker.  Multiple symbols may be declared with the XREF keyword; for example:  

 XREF one,two,three,four

3.7.1. Conditionals

 AS68K supports conditional assembly.  Basic conditional assembly is as follows:  

 .IF expression
 <statement block 1>
 .ELSE
 <statement block 2>
 .ENDIF

If expression evaluates to a non-zero value the statements in <statement block 1> are assembled; otherwise the statements in <statement block 2> are assembled.  The .ELSE and <statement block 2> are optional.  

Conditionals may be nested as far as memory allows.

A68K recognizes the .ELSEIF keyword in place of .ELSE; for example:

 .IF expression1
 <statement block 1>
 .ELSEIF expression2
 <statement block 2>
 .ELSEIF expression3
 <statement block 3>
 .ELSE
 <statement block 4>
 .ENDIF

AS68K Evaluates expression1; if it is non-zero <statement block 1> is assembled.  Otherwise A68K evaluates expression 2; if it is non-zere <statement block 2> is assembled.  Otherwise A68K evaluates expression 3; if it is non-zero <statement block 3> is assembled.  Otherwise <statement block 4> is executed.  .ELSEIF may be used as many times as desired.  

3.7.2 Opening conditionals with .IF

 The syntax is:

 .IF  expression

If expression is non-zero the first statement block in the .IF statement will be assembled.  There are a variety of shortcuts for the .IF statement; these are as follows:  

 IFEQ expression ; True if expression is zero
 IFNE expression ; True if expression is not zero
 IFLT expression ; True if expression < zero
 IFLE expression ; True if expression 2 zero
 IFGT expression ; True if expression > zero
 IFGE expression ; True if expression 3 zero
 IFC "string","string" ; True if the two strigns are the same
 IFNC "string","string" ; True if the strings are different

In addition there are a few extra IF statements:

 .IFB <string> ; True if string is blank
 .IFNB <string> ; True if string isn't blank
 .IFDIF <string1>,<string2> ; True if the two strings are different
 .IFNDIF  <string1>,<string2> ; True if the two strings are the same
 .IFDEF name ; Trueif name has been defined
 .IFNDEF  name ; True if the symbol name has not been defined

3.7.3. Closing conditionals with .ENDIF

 This keyword ends the current conditional.  If the entire conditional was itself in a conditional conditional assembly will resume at the state indicated by the higher-level conditional.  

 ENDC is a synonym to .ENDIF.  It is intended to be used in conjunction with the shortcut IF expressions.

3.7.4.  .ELSE and .ELSEIF

 These two keywords complement the state of conditional assembly.  If conditional assembly is previously enabled then no code will be assembled until the next .ENDIF or ENDC.  However, if conditional assembly is not previously enabled then the two keywords have differing effects.  

.ELSE turns on conditional assembly if it was not previously enabled.  .ELSEIF expression turns on conditional assembly if conditional assembly was not previously enabled and the associated expression evaluates to a non-zero value.  

3.8.1 Macro assembly

 AS68K supports macro assembly.  There are two parts to the useage of macros; the definition and the invocation.  When a macro is defined the text in the macro body is copied to memory.  When a macro is invoked the text is read from memory just as if it were an include file.  

Up to twenty arguments may be specified in a macro definition; if these arguments appear in the text of the macro then any arguments specified in the invocation of the macro will be text-substituted for each instance of the original argument.  Macros may be nested to the limits of memory; however argument substitutions are local in scope and if text appears in a nested macro that is an argument in the original macro it will not be substituted.  

 Example definition:

MakeMove MACRO text0, text1
 MOVE.L  text0, text1
 ENDM

 Example invocation:

newlabel MakeMove D0,A4

newlabel is optional.  This invocation will result in the code line:  

newlabel MOVE.L  D0,A4

At present there is no provision for putting the characters ' ' and ','into the text which is substituted for a macro argument; these characters are used by the macro handler to seperate arguments.  Arguments may be blank, which will result in the original text disappearing.  The start of a TText boxed comment on a line will terminate argument expansion for that line, as will the ';' character; thus it will not often be useful to put comments to the left of code within a macro body or its invocation.

3.8.2. Opening macro definitions with MACRO

The syntax for opening a macro definition is:

label MACRO arg1,arg2,arg3.

Label is the name of name of the macro.  Arguments are optional.  When a macro is invoked each line of the macro body is scanned and if any text appears which is a macro argument in the macro definition it will be replaced by the corresponding macro argument in the macro invocation.  Such replacements are straight text replacements.  Replacements cannot occur after a comment appears on the line.  

3.8.3. Exiting macros with MEXIT

If the MEXIT keyword is encountered during a macro expansion, macro expansion for the current level of macro is terminated.  Expansion resumes At the next lower macro level or from the source file if there is no nesting.  

3.8.4. Terminating macros with ENDM

When ENDM is encountered during a macro definition, the macro definition is terminated.

3.8.5  REPT macros

An additional type of macro, the REPT macro, has been included to allow
for some types of repeating expansion.  The macro takes this form:

 REPT expression
 .body.
 ENDM

The macro body is expanded the number of times given in expression.
The following example creates a tables with the numbers from 0 to 255:

value = 0
 REPT 256
 db value
 value = value +1
 ENDM

3.8.6. Predefined expansions

Within the text of a macro the following pre-defined expansions may be used:

 \@ unique macro number
 \# number of arguments passed
 \* concatenation of all arguments
 \: Label on macro invocation line
 \! Label on macro definition line (macro name)
 \0 Suffix specified on the macro invocation line

The macro number starts at 1 and increments each time a new macro expansion is started.  This is handy for automatically creating unique names for labels defined in macros.  

3.9.1 Structures

 A primitive structure mechanism has been included.  A structure is defined as follows:

name .STRUCT
 <declarations>
 .ENDSTRUCT

While in a structure definition no code will be emitted but labels can begenerated.  The location counter is reset to zero at the onset of the .STRUCT statement and DS may be used to allocate space for member items.  Use of .STRUCT and .ENDSTRUCT is identical to use of OFFSET to define labels.  The assembler does not treat structure labels any differently than normal labels, with one exception.  `SIZEOF may be used to find the
total size of a structure.

3.10.1.  Options

A variety of options have been implemented.  These control listing styles,coprocessor usage, generate messages at assembly time, and handle include files.

3.10.2.  .ALIGN

.ALIGN expression

Use this to force the alignment to a certain value.  Typically it will be used after a DC.b to force word alignment, since a label after a DC.b can leave the instruction pointer pointing at an odd address.  The next instruction or DC.w or DC.l will automatically correct the alignment however the label will possibly be off.  This can also be used to set other alignments; alignment information will be passed on to the linker.  Instructions are automatically word-aligned.

3.10.3. .EJECT

Page break will be placed in the listing file at this position.

3.10.4.  END

This ends all assembly if it is encountered.  It closes all conditionals, all macros, and all source files including nested includes and assembly comes to a halt for the current file.  If other files were specified in the command line they will be assembled next.  


3.10.5.  INCLUDE and #INCLUDE

INCLUDE "filename"
#INCLUDE "filename"
#INCLUDE <filename>

Use this to include a file.  Up to 10 levels of include files are supported.

3.10.6. LIST

Turn listing on.  This is ignored if /l is not present on command line.

3.10.7 MSG

MSG string

displays the string string on the console at assembly time.  

3.10.8. NOLIST

Turn listing off it is on.  

3.10.9 NOPAGE

Page breaks in the listing file are disabled.  

3.10.10. OPT and .OPTION

These keywords are reserved for use in controlling code generation.  Valid options are as follows:

.OPTION ifstyle = expression

 Expression selects the style to be used when expanding  conditionals in the listing file.  For a listing to be generated,  one of the /l /s /x switches must be present on the command line.

 Valid values of expression are:

 0 - show only code generated from the true parts of if statements.
 1 - same as mode zero, but also show conditional statements
 2 - expand if statements entirely, but don't expand macros in the  false parts of if statements.

.OPTIONmacstyle = expression
 
 Expression selects the style to be used when expanding macros in  the listing file.  For a listing to be generated, one of the /l /s  /xswitches must be present on the command line.

 Valid values of Expression are:

 0 - Invocation line only.  Expansion is not shown
 1 - Invocation line, plus expand ifs in style 1
 2 - Invocation line, plus expand ifs in style set by ifstyle
 3 - No invocation line, but expand ifs in style 1
 4 - Invocation line, plus expand ifs in style 2
 5 - Invocation line, but only show lines that generate code

.OPTION target = string

 String selects the target processor and may be "680","68010", "68020", "68030" or "CPU32".  Optionally a "/681" string may be added to specify use of the floating point processor.  This  assemblerwill also accept a processor number without quote  (except CPU32 must be enclosed in quotes) Opcodes and addressing  modes which are not available on the target selected will cause an  error to be generated.  The default mode of operation is 680.
.OPTIONxref = expression

 Exression selects the cross-reference mode.  Use "on" or a non- zero value to select cross-referencing.  Use "off" or a zero value  to select no cross referencing.  Cross references will not be  generated in any case if the /x switch is not present in the  command line.

3.10.11. PAGE

Enables page breaks in the listing file.

3.10.12. .SPACE

.SPACE  expression

Puts expression blank lines in the listing file.

3.10.13. SUBTTL

SUBTTL  string

Declares a subtitle to be used on the second line of each page in the list file.  By default there is no subtitle and the second line of each page is blank.  

3.10.14  TITLE

TITLE string

Declares the title to be used on the first line of each page in the list file.  The default title is 'UNTITLED'.  

4.1.1.  List file

The list file will be fairly self-explanatory.  Each line of the list file contains:  

 The include level
 The macro level
 The current instruction pointer
 Code or data bytes generated by the assembler
 The instruction which generated the code

At the present time there is no control over macro and conditional expansion; all macros and conditionals are fully expanded in the list file.  

The name of a list file will be the same as that of the original source, except the extension is changed to '.lis'.  A path specified on the command line is ignored and the list file appears in the current directory.

5.1.1. Object file

The object file is IE695 format.  See the document IE695.MAN for implementation details.  Any variable not defined within the section that is used cannot be evaluated fully by the assembler and is passed to the linker.  

Additionally a binary dump of the object file may be obtained.  Fixups are totally lost in this dump so it will not be very useful in general.  

The name of an object file will be the same as the name of the source file which produced it; however the extension will change to '.o'.  Any path specified on the command line will be ignored, and the file will appear in the current directory.  

When a binary dump is selected, the output file will have the extension
'.bin'.

6.1.1. Command line syntax

AS68K [/a/b/l/s/u/v/x/D/I/Vx] filelist

The /a switch generates dependency information in the .o file.

The /b switch generates a binary output file instead of the default
 relocatable output.

The /l switch produces a list file. the LIST keyword is ignored if /l is
 not specified

The /s switch produces a list file without a symbol dump

The /u switch forces symbols to be upper-case; otherwise symbols are
 case-sensitive.

The /v switch produces debug info in the .o file

The /x switch produces a list file with a cross-reference listing.

the /Vx switch determines the processor type.  x may be 680, 68010,
 68020, 68030, or CPU32 and may have an optional /681 to specify
 use of the floatinng point processor.  This switch equivalent to  putting .OPTIONSTARGET = in the source code
 
The /I switch specifies include directories.  The assembler first looks for
 include files in the current directory, then looks in each path
 specified with the /I switch.  If a path is given in the
 source file this switch is ignored for that source.  Include files
 which are not found terminate assembly.  

The /D switch is usedto define symbols at assembly time.  Symbols defined
 by the /D switch will be treated as EQU definitions; they may
 not be redefined.  An = sign is used to seperate the symbol
 name from its value.  No spaces are allowed in the argument.

Multiple source files may be specified on the command line, up to the limits of MS-DOS.  The assembler will process each source in turn until all files have been assembled.  Any source without an extension will default to an extension of .SRC.  At the end of each input file the assembler will generate a message telling how much memory is left over after processing the input files.

7.1.1. Things added for TText:

Greek, cyrillic, and extended accents may be used anywhere an alphabetic character may be used.  Only normal ASCII alphabetic characters will be case-insensitive in keywords, however.  Certain TText symbols will be recognized as keywords, but only when the input file is a TText file.  

Strings inherit the text sizes, styles, and colors from the TText input stream.  If the defaults of these text properties are used they will not be output at the beginning of TText streamed string; they will appear in the longword form of the flat strings however.  

The word form of flat characters has the bnk, cwb, and atb fields; other fields are stripped off.  Currently control characters other than the end of paragraph characters will probably cause a bank switch back to bank 0.  End of paragraph characters will cause immediately preceding attribute characters to disappear, including the bank switch character; however immediately after the end of paragraph character attribute characters will be put in the string if the attributes are non-default.  (except the bank will be 0 again) This means that a color change to be performed immediately after a '\n' for example is best done in the source file immediately before the '\n'; or two sets of attribute characters will be placed in the output string.  

Use of single quotes '' will convert a single character into a byte or word.  If the character in the quotes is an ASCII char or valid escape char (like '\r') then the character will have byte size; otherwise it will have word size.  Everything but the bnk and cwb fields are stripped off.  This usage of '' was selected so that we could still do byte comparisons for example on streamed TText or ASCII streams while enjoying the ability to also compare flat characters.  It is intended for use in such statements as:  

cmpi.b #'a',d0
or
cmpi.w #'t',d1

Comments can appear at the start, in the middle, or at the end of a line.  comments are delimeted by ';' char or by double line boxes: k7g
ww
ww
G7C
An exception to this rule is a comment may not appear at the beginning or middle of any line in a macro or macro invocation.  This limitation is due to the fact that the macro processor stops replacing arguments as soon as it discovers a comment character.  

Single line boxes are for beautification only and will be treated as whitespace.

The parser ignores TText attributes; except that any character that has the hidden bit set will be treated as whitespace.
