#include "emu.h"
#include "const.h"

void fchs()
{
  if (empty())
    return;
  st().sign ^= SIGN_POS^SIGN_NEG;
  status_word &= ~SW_C1;
}

void fabs()
{
  if (empty())
    return;
  st().sign = SIGN_POS;
  status_word &= ~SW_C1;
}

void ftst()
{
  switch (st().tag)
  {
    case TW_Z:
      setcc(SW_C3);
      break;
    case TW_V:
      if (st().sign == SIGN_POS)
        setcc(0);
      else
        setcc(SW_C0);
      break;
    case TW_S:
      if (val_same(st(), CONST_PINF))
      {
        setcc(0);
        break;
      }
      else if (val_same(st(), CONST_NINF))
      {
        setcc(SW_C3);
        break;
      }
      setcc(SW_C0|SW_C2|SW_C3);
      exception(EX_I);
      break;
    case TW_E:
      setcc(SW_C0|SW_C2|SW_C3);
      exception(EX_SU);
      break;
  }
}

void fxam()
{
  int c=0;
  switch (st().tag)
  {
    case TW_E:
      c = SW_C3|SW_C0;
      break;
    case TW_Z:
      c = SW_C3;
      break;
    case TW_V:
      if (st().sigh & 0x80000000)
        c = SW_C2;
      else
        c = SW_C3|SW_C2;
      break;
    case TW_S:
      if (val_same(st(), CONST_NAN))
        c = SW_C0;
      else if (val_same(st(), CONST_PINF))
        c = SW_C2|SW_C0;
      else if (val_same(st(), CONST_NINF))
        c = SW_C2|SW_C0;
      break;
  }
  if (st().sign == SIGN_NEG)
    c |= SW_C1;
  setcc(c);
}

FUNC emu_14_table[] = {
  fchs, fabs, emu_bad, emu_bad, ftst, fxam, emu_bad, emu_bad
};

void emu_14()
{
  if (modrm > 0277)
  {
    (emu_14_table[modrm&7])();
  }
  else
  {
    //
    emu_bad();
  }
}
