#include "emu.h"

void fclex()
{
  status_word &= ~(SW_B|SW_ES|SW_SF|SW_PE|SW_UE|SW_OE|SW_ZE|SW_DE|SW_IE);
}

void finit()
{
  control_word = 0x037e;
  status_word = 0;
  top = 0;
  for (int r=0; r<8; r++)
  {
    regs[r].sign = 0;
    regs[r].tag = TW_E;
    regs[r].exp = 0;
    regs[r].sigh = 0;
    regs[r].sigl = 0;
  }
}

FUNC emu_34_table[] = {
  emu_bad, emu_bad, fclex, finit, emu_bad, emu_bad, emu_bad, emu_bad
};

void emu_34()
{
  if (modrm > 0277)
  {
    (emu_34_table[modrm&7])();
  }
  else
  {
    //
    emu_bad();
  }
}
