/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <sys/time.h>
#include <sys/timeb.h>

extern int	gettimeofday(struct timeval *, struct timezone *);

int
ftime(struct timeb *tp)
{
    struct timeval tv;
    struct timezone tz;

    if (gettimeofday(&tv, &tz) < 0) return -1;

    tp->time = tv.tv_sec;
    tp->millitm = tv.tv_usec / 1000;
    tp->timezone = tz.tz_minuteswest;
    tp->dstflag = tz.tz_dsttime;

    return 0;
}
