/* This is file DALLOC.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/* History:22,22 */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>

#include "gotypes.h"
#include "valloc.h"
#include "dalloc.h"
#include "mono.h"
#include "control.h"

#define DA_FREE	0
#define DA_USED	1

#define MAX_DBLOCK 32760 /* 4095 * 8 -> 128 Mb */

static int dalloc_initted = 0;
static word8 map[4096];
static first_avail;
static int dfile = -1;
static word32 disk_used = 0;

extern int debug_mode;
extern transfer_buffer[];

static void dset(unsigned i, int b)
{
  unsigned o, m;
  o = i>>3;
  m = 1<<(i&7);
  if (b)
    map[o] |= m;
  else
    map[o] &= ~m;
}

static int dtest(unsigned i)
{
  unsigned o, m;
  o = i>>3;
  m = 1<<(i&7);
  return map[o] & m;
}

static char dfilename[80];

void dalloc_init(void)
{
  int i;
  char *tmp;
  tmp = getenv("GO32TMP");
  if (!tmp) tmp = getenv("GCCTMP");
  if (!tmp) tmp = getenv("TMP");
  if (!tmp) tmp = getenv("TEMP");
  if (!tmp) tmp = "/";
  if ((tmp[strlen(tmp)-1] == '/') || (tmp[strlen(tmp)-1] == '\\'))
    sprintf(dfilename, "%spg%04xXXXXXX", tmp, _CS);
  else
    sprintf(dfilename, "%s/pg%04xXXXXXX", tmp, _CS);
  for (i=0; i<4096; i++)
    map[i] = 0;
  dset(0, DA_USED);
  
  dalloc_initted = 1;
  if (show_memory_info)
  {
    fprintf(stderr, "Swap space available: %ld Kb\n", dalloc_max_size() * 4L);
  }
}

void dalloc_uninit(void)
{
  if (dfile == -1)
    return;
  close(dfile);
  unlink(dfilename);
}

unsigned dalloc(void)
{
  char buf[8];
  int i;
  unsigned pn;
  if (!dalloc_initted)
    dalloc_init();
  for (pn=first_avail; pn<=MAX_DBLOCK; pn++)
    if (dtest(pn) == DA_FREE)
    {
      dset(pn, DA_USED);
      first_avail = pn+1;
      disk_used++;
      if (topline_info)
      {
        sprintf(buf, "%6ldk", disk_used*4);
        for (i=0; i<7; i++)
          poke(screen_seg, (54+i)*2, buf[i]|0x0c00);
      }
      return pn;
    }
  fprintf(stderr, "Fatal: out of swap space!\n");
  return 0;
}

void dfree(unsigned pn)
{
  dset(pn, DA_FREE);
  if (pn < first_avail)
    first_avail = pn;
  disk_used--;
}

unsigned dalloc_max_size(void)
{
  word32 fr;
  struct REGPACK r;
  r.r_ax = 0x3600;
  if (dfilename[1] == ':')
    r.r_dx = dfilename[0] & 0x1f;
  else
    r.r_dx = 0;
  intr(0x21, &r);
  if (r.r_ax == 0xffff)
    return 0;
  fr = (word32)r.r_ax * (word32)r.r_bx * (word32)r.r_cx;
  fr /= 4096L;
  fr += (unsigned long)disk_used;
  if (fr > MAX_DBLOCK)
    fr = MAX_DBLOCK;
  return (unsigned)fr;
}

unsigned dalloc_used(void)
{
  return (unsigned)disk_used;
}

void dwrite(word8 *buf, unsigned block)
{
  int c;
  if(dfile < 0) {
    mktemp(dfilename);
    dfile = open(dfilename, O_RDWR|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE|S_IREAD);
    if (dfile < 0)
    {
fprintf(stderr, "Fatal! cannot open swap file %s\n", dfilename);
exit(1);
    }
    write(dfile, "go32 paging file\r\n\r\n\x1a", 22);
  }
  lseek(dfile, (long)block*4096L, 0);
  c = write(dfile, buf, 4096);
  if (c < 4096)
  {
    fprintf(stderr, "Fatal! disk full writing to swap file\n");
    exit(1);
  }
}

void dread(word8 *buf, unsigned block)
{
  lseek(dfile, (long)block*4096L, 0);
  read(dfile, buf, 4096);
}
