/*------------------------------------------------------------
 * 
 *  wrefresh.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  this is the window output function
 *
 *----------------------------------------------------------*/

#include "curses.h"

int
wrefresh(win)
WINDOW  *win;
{
    int row;
    int clearscr = 0;

    if (curscr->flags & _WCLEAR) {
        clearscr = 1;
        curscr->flags &= ~_WCLEAR;
    }

    if ((win->flags & _WFULLWIN) && (win->flags & _WCLEAR)) {
        clearscr = 1;
        win->flags &= ~_WCLEAR;
    }

    if (clearscr)
        vid_clr_scr(curscr->attrib);
    
    if (win == curscr) {
        int maxy, maxx;
        
        maxy = getmaxr(curscr);
        maxx = getmaxc(curscr) + 1;
        for (row = 0; row <= maxy; row++)
            vid_upd_scr(row, 0, curscr->buf[row], maxx);

    } else if ((win->flags & _WDIRTY) && win->firsty != INT_MAX) {
        int scrrow, scrcol, cnt, lasty;
		
        row = win->firsty;
        scrcol = win->orgx;
        scrrow = row + win->orgy;
        cnt = win->maxx + 1;
        lasty = win->lasty;
        
        for (; row <= lasty; row++, scrrow++) {
            vid_upd_scr(scrrow, scrcol, win->buf[row], cnt);
            memcpy(curscr->buf[scrrow] + scrcol, win->buf[row], 
                cnt*sizeof(VIDCHR));
        }
    }

    if (win != curscr) {
        curscr->cury = win->orgy + win->cury;
        curscr->curx = win->orgx + win->curx;
        umarkwin(win);
    }

    vid_mov_curs(curscr->cury, curscr->curx);

    return OK;
}

