/**********************************************************************
 *  
 *  NAME:           box.cpp
 *  
 *  DESCRIPTION:    box/unbox a window
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  08/14/90    J. Alan Eldridge    created
 *  
 *  11/30/90    JAE                 taken from UWin++ 1.00
 *  
 *********************************************************************/

#include    "w.h"

void
basewin::box(
    int yul,
    int xul,
    int ylr,
    int xlr,
    int vChr,
    int hChr,
    int fillFlg,
    int fillChr)
{    
    uchar   corners[4];
    uchar   vert, horz;
        
    int rows = ylr - yul + 1;
    int cols = xlr - xul + 1;
       
    if (rows < 2 || cols < 2) 
        return;
    
    if ((hChr == boxLine1 || hChr == boxLine2)
        && (vChr == boxLine1 || vChr == boxLine2)) {
        int vsel = vChr == boxLine1 ? SINGLE_LINE : DOUBLE_LINE;
        int hsel = hChr == boxLine1 ? SINGLE_LINE : DOUBLE_LINE;

        vert = linechar(vsel, LINE_VERT);
        horz = linechar(hsel, LINE_HORZ);
        
        for (int i = 0; i < 4; i++)
            corners[i] = cornerchar(i, vsel, hsel);
    } else {
        vert = vChr;
        horz = hChr;
        
        for (int i = 0; i < 4; i++)
            corners[i] = vert;
    }

    clrline(yul, xul + 1, cols - 2, horz, att);
    clrline(ylr, xul + 1, cols - 2, horz, att);
    
    for (int y = yul + 1; y < ylr; y++) {
        vidptr(y, xul)->put(vert, att);
        vidptr(y, xlr)->put(vert, att);
        if (fillFlg)
            clrline(y, xul + 1, xlr - 1, fillChr, att);
    }
    
    vidptr(yul, xul)->put(corners[0], att);
    vidptr(yul, xlr)->put(corners[1], att);
    vidptr(ylr, xlr)->put(corners[2], att);
    vidptr(ylr, xul)->put(corners[3], att);
}

void
basewin::frame(
    int vchr,
    int hchr,
    int fillflg,
    int fillchr)
{
    fullport();
    box(vchr, hchr, fillflg, fillchr);
    fFrame = TRUE;
    yUL++; xUL++;
    yLR--; xLR--;
    setpos(0,0);
}
        
void
basewin::closebox()
{
    int y, x;
    getpos(y, x);

    viewport    port = getport();
    fullport();

    setpos(0, 2);
    put("[\xFE]");

    setport(port);
    setpos(y, x);
    fCloseBox = TRUE;
}

