/**********************************************************************
 *  
 *  NAME:           vidbuf.cpp
 *  
 *  DESCRIPTION:    methods for video buffer class
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/25/90    J. Alan Eldridge    created
 *  
 *********************************************************************/

#include    "w.h"

void
vidbuf::open(
    int yUl,    
    int xUl,
    int yLr,
    int xLr)
{
    int r = yLr - yUl + 1;
    int c = xLr - xUl + 1;
    
    state = ERR;

    //  check for bad args, or failure to init the system
    if (!r || !c || yUl < 0 || xUl < 0 || yLr >= vid_ROWS
            || xLr >= vid_COLS || initscr(LASTMODE) != OK)
        return;

    //  allocate buffer and, if ok, init member vars
    if (pbuf = new vidchr [ r * c ]) {
        state = OK;
        yCur =
        xCur = 0;
        rows = r;
        cols = c;
        yOrg = yUl;
        xOrg = xUl;
    }
}

//  free up memory, etc.

void
vidbuf::close()
{
    if (state == OK) {
        state = ERR;
        delete [ rows * cols ] pbuf;
    }
}
        
//  clear part of a line

void
vidbuf::clrline(
    int row,
    int left,
    int right,
    int chr,
    int att)
{
    if (state != OK)
        return;
        
    int     cnt = right - left + 1;
    vidchr  *dst = vidptr(row, left);
    
    for (int n = 0; n < cnt; n++)
        dst[n].put(chr, att);
}        

//  clear a rectangular area

void
vidbuf::clear(
    int yul,
    int xul,
    int ylr,
    int xlr,
    int chr,
    int att)
{
    if (state != OK) 
        return;
    
    //  keep in bounds
    if (ylr >= rows) ylr = rows-1;
    if (xlr >= cols) xlr = cols-1;

    //  do the fills
    int     cnt = xlr - xul + 1;
    vidchr  *dst = vidptr(yul, xul);
    
    for (int row = yul; row <= ylr; row++, dst += cols) {
        for (int n = 0; n < cnt; n++)
            dst[n].put(chr, att);
    }
}

//  update to Screen and maybe video display

void
vidbuf::display(int row, int col, int cnt, int vflag)
{
    if (this != &Screen)
        Screen.write(yOrg+row,xOrg+col,vidptr(row,col),cnt);
    if (vflag)
        vid_write(yOrg+row,xOrg+col,vidptr(row,col),cnt); 
}

void
vidbuf::setcursor(int vflag)
{
    if (this != &Screen)
        Screen.setpos(yCur+yOrg,xCur+xOrg);
    if (vflag)
        vid_setcpos(yCur+yOrg,xCur+xOrg); 
}

//  update to display screen (entire buffer)

void
vidbuf::refresh(int vflag)
{
    if (state != OK) return;

    for (int r = 0; r < rows; r++) {
        display(r, 0, cols, vflag);
    }
    setcursor(vflag);
}
    
//  check if pointing device is in window
//  if so, modify coordinates so they are window relative

int
vidbuf::inwindow(
    int &y,
    int &x)
{
    if (y >= yOrg && y < yOrg + rows
            && x >= xOrg && x < xOrg + cols) {
        y -= yOrg;
        x -= xOrg;
        return TRUE;
    } else
        return FALSE;
}

//  copy from Screen object ...
//  a refresh will restore the screen

void
vidbuf::cpscreen()
{
    for (int y = yOrg, r = 0; r < rows; y++, r++)
        Screen.read(y, xOrg, vidptr(r, 0), cols);
    Screen.getpos(yCur, xCur);
    yCur -= yOrg; xCur -= xOrg;
}
