#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>

typedef struct _chr_ {
    struct _chr_ *next;
    int  code;
    int  width;
    char **bmp;
} chr;

typedef struct {
    char name[100];
    char family[100];
    char slant[100];
    char weight[100];
    int  isfixed;
    int  minchar;
    int  maxchar;
    int  height;
    int  minwidth;
    int  maxwidth;
    int  avgwidth;
    int  baseline;
    int  undwidth;
    chr  *chars;
} font;

typedef struct {
    char namepattern[100];
    char family[100];
    int  minchar;
    int  maxchar;
    int  isfixed;
    int  do_centerwdt;
    int  do_centerhgt;
    int  do_prop2fix;
    int  do_fix2prop;
    int  do_resize;
    int  do_show;
    int  do_edit;
    int  res_wdt;
    int  res_hgt;
    int  intype;
    int  outtype;
    int  verbose;
} options;

#define UNK	0
#define BDF	1
#define FNA	2
#define FNT	3
#define _C_	4
#define DIR	5

#ifndef EXTERN
#define EXTERN extern
#endif

EXTERN FILE *infile;
EXTERN FILE *outfile;
EXTERN char inname[100];
EXTERN char outname[100];
EXTERN char notes[10000];
EXTERN font fnt;
EXTERN options opt;

extern void fatalerr(char *msg,...);
extern void *safemalloc(int size);
extern char **makebytemap(int w,int h);
extern void copybytemap(char **dp,int dx,int dy,char **sp,int sx,int sy,int w,int h);
extern void setbytemap(char **bp,int value,int x,int y,int w,int h);
extern int  rowbit(char **bmp,int row);
extern int  colbit(char **bmp,int col);
extern chr  *getchr(int code);
extern void openinput(char *name,char *mode);
extern void openoutput(char *name,char *mode);
extern void closeinput(void);
extern void closeoutput(void);
extern char *readline(void);
extern void computewidth(void);
extern void splitfamily(void);
extern int  strmatch(char *arg,char *pat);

extern void readbdf(void);
extern void readfna(void);
extern void readfnt(void);
extern void readc(void);

extern void writefna(void);
extern void writefnt(void);
extern void writec(void);
extern void writedir(int argc,char **argv);

extern void processfonts(int argc,char **argv);

extern void showfont(void);
extern void editfont(void);
extern void cvtfix2prop(void);
extern void cvtprop2fix(void);
extern void centerwidth();
extern void centerheight();

