#include "fntool.h"
#include <stdarg.h>

void fatalerr(char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	fprintf(stderr,"\nFATAL ERROR: ");
	vfprintf(stderr,msg,ap);
	putc('\n',stderr);
	va_end(ap);
	if(infile != NULL)
	    fclose(infile);
	if(outfile != NULL) {
	    fclose(outfile);
	    unlink(outname);
	}
	exit(1);
}

void *safemalloc(int size)
{
	void *result = malloc(size);

	if(result == NULL) fatalerr("out of memory");
	memset(result,0,size);
	return(result);
}

char **makebytemap(int w,int h)
{
	int  ii = (w * h * sizeof(char)) + (h * sizeof(char *));
	char *bitmap,**result = (char **)safemalloc(ii);

	bitmap = (char *)(&result[h]);
	for(ii = 0; ii < h; ii++,bitmap += w) result[ii] = bitmap;
	return(result);
}

void copybytemap(char **dp,int dx,int dy,char **sp,int sx,int sy,int w,int h)
{
	while(--h >= 0) memcpy(&dp[dy+h][dx],&sp[sy+h][sx],w);
}

void setbytemap(char **bp,int value,int x,int y,int w,int h)
{
	while(--h >= 0) memset(&bp[y+h][x],value,w);
}

int rowbit(char **bmp,int row)
{
	int ii;

	for(ii = fnt.height; --ii >= 0; )
	    if(bmp[row][ii] != 0) return(1);
	return(0);
}

int colbit(char **bmp,int col)
{
	int ii;

	for(ii = fnt.maxwidth; --ii >= 0; )
	    if(bmp[ii][col] != 0) return(1);
	return(0);
}

chr *getchr(int code)
{
	chr *cp;

	for(cp = fnt.chars; cp != NULL; cp = cp->next)
	    if(cp->code == code) return(cp);
	return(NULL);
}

void closeinput(void)
{
	if(infile != NULL) {
	    fclose(infile);
	    infile = NULL;
	    inname[0] = '\0';
	}
}

void closeoutput(void)
{
	if(outfile != NULL) {
	    int waserror = ferror(outfile);
	    fclose(outfile);
	    outfile = NULL;
	    if(waserror) {
		unlink(outname);
		fatalerr("error writing output file \"%s\"",outname);
	    }
	    outname[0] = '\0';
	}
}

void openinput(char *name,char *mode)
{
	if(infile != NULL)
	    closeinput();
	if((infile = fopen(name,mode)) == NULL)
	    fatalerr("can not open input file \"%s\"",name);
	strcpy(inname,name);
}

void openoutput(char *name,char *mode)
{
	if(outfile != NULL)
	    closeoutput();
	if((outfile = fopen(name,mode)) == NULL)
	    fatalerr("can not create output file \"%s\"",name);
	strcpy(outname,name);
}

char *readline(void)
{
	static char buff[300];

	if(fgets(buff,299,infile) == NULL)
	    fatalerr("unexpected end of input file \"%s\"",inname);
	return(buff);
}

void computewidth(void)
{
	chr  *cp;
	long totalwdt = 0;

	fnt.minwidth = 32000;
	fnt.maxwidth = -32000;
	for(cp = fnt.chars; cp != NULL; cp = cp->next) {
	    if(fnt.maxwidth < cp->width) fnt.maxwidth = cp->width;
	    if(fnt.minwidth > cp->width) fnt.minwidth = cp->width;
	    totalwdt += cp->width;
	}
	fnt.avgwidth = totalwdt / (fnt.maxchar - fnt.minchar + 1);
}

int strmatch(char *arg,char *pat)
{
	while(*pat != '\0') {
	    if(tolower(*arg) != tolower(*pat)) return(0);
	    arg++;
	    pat++;
	}
	return(1);
}

void splitfamily(void)
{
	char *p;

	if((p = strrchr(fnt.family,'_')) != NULL) {
	    if(strmatch(p,"_ital")) {
		strcpy(fnt.slant,"ital");
		*p = '\0';
	    }
	}
	if((p = strrchr(fnt.family,'_')) != NULL) {
	    if(strmatch(p,"_bold")) {
		strcpy(fnt.weight,"bold");
		*p = '\0';
	    }
	    if(strmatch(p,"_thin")) {
		strcpy(fnt.weight,"thin");
		*p = '\0';
	    }
	    if(strmatch(p,"_demi")) {
		strcpy(fnt.weight,"demi");
		*p = '\0';
	    }
	}
}

