/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Include/Gadgets/Edition.H
   Author    : Eric NICOLAS
   Overview  : EditLine objects
   UpDate    : May 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GADGETS_EDITION_H_
#define _GADGETS_EDITION_H_

extern short RegTEditLine;
extern short RegTEditReal;
extern short RegTEditInteger;
extern char *IdentTEditLine;
extern char *IdentTEditReal;
extern char *IdentTEditInteger;

struct TEditLine : TZone
{ char*     Text;
  char*     NewText;
  char*     TempText;
  char      LengthText;
  char      LengthDraw;
  char      BegText;
  char      Cursor;
  char      Deplacement;
  // Constructor / Destructor
  TEditLine();
  TEditLine(int X, int Y, int L, char Lt, char Dpl);
  TEditLine(TRect& R, char Lt, char Dpl);
  ~TEditLine(void);
          void Init(char Lt=0, char Dpl=0);
  // Drawings
  virtual void Draw(TRect& Clip);
          void DrawText(void);
          void DrawCursor(void);
  // Data exchange
  virtual void SetData(void *Ptr);
  virtual void GetData(void *Ptr);
  virtual long DataSize(void);
  // Selection
  virtual void Select(void);
  virtual void UnSelect(void);
  // Events handling
  virtual void HandleEvent(TEvent* Event);
  // Entry validation
  virtual int  ValidInput(int& ScanCode);
  virtual int  ValidResult(void);
  // Actions of keyboard
  void CursorLeft(void);
  void CursorRight(void);
  void CursorHome(void);
  void CursorEnd(void);
  void Insertion(char C);
  void Recover(char C);
  void BackSpace(void);
  void Delete(void);
  // Objects stream
  TAtom *Duplicate(void);
};

struct TEditReal : TEditLine
{ // Constructor
  TEditReal();
  TEditReal(int X, int Y, int L);
  TEditReal(TRect& R);
  Init();
  // Data exchange
  virtual void SetData(void *Ptr);
  virtual void GetData(void *Ptr);
  virtual long DataSize(void);
  // Entry validation
  virtual int  ValidInput(int& ScanCode);
  virtual int  ValidResult(void);
  // Objects stream
  TAtom *Duplicate(void);
};

struct TEditInteger : TEditLine
{ // Constructor
  TEditInteger();
  TEditInteger(int X, int Y, int L);
  TEditInteger(TRect& R);
  Init();
  // Data exchange
  virtual void SetData(void *Ptr);
  virtual void GetData(void *Ptr);
  virtual long DataSize(void);
  // Entry validation
  virtual int  ValidInput(int& ScanCode);
  virtual int  ValidResult(void);
  // Objects stream
  TAtom *Duplicate(void);
};

// Expansion of inline functions

TAtom *TEditLine::Duplicate(void)
{ return new TEditLine();
}

TAtom *TEditReal::Duplicate(void)
{ return new TEditReal();
}

TAtom *TEditInteger::Duplicate(void)
{ return new TEditInteger();
}

#endif // _GADGETS_EDITION_H_
