/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Graphics/FontSys.H
   Author    : Olivier PAYEN, Eric NICOLAS
   Overview  : Font managing
   UpDate    : Dec 19, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_FONTSYS_H_
#define _GRAPHICS_FONTSYS_H_

#define FFace_NORMAL   0
#define FFace_BOLD     1
#define FFace_ITALIC   2

#define FBack_NOCOLOR  GrNOCOLOR

struct TFont
{ GrFont      *Fonts[4];
  GrTextOption Options;
  int          UnderLineOption;
  // Constructor / Destructor
          TFont(char *Name);
  virtual ~TFont();
  // Choosing the font's attributes
          void     ChooseFace(int Face);
          void     UnderLine(boolean UL);
          void     BackColor(int Color);
  // Choosing the font's alignment
          void     XAlignLeft(void)    { Options.txo_xalign=GR_ALIGN_LEFT;   }
          void     XAlignCenter(void)  { Options.txo_xalign=GR_ALIGN_CENTER; }
          void     XAlignRight(void)   { Options.txo_xalign=GR_ALIGN_RIGHT;  }
          void     XAlignDefault(void) { Options.txo_xalign=GR_ALIGN_LEFT;   }
          void     YAlignUp(void)      { Options.txo_yalign=GR_ALIGN_TOP;    }
          void     YAlignCenter(void)  { Options.txo_yalign=GR_ALIGN_CENTER; }
          void     YAlignDown(void)    { Options.txo_yalign=GR_ALIGN_BOTTOM; }
          void     YAlignDefault(void) { Options.txo_yalign=GR_ALIGN_TOP;    }
          void     AlignDefault(void)  { XAlignDefault(); YAlignDefault();   }
  // Using the font
          int      WidthStr(char *Text);
          int      HeightStr(char *Text=NULL);
          void     TruncStr(int Width, char *Text, char *Result);
          void     PutStr(int X, int Y, char *Text, int Color);
  // Using the font with system text
          int      WidthSysStr(char *Text);
          void     TruncSysStr(int Width, char *Text, char *Result);
          void     PutSysStr(int X, int Y, char *Text, int Color);
};

extern TFont *FontSystem;
extern TFont *FontListing;

void InitFont();
void DoneFont();

#endif // _GRAPHICS_FONTSYS_H_
