/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Gadgets/Mapping.H
   Author    : Olivier PAYEN, Eric NICOLAS
   Overview  : TMapping Object : How to display bitmap
   UpDate    : Jan 11, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GADGETS_MAPPING_H_
#define _GADGETS_MAPPING_H_

extern short RegTMappingObject;
extern char *IdentTMappingObject;

void InitMapping();
void DoneMapping();

#define MAP_Delete         1
#define MAP_DelDescription 2

struct TMapping
{ GrPattern *Drawing;
  int        Width,Height;
  int        Options;
  // Constructors
	      TMapping();
	      TMapping(int L, int H, char *Description, int *ColorTable);
  virtual ~TMapping();
          void     Init(GrPattern *_Drawing=NULL);
  // Graphics
          void     Draw(int X, int Y);
  virtual void     SetColorGroup(char ColorGroup);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

struct TIcone : TMapping
{ // Constructors
	      TIcone();
	      TIcone(int L, int H, char *Description);
	      void Init();
};

struct TSysIcone : TMapping
{ char *Description;
  char  ColorGroup;
  // Constructors
	      TSysIcone();
	      TSysIcone(int L, int H, char *_Description);
  virtual ~TSysIcone(void);
	      void     Init(char *_Description=NULL);
  // Graphics
  virtual void     SetColorGroup(char _ColorGroup);
  // Objects streams
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
};

struct TMappingObject : TZone
{ TMapping *Mapp;
  // Constructor / Destructor
	       TMappingObject();
	       TMappingObject(int X, int Y, TMapping *_Mapp);
	       void    Init(TMapping *_Mapp=NULL);
  virtual ~TMappingObject(void);
           void    Done(void);
  // Graphics
  virtual void     Draw(TRect& Clip);
  virtual void     SetColorGroup(char ColorGroup);
  // Objects streams
  virtual TAtom*   Duplicate(void);
};

// Inline functions

inline TAtom* TMappingObject::Duplicate(void)
{ return new TMappingObject();
}

#endif // _GADGETS_MAPPING_H_
