/* Project SWORD
   V2.0

   SubSystem : Image manipulation tools
   File      : Include/ToolBox/Image/ImgFile.H
   Author    : Cedric JOULAIN, Eric NICOLAS
   Overview  : TImageFile Object
   UpDate    : Nov 11, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_IMAGE_IMGFILE_H_
#define _TOOLBOX_IMAGE_IMGFILE_H_

// Support for file-formats :
//    JPG, BMP, GIF, TGA, PPM, RLE

struct TImageFile
{ // Datas
  // :: Raw representation
  int       Height, Width;
  byte      *R, *G, *B;
  // :: Screen representation
  GrContext *GC;
  // Constructor / Destructor
			TImageFile(int W, int H);
  virtual ~TImageFile(void);
  // File access
  void Load(char *Name);
  void Save(char *Name);
  // Drawing on the image functions
  void BeginDraw(void);
  void EndDraw(void);
  // Screen functions
  void RawToScreen(void);
  void Draw(int Xs, int Ys, int Xd, int Yd, int W, int H);
};

#endif // _TOOLBOX_IMAGE_IMGFILE_H_