/* Project SWORD
   V2.0

   SubSystem : Basic functions usefull for all the system
   File      : Src/Common/Basic.CC
   ErrNos    : 200..299
   Author    : Eric NICOLAS
   Overview  : Some usefull functions. Get path to the system.
   UpDate    : Nov 13, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include <time.h>
#include <dos.h>

#ifdef __TURBOC__
  #include <dir.h>
#endif

// ===== Global Variables ===================================================

char *SwordPath;
char *AppPath;
char *SwordVer    = "2.00a";
char  inPointChar = ',';

// ===== Local Variables ====================================================

static char *Messages[1] =
      { "Environement variable SWORDPATH missing"
      };

// ===== Usefull Functions ==================================================

//---------------------------------------------------------------------------
// ToAntiSlash

void ToAntiSlash(char *S)
{ char *P=S;
  while(*P)
  { if (*P=='/') *P='\\';
    P++;
  }
}

//---------------------------------------------------------------------------
// ToSlash

void ToSlash(char *S)
{ char *P=S;
  while(*P)
  { if (*P=='\\') *P='/';
    P++;
  }
}

//---------------------------------------------------------------------------
// GetCurDir

void GetCurDir(char *S)
{
#ifdef __TURBOC__
  getcwd(S,300);
  ToSlash(S);
#else
  union REGS r;
  r.h.ah=0x19;
  intdos(&r,&r);
  S[0]=r.h.al+'A';
  S[1]=':';
  getwd(S+2);
  if (*(S+strlen(S)-1)!='/') strcat(S,"/");
#endif
}

//---------------------------------------------------------------------------
// Random

int Random(int Max)
{
#ifdef __TURBOC__
  return random(Max);
#else
  return (int)((float)random()*(Max-1)/2147483647);
#endif
}

//---------------------------------------------------------------------------
// GetTime

long GetTime(void)
{
#ifdef __TURBOC__
  return (long)((float)clock()*100/CLK_TCK);
#else
  return (long)((float)clock()*100/1000000);
#endif
}

//---------------------------------------------------------------------------
// Delay

void Delay(long NCentSeconds)
{ long Dep=GetTime();
  do ;
  while(GetTime()-Dep<NCentSeconds);
}

void RemoveTABS(char *Str, int TabLength)
{ char Buffer[500];
  char TabFill[11]="          ";
  char *P=strchr(Str,'\t');
  TabFill[TabLength]=0;
  while(P!=NULL)
  { *P=0;
    sprintf(Buffer,"%s%s%s",Str,TabFill,P+1);
    strcpy(Str,Buffer);
    P=strchr(Str,'\t');
  }
}

// ===== Gestion loacle des erreurs =========================================

static boolean ErrorMessages(char *Message)
{ int MessageNo;
  switch(Error)
  { case erSWORDPATHmissing:    MessageNo=0;   break;
    default:
      return FALSE;
  }
  strcpy(Message,Messages[MessageNo]);
  return TRUE;
}

// ===== Init/Done de l'unit ===============================================

//---------------------------------------------------------------------------
// InitBasic

void InitBasic(char *Arg)
{ AddErrorHandler(ErrorMessages);
  //
  char *Tmp;
  SwordPath=(char*)SafeMAlloc(300);
  AppPath=(char*)SafeMAlloc(300);
  if (Error) ErrorViewer();
  Tmp=getenv("SWORDPATH");
  if (Tmp==NULL)
  { Error=erSWORDPATHmissing;
    ErrorViewer();
  }
  strcpy(SwordPath,Tmp);
  strcpy(AppPath,Arg);
  // SwordPath et AppPath viennent du DOS,
  // il faut donc tre sur qu'on a pas d'anti-slash
  ToSlash(SwordPath);
  ToSlash(AppPath);
  // Ajoute si besoin est un /  la fin de SwordPath
  Tmp=SwordPath+strlen(SwordPath)-1;
  if (*Tmp!='/')
  { Tmp[1]='/';
    Tmp[2]=0;
  }
  // Enlve le nom de l'application  la fin de AppPath
  Tmp=AppPath+strlen(AppPath)-1;
  while(*Tmp!='/') Tmp--;
  *(Tmp+1)=0;
  // Passe en majuscule les deux noms
  strupr(SwordPath);
  strupr(AppPath);
  // Affiche les infos d'initialisation
  clrscr();
  textattr(0x1F);
  gotoxy(1,1);clreol();cprintf("SWORD  V%s",SwordVer);
  gotoxy(40,1);cprintf("Copyright (C) 1993, 1995 The SWORD Group");
  textattr(0x07);
  gotoxy(1,4);
#ifdef __TURBOC__
  printf("TurboC++ version. Limited to 640x480 16 colors graphics\n\n");
#else
  printf("DJGPP protected mode version.\n\n");
#endif
  printf("Paths to system areas : SwordPath      = %s\n",SwordPath);
  printf("                        AppPath        = %s\n",AppPath);
  // Sortie des infos sur le dbug pour trace.
  Debug("  BASIC...     SwordPath      = %s\n",SwordPath);
  Debug("               AppPath        = %s\n",AppPath);
}

//---------------------------------------------------------------------------
// DoneBasic

void DoneBasic(void)
{ SafeFree((void**)(&SwordPath));
  SafeFree((void**)(&AppPath));
}
