/* Project SWORD
   V2.0

   SubSystem : Little usefull graphical objects
   File      : Src/Gadgets/Box.CC
   Author    : Eric NICOLAS
   Overview  : TGroupBox, TItemBox, TCheckBox, TRadioBox : Common controls
   UpDate    : Oct 23, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

// ----- TGroupBox

short RegTGroupBox;
char *IdentTGroupBox = "TGroupBox";

// Constructors

TGroupBox::TGroupBox(int X, int Y, int L, int H, char *_Text) :
   TZone(X,Y,L,H)
{ Init(_Text);
}

TGroupBox::TGroupBox() : TZone()
{ Init();
}

TGroupBox::TGroupBox(TRect& R, char *_Text) : TZone(R)
{ Init(_Text);
}

void TGroupBox::Init(char *_Text)
{ Register=RegTGroupBox;
  Ident=IdentTGroupBox;
  GetOptions(opSelectable | opGetAllEvents);
  Value=0;
  if (_Text!=NULL)
  { Text=(char*)malloc(strlen(_Text)+3);
    sprintf(Text," %s ",_Text);
  }
  else Text=NULL;
}

TGroupBox::~TGroupBox(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TGroupBox::Done(void)
{ if (Text!=NULL) free(Text);
  TZone::Done();
}

// Graphics

void TGroupBox::Draw(TRect& )
{ if (Where.L()+Where.H()==0) return;
  SetSysColor(GetColor(1));
    LineX(0,6,Where.L()-1);
    LineY(0,7,Where.H()-1);
    LineX(2,Where.H()-2,Where.L()-2);
    LineY(Where.L()-2,8,Where.H()-3);
  SetSysColor(GetColor(3));
    LineX(1,7,Where.L()-1);
    LineY(1,8,Where.H()-1);
    LineX(3,Where.H()-1,Where.L()-1);
    LineY(Where.L()-1,8,Where.H()-2);
  if (Text!=NULL)
  { SetSysColor(GetColor(0));
    FontSystem->BackColor(NoSysColor[GetColor(2)]);
    PutStr(10,0,Text,FontSystem);
    FontSystem->BackColor(FBack_NOCOLOR);
  }
}

// Data exchange

long TGroupBox::DataSize()
{ return TZone::DataSize()+sizeof(int);
}

void TGroupBox::SetData(void *Rec)
{ TZone::SetData(Rec);
  Value=*((int*)Rec);
  Invalidate();
}

void TGroupBox::GetData(void *Rec)
{ TZone::SetData(Rec);
  *((int*)Rec)=Value;
}

// Objects streams

void TGroupBox::Read(TDisk *file)
{ TZone::Read(file);
  if (Text!=NULL) free(Text);
  ReadString(file,&Text);
}

void TGroupBox::Write(TDisk *file)
{ TZone::Write(file);
  WriteString(file,Text);
}

// ----- TItemBox

short RegTItemBox;
char *IdentTItemBox = "TItemBox";

TItemBox::TItemBox(int X, int Y, int L, int _Options, char *_Text) :
  TButton(X,Y,L,16,0,0,_Options)
{ Init(_Text);
}

TItemBox::TItemBox(TRect& R, int _Options, char *_Text) :
  TButton(R.X1(),R.Y1(),R.L(),16,0,0,_Options)
{ Init(_Text);
}

TItemBox::TItemBox() : TButton()
{ Init();
}

void TItemBox::Init(char *_Text)
{ Register=RegTItemBox;
  Ident=IdentTItemBox;
  if (_Text==NULL) Text=NULL;
  else
  { // Truncate the text to the space allowed
    Text=strdup(_Text);
    FontSystem->TruncSysStr(Where.L()-20,_Text,Text);
    // Search for a HotKey
    char *P=strchr(Text,'&');
    if (P!=NULL) ScanCode=(int)(*(P+1));
  }
}

TItemBox::~TItemBox(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TItemBox::Done(void)
{ if (Text!=NULL) free(Text);
  TButton::Done();
}

// Events

boolean TItemBox::KeyDown(int SC)
{ switch(SC)
  { case ScanTab      :
    case ScanShiftTab :
      return FALSE;
  }
  if (TButton::KeyDown(SC)) return TRUE;
  switch(SC)
  { case ScanUpArrow   :
      SelectPrevious();
      return TRUE;
    case ScanDownArrow :
      SelectNext();
      return TRUE;
    case (int)' ' :
      KeyboardAction();
      return TRUE;
  }
  return FALSE;
}

// Graphics

void TItemBox::DrawSelect(int )
{ SetSysColor(GetColor(1));
  Rectangle(18,0,Where.L()-1,Where.H()-1);
}

void TItemBox::Draw(TRect& )
{ int D,L;
  SetSysColor(GetColor(2));
  Bar(0,0,Where.L(),Where.H());
  L=Where.L();
  Where.X2()=Where.X1()+15;
  D=DrawFrame();
  Where.X2()=Where.X1()+L-1;
  if (GetStatus(sfDisabled)) SetSysColor(GetColor(1));
                        else SetSysColor(GetColor(0));
  if (Text!=NULL) PutSysStr(20,1,Text,FontSystem);
  DrawInside(D);
  if (Focus()) DrawSelect(D);
}

// Objects streams

void TItemBox::Read(TDisk *file)
{ TButton::Read(file);
  if (Text!=NULL) free(Text);
  ReadString(file,&Text);
}

void TItemBox::Write(TDisk *file)
{ TButton::Write(file);
  WriteString(file,Text);
}

// ----- TCheckBox

short RegTCheckBox;
char *IdentTCheckBox = "TCheckBox";

// Constructors

TCheckBox::TCheckBox(int X, int Y, int L, int _Options, int _Mask, char *_Text) :
  TItemBox(X,Y,L,_Options,_Text)
{ Init(_Mask);
}

TCheckBox::TCheckBox() : TItemBox()
{ Init();
}

void TCheckBox::Init(int _Mask)
{ Register=RegTCheckBox;
  Ident=IdentTCheckBox;
  Mask=_Mask;
  Check=new TSysIcone(9,10,ICO_Check);
}

TCheckBox::~TCheckBox(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TCheckBox::Done(void)
{ if (Check!=NULL) delete Check;
  TItemBox::Done();
}

// Graphics

void TCheckBox::DrawInside(int Depl)
{ if ((Father()->Value) & Mask)
    if (Check!=NULL)
      Check->Draw(Corner.X()+Depl+3,Corner.Y()+Depl+3);
}

void TCheckBox::SetColorGroup(char ColorGroup)
{ if (Check!=NULL) Check->SetColorGroup(ColorGroup);
  TItemBox::SetColorGroup(ColorGroup);
}

// Action

void TCheckBox::Action(void)
{ Father()->Value^=Mask;
  Invalidate();
}

// Objects streams

void TCheckBox::Read(TDisk *file)
{ TItemBox::Read(file);
  ReadInt(file,&Mask);
}

void TCheckBox::Write(TDisk *file)
{ TItemBox::Write(file);
  WriteInt(file,Mask);
}

// ----- TRadioBox

short RegTRadioBox;
char *IdentTRadioBox = "TRadioBox";

// Constructors

TRadioBox::TRadioBox(int X, int Y, int L, int _Options, int _Value, char *_Text) :
  TItemBox(X,Y,L,_Options,_Text)
{ Init(_Value);
}

TRadioBox::TRadioBox() : TItemBox()
{ Init();
}

void TRadioBox::Init(int _Value)
{ Register=RegTRadioBox;
  Ident=IdentTRadioBox;
  I1=new TSysIcone(16,16,ICO_Radio1);
  I2=new TSysIcone(16,16,ICO_Radio2);
  I3=new TSysIcone(9,9,ICO_Radio3);
  Value=_Value;
}

TRadioBox::~TRadioBox(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TRadioBox::Done(void)
{ if (I1!=NULL) delete I1;
  if (I2!=NULL) delete I2;
  if (I3!=NULL) delete I3;
  TItemBox::Done();
}

// Graphics

int TRadioBox::DrawFrame(void)
{ if (GetStatus(sfDown))
  { if (I1!=NULL) I1->Draw(Corner.X(),Corner.Y());
    return 1;
  }
  else
  { if (I2!=NULL) I2->Draw(Corner.X(),Corner.Y());
    return 0;
  }
}

void TRadioBox::DrawInside(int D)
{ if (Father()->Value==Value)
    if (I3!=NULL) I3->Draw(Corner.X()+3+D,Corner.Y()+3+D);
}

void TRadioBox::SetColorGroup(char ColorGroup)
{ if (I1!=NULL) I1->SetColorGroup(ColorGroup);
  if (I2!=NULL) I2->SetColorGroup(ColorGroup);
  if (I3!=NULL) I3->SetColorGroup(ColorGroup);
  TItemBox::SetColorGroup(ColorGroup);
}

// Action

void TRadioBox::Action(void)
{ int *FVal=&(Father()->Value);
  if (*FVal!=Value)
  { // Recherche le Radio Box actuellement slectionn
    TRadioBox *O=First();
    while((O!=NULL)&&(O->Value!=*FVal)) O=O->Next();
    // Slectionne ce Radio Box
    *FVal=Value;
    Invalidate();
    // Dselectionne l'ancien
    if (O!=NULL) O->Invalidate();
  }
}

// Objects streams

void TRadioBox::Read(TDisk *file)
{ TItemBox::Read(file);
  ReadInt(file,&Value);
}

void TRadioBox::Write(TDisk *file)
{ TItemBox::Write(file);
  WriteInt(file,Value);
}
