/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Src/Mecanism/Point.CC
   Author    : Eric NICOLAS
   Overview  : Object TPoint = { int X, int Y }
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"

static TPoint TempPoint;

// Constructors

TPoint::TPoint()
{ _X=_Y=0;
}

TPoint::TPoint(int X, int Y)
{ _X=X;
  _Y=Y;
}

TPoint::TPoint(TPoint& P)
{ _X=P._X;
  _Y=P._Y;
}

// Operators

TPoint TPoint::operator+(TPoint& P)
{ TempPoint._X=_X+P._X;
  TempPoint._Y=_Y+P._Y;
  return TempPoint;
}

TPoint TPoint::operator-(TPoint& P)
{ TempPoint._X=_X-P._X;
  TempPoint._Y=_Y-P._Y;
  return TempPoint;
}

TPoint TPoint::operator+=(TPoint& P)
{ _X+=P._X;
  _Y+=P._Y;
  return (*this);
}

TPoint TPoint::operator-=(TPoint& P)
{ _X-=P._X;
  _Y-=P._Y;
  return (*this);
}

// Objects stream

void TPoint::Read(TDisk *file)
{ ReadInt(file,&_X);
  ReadInt(file,&_Y);
}

void TPoint::Write(TDisk *file)
{ WriteInt(file,_X);
  WriteInt(file,_Y);
}
