//----------------------------------------------------------------------------
//
// AATEXT 1.0 beta - Antialiased text fonts for Allegro
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Basic font loading functions
//----------------------------------------------------------------------------
#include "allegro.h"

//----------------------------------------------------------------------------
// The following functions are almost directly taken from Allegro's grabber program
//----------------------------------------------------------------------------
/* splits bitmaps into sub-sprites, using regions bounded by col #255 */
static void datedit_find_character(BITMAP *bmp, int *x, int *y, int *w, int *h)
{
   int c1;
   int c2;

   if (bitmap_color_depth(bmp) == 8) {
      c1 = 255;
      c2 = 255;
   }
   else {
      c1 = makecol_depth(bitmap_color_depth(bmp), 255, 255, 0);
      c2 = makecol_depth(bitmap_color_depth(bmp), 0, 255, 255);
   }

   /* look for top left corner of character */
   while ((getpixel(bmp, *x, *y) != c1) || 
	  (getpixel(bmp, *x+1, *y) != c2) ||
	  (getpixel(bmp, *x, *y+1) != c2) ||
	  (getpixel(bmp, *x+1, *y+1) == c1) ||
	  (getpixel(bmp, *x+1, *y+1) == c2)) {
      (*x)++;
      if (*x >= bmp->w) {
	 *x = 0;
	 (*y)++;
	 if (*y >= bmp->h) {
	    *w = 0;
	    *h = 0;
	    return;
	 }
      }
   }

   /* look for right edge of character */
   *w = 0;
   while ((getpixel(bmp, *x+*w+1, *y) == c2) &&
	  (getpixel(bmp, *x+*w+1, *y+1) != c2) &&
	  (*x+*w+1 <= bmp->w))
      (*w)++;

   /* look for bottom edge of character */
   *h = 0;
   while ((getpixel(bmp, *x, *y+*h+1) == c2) &&
	  (getpixel(bmp, *x+1, *y+*h+1) != c2) &&
	  (*y+*h+1 <= bmp->h))
      (*h)++;
}
//----------------------------------------------------------------------------
// Load a font from a bitmap file
FONT* load_font (const char *fname)
   {
   PALLETE junk;
   BITMAP *bmp;
   FONT *loadedfont;
   int x, y, w, h, c;
   int max_h = 0;

   // Make sure we have a filename
   if(fname==NULL) return NULL;

   // Load the desired bitmap in
   bmp = load_bitmap((char*)fname, junk);
   if(!bmp) return NULL;

   // The bitmap MUST be 8 bits, otherwise it's not a font bitmap
   if(bitmap_color_depth(bmp) != 8)
      {
      destroy_bitmap(bmp);
      return NULL;
      }

   // Allocate the internal Allegro font stuff
   loadedfont = (FONT*)malloc(sizeof(FONT));
   loadedfont->height = -1;
   loadedfont->dat.dat_prop = (FONT_PROP*)malloc(sizeof(FONT_PROP));
   for (c=0; c<FONT_SIZE; c++)
      loadedfont->dat.dat_prop->dat[c] = NULL;

   // Pull each character out
   x = 0;
   y = 0;
   for (c=0; c<FONT_SIZE; c++)
      {
      datedit_find_character(bmp, &x, &y, &w, &h);

      if ((w <= 0) || (h <= 0))
         {
	      w = 8;
	      h = 8;
         }

      loadedfont->dat.dat_prop->dat[c] = create_bitmap_ex(8, w, h);
      clear(loadedfont->dat.dat_prop->dat[c]);
      blit(bmp, loadedfont->dat.dat_prop->dat[c], x+1, y+1, 0, 0, w, h);

      max_h = MAX(max_h, h);
      x += w;
      }

   for (c=0; c<FONT_SIZE; c++)
      {
      if (loadedfont->dat.dat_prop->dat[c]->h < max_h)
         {
	      BITMAP *b = loadedfont->dat.dat_prop->dat[c];
	      loadedfont->dat.dat_prop->dat[c] = create_bitmap_ex(8, b->w, max_h);
	      clear(loadedfont->dat.dat_prop->dat[c]);
	      blit(b, loadedfont->dat.dat_prop->dat[c], 0, 0, 0, 0, b->w, b->h);
	      destroy_bitmap(b);
         }
      }

   // Release temp space and set the font
   destroy_bitmap(bmp);

   return loadedfont;
   }
//----------------------------------------------------------------------------

