//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// DEGUI gui Builder main program
//----------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include "allegro.h"
#include "degui.h"
#include "inifile.h"
#include "build_di.h"
#include "build_mu.h"

extern int driver;
extern int xres;
extern int yres;

//----------------------------------------------------------------------------
int main (void)
   {
   // Initialise Allegro
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   PALETTE pal;
   get_palette(pal);

   // Get stuff from the ini file
   INIfile ini("builder.ini");
   driver = ini("Graphics","driver",GFX_AUTODETECT);
   xres = ini("Graphics","xres",640);
   yres = ini("Graphics","yres",480);

   // Set up the initial graphics mode
   if(set_gfx_mode(driver,xres,yres,0,0)!=0)
      {
      // Put up default mode if set didn't work
      if(set_gfx_mode(GFX_AUTODETECT,640,480,0,0)!=0)
         {
         // Aaagh, nothing works, try the basic VGA as a last resort
         if(set_gfx_mode(GFX_VGA,320,200,0,0)!=0)
            {
            // Could not set ANY video mode
            set_gfx_mode(GFX_TEXT,0,0,0,0);
            cerr << "Could not set video mode (even tried 13h)\n";
            exit(1);
            }
         // Accept minimal mode
         else
            {
            driver = GFX_TEXT;
            xres = 320;
            yres = 200;
            }
         }
      // Accept default mode
      else
         {
         driver = GFX_AUTODETECT;
         xres = 640;
         yres = 480;
         }
      }

   // Declare the gui builder object
   gui_builder = new builder_dialog;
   if(gui_builder==NULL) cerr << "DEGUI: no memory\n";

   // Setup the modification keys
   gui_builder->set_move_key(KEY_F1);
   gui_builder->set_multimove_key(KEY_F2);
   gui_builder->set_resize_key(KEY_F3);
   gui_builder->set_pushback_key(KEY_F4);
   gui_builder->set_pullfront_key(KEY_F5);
   gui_builder->set_delete_key(KEY_F10);
   gui_builder->set_granularity(ini("Builder","granularity",5));

   // Set the default colors
   set_palette(desktop_palette);
   set_default_object_colors(0,236,237,238,239,240,241,242);

   // Start the gui builder
   gui_builder->execute();

   // Clean up and go home
   delete gui_builder;

   ini.set("Graphics","driver",driver);
   ini.set("Graphics","xres",xres);
   ini.set("Graphics","yres",yres);
   ini.set("Builder","granularity",gui_builder->get_granularity());
   ini.close();

   set_palette(pal);
   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------
