//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Allegro dialog managing class
//----------------------------------------------------------------------------
// Constructor
dialog::dialog (const int num)
	:dialog_do(num),
   font_height(text_height(font)),
   font_width(text_length(font,(unsigned char*)("H")))
   {
   }
//----------------------------------------------------------------------------
// Destructor
dialog::~dialog (void)
   {
   // Give back DIALOG *d to the still existing objects
   for(int i=1;i<number;i++)
      {
      if((_dialog[i].proc==dialog_object::object_message_proc)&&
         (_dialog[i].dp!=NULL))
         {
         // Find the object
         dialog_object *object = (dialog_object*)_dialog[i].dp;

         // Give back the d pointer and any init stuff
         object->disconnect();
         }
      }
   }
//----------------------------------------------------------------------------
// Add an object to the dialog
void dialog::add (dialog_object &obj, const int x, const int y, const int w, const int h)
   {
   // Figure out the object's previous state
	int key = obj.key();
   int flags = obj.flags();
   int d1 = obj.d1();
   int d2 = obj.d2();

   int realx = obj.x();
   if(x>=0) realx = x;
   obj.set_x(realx);

   int realy = obj.y();
   if(y>=0) realy = y;
   obj.set_y(realy);

   int realw = obj.w();
   if(w>=0) realw = w;
   obj.set_w(realw);

   int realh = obj.h();
   if(h>=0) realh = h;
   obj.set_h(realh);

   // Set the objects parent dialog
   obj._parent = this;

   // Add the C++ object to the dialog
   dialog_do::add(dialog_object::object_message_proc,realx,realy,realw,realh,0,0,key,flags,d1,d2,&obj);

   // Attach the object to the dialog
   obj.connect(&_dialog[number-1]);
	}
//----------------------------------------------------------------------------
void dialog::add (dialog &dia)
   {
   // Add the base object NOTE: it must be in it's dialog object form or we get recursion!
   add(*(dialog_object*)&dia);

   // Add all the object from the other to us
 	for(int i=0;i<dia.number;i++)
      {
      dialog_do::add(dia._dialog[i].proc,dia._dialog[i].x,dia._dialog[i].y,dia._dialog[i].w,dia._dialog[i].h,dia._dialog[i].fg,dia._dialog[i].bg,dia._dialog[i].key,dia._dialog[i].flags,dia._dialog[i].d1,dia._dialog[i].d2,dia._dialog[i].dp);
      }
	}
//----------------------------------------------------------------------------
void dialog::add (window_object &dia, const int x, const int y, const int w, const int h)
   {
   // Figure out correct size and position
   int realx = dia.x();
   if(x>=0) realx = x;
   dia.set_x(realx);

   int realy = dia.y();
   if(y>=0) realy = y;
   dia.set_y(realy);

   int realw = dia.w();
   if(w>=0) realw = w;
   dia.set_w(realw);

   int realh = dia.h();
   if(h>=0) realh = h;
   dia.set_h(realh);

   // Add the base object NOTE: it must be in it's dialog object form or we get recursion!
   add(*(dialog_object*)&dia,realx,realy,realw,realh);

   // Add all the object from the other to us
 	for(int i=0;i<dia.number;i++)
      {
      dialog_object* obj = (dialog_object*)dia._dialog[i].dp;

      if(obj!=NULL)
         {
         // Adjust the position of the sub objects
         obj->set_x(obj->x()+dia.x());
         obj->set_y(obj->y()+dia.y());

         // Actually add the sub object to the dialog
         add(*obj);
         }
      }
	}
//----------------------------------------------------------------------------
// Remove an object to the dialog
void dialog::remove (dialog_object &obj)
   {
   // Find the object in the list
   int i;
   for(i=0;i<number;i++)
      {
      // Is it the right one
      if(_dialog[i].dp==&obj)
         break;
      }

   // Make sure that we found it ok
   if(i>=number) return;

   // Stop the object from looking at our DIALOG array
   obj.disconnect();

   // Move the other objects over
   dialog_object *next = (dialog_object*)_dialog[i+1].dp;
   while(_dialog[i+1].proc)
      {
      _dialog[i] = _dialog[i+1];
      if(next!=NULL) next->connect(&_dialog[i]);

      i++;
      next = (dialog_object*)_dialog[i+1].dp;
      }
   // Set the last object to a empty object
   _dialog[i].proc  = NULL;
   _dialog[i].x     = 0;
   _dialog[i].y     = 0;
   _dialog[i].w     = 0;
   _dialog[i].h     = 0;
   _dialog[i].key   = 0;
   _dialog[i].flags = 0;
   _dialog[i].d1    = 0;
   _dialog[i].d2    = 0;
   _dialog[i].dp    = NULL;

   // Possibly adjust the mouse and focus object
   if(i==mouse_obj) mouse_obj = -1;
   else if(i<mouse_obj) mouse_obj--;

   if(i==focus_obj) focus_obj = -1;
   else if(i<focus_obj) focus_obj--;

   number--;
   }
//----------------------------------------------------------------------------
// Remove another dialog from us
void dialog::remove (dialog &dia)
   {
   // We can't remove ourselves
   if(&dia==this) return;

   // Remove the base object NOTE: it must be in it's dialog object form or we get recursion!
   remove(*(dialog_object*)&dia);

   // Remove the object from the other one
 	for(int i=0;i<dia.number;i++)
      {
      dialog_object* obj = (dialog_object*)dia._dialog[i].dp;
      if(obj!=NULL) remove(*obj);
      }
   }
//----------------------------------------------------------------------------
// Remove another window from us
void dialog::remove (window_object &dia)
   {
   // We can't remove ourselves
   if(&dia==this) return;

   // Remove the base object NOTE: it must be in it's dialog object form or we get recursion!
   remove(*(dialog_object*)&dia);

   // Remove the object from the other one
 	for(int i=0;i<dia.number;i++)
      {
      dialog_object* obj = (dialog_object*)dia._dialog[i].dp;
      if(obj!=NULL)
         {
         // Put back the sub objects original position
         obj->set_x(obj->x()-dia.x());
         obj->set_y(obj->y()-dia.y());

         // remove the object
         remove(*obj);
         }
      }
   }
//----------------------------------------------------------------------------
// Do the dialog
dialog_object* dialog::execute (const dialog_object* focus_object)
	{
   // Make sure the desired focus object is in our dialog
   focus_obj = -1;
 	for(int i=0;i<number;i++)
      if(_dialog[i].dp==focus_object)
         focus_obj = i;

   // Ask Allegro to do the dialog
   focus_obj = dialog_do::execute(focus_obj);

   // Return the dialog that exited
   if((focus_obj>=0)&&(focus_obj<number)) return (dialog_object*)(_dialog[focus_obj].dp);
   else return NULL;
	}
//----------------------------------------------------------------------------
// Do the dialog as a popup
dialog_object* dialog::popup (const dialog_object* focus_object)
	{
   // Find the extrema of the dialog
   int minx = MAXINT;
   int maxx = -MAXINT;
   int miny = MAXINT;
   int maxy = -MAXINT;
   find_extrema(0,number,minx,miny,maxx,maxy);

   // Get the background
   BITMAP *background = create_bitmap(maxx-minx+1,maxy-miny+1);
   show_mouse(NULL);
   blit(screen,background,minx,miny,0,0,maxx-minx+1,maxy-miny+1);
   show_mouse(screen);

   // Do the dialog
   dialog_object *ret = execute(focus_object);

   // Replace and release the background
   show_mouse(NULL);
   blit(background,screen,0,0,minx,miny,maxx-minx+1,maxy-miny+1);
   show_mouse(screen);
   destroy_bitmap(background);

   // Return the dialog that exited
   return ret;
	}
//----------------------------------------------------------------------------
// Helper function to find the total space of a dialog
void dialog::find_extrema (const int start, const int end, int &minx, int &miny, int &maxx, int &maxy)
   {
   minx = MAXINT;
   maxx = -MAXINT;
   miny = MAXINT;
   maxy = -MAXINT;

   // Find out how many objects to center
   int num = number;
   if(end<num) num = end;

   // Adjust the size for the font's as necessary
   scale_to_font(font);

   // Find the extremes of the dialog, but only for reasonable objects
   int x, y, w, h;
   for(int i=start;i<num;i++)
      {
      // Find the object position
      x = _dialog[i].x;
      y = _dialog[i].y;
      w = _dialog[i].w;
      h = _dialog[i].h;

      // Find the extrema for real objects
      if((w>0)&&(h>0))
         {
         if(x<minx) minx = x;
         if((x+w)>maxx) maxx = x+w;
         if(y<miny) miny = y;
         if((y+h)>maxy) maxy = y+h;
         }
      }
   }
//----------------------------------------------------------------------------
// Scale the dialog for a particular font
void dialog::scale_to_font (FONT *font)
   {
   float height_scale = (float)font_height/(float)text_height(font);
   float width_scale = (float)font_width/(float)text_length(font,(unsigned char*)"H");

   for(int i=0;i<number;i++)
      {
      _dialog[i].x = (int)((float)_dialog[i].x / width_scale);
      _dialog[i].y = (int)((float)_dialog[i].y / height_scale);
      _dialog[i].w = (int)((float)_dialog[i].w / width_scale);
      _dialog[i].h = (int)((float)_dialog[i].h / height_scale);
      }
   font_height = text_height(font);
   font_width = text_length(font,(unsigned char*)"H");
   }
//----------------------------------------------------------------------------
// Disable a entire dialog
void dialog::disable (void)
   {
   dialog_object::disable();
   }
//----------------------------------------------------------------------------

