//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"

//----------------------------------------------------------------------------
// Wrapper class for objects based on Allegro procedures
//----------------------------------------------------------------------------
// Constructor
proc_object::proc_object (int(*pr)(int,DIALOG*,int), void **p)
   :dialog_procedure(pr),
   ptr_dp(p)
   {
   }
//----------------------------------------------------------------------------
// Destructor
proc_object::~proc_object (void)
   {
   }
//----------------------------------------------------------------------------
// Send a message to an underlying C procedure
int proc_object::c_message (const int msg, const int c)
   {
   int ret = D_O_K;

   // Set the proper colors
   d->fg = color ? color->fore() : degui_fore_color;
   d->bg = color ? color->back() : degui_back_color;

   // Save the data pointer and the procedure pointer
   void *temp_dp = d->dp;
   int(*temp_proc)(int,DIALOG*,int) = d->proc;

   // Set what the procedure wants to see into the data pointer and procedure
   if(ptr_dp!=NULL) d->dp = *ptr_dp;
   else d->dp = NULL;
   d->proc = dialog_procedure;

   // Actually call the C procedure
   if(dialog_procedure!=NULL) ret = dialog_procedure(msg,d,c);

   // Restore any pointers changed
   d->dp = temp_dp;
   d->proc = temp_proc;

   return ret;
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Initialization of the dialog
void proc_object::msg_start (void)
   {
   dialog_object::msg_start();
   c_message(MSG_START,0);
   }
// De-initialization of the dialog
void proc_object::msg_end (void)
   {
   c_message(MSG_END,0);
   }
// Tell the object to draw itself
void proc_object::msg_draw (void)
   {
   c_message(MSG_DRAW,0);
   _redraw = false;
   }
// Tell the object to deal with a mouse click
void proc_object::msg_click (void)
   {
   c_message(MSG_CLICK,0);
   }
// Tell the object to deal with a double click
void proc_object::msg_dclick (void)
   {
   c_message(MSG_DCLICK,0);
   }
// Tell the object that a shortcut key was pressed
void proc_object::msg_key (void)
   {
   c_message(MSG_KEY,0);
   }
// Tell the object that a key was pressed while it had the focus
// This should return true if the key was used
bool proc_object::msg_char (const int c)
   {
   int ret = c_message(MSG_CHAR,c);

   // Find out if the char was used or not
   if(ret&D_USED_CHAR) return true;
   else return false;
   }
// Tell the object that a key was pressed while it did noty have the focus
// This should return true if the key was used
bool proc_object::msg_xchar (const int c)
   {
   int ret = c_message(MSG_XCHAR,c);

   // Find out if the char was used or not
   if(ret&D_USED_CHAR) return true;
   else return false;
   }
// Ask the object if they want the focus
bool proc_object::msg_wantfocus (void)
   {
   int ret = c_message(MSG_WANTFOCUS,0);

   // Find out if they want the focus or not
   if(ret&D_WANTFOCUS) return true;
   else return false;
   }
// Tell the object that the got or lost the focus
void proc_object::msg_gotfocus (void)
   {
   c_message(MSG_GOTFOCUS,0);
   }
void proc_object::msg_lostfocus (void)
   {
   c_message(MSG_LOSTFOCUS,0);
   }
// Tell the object that they got or lost the mouse
void proc_object::msg_gotmouse (void)
   {
   c_message(MSG_GOTMOUSE,0);
   }
void proc_object::msg_lostmouse (void)
   {
   c_message(MSG_LOSTMOUSE,0);
   }
// Tell the object that the object manager is bored
void proc_object::msg_idle (void)
   {
   c_message(MSG_IDLE,0);
   }
// Deselect grouped radio buttons
void proc_object::msg_radio (const int c)
   {
   c_message(MSG_RADIO,c);
   }
// Get an hitherto unknown message
void proc_object::msg_unknown (const int msg)
   {
   c_message(msg,0);
   }

//----------------------------------------------------------------------------

