//Term.c demo programm for DZComm
//Dim Zegebart
//zager@post.comstar.ru
//Moscow Russia
//http://www.geocities.com/siliconvalley/pines/7817
// dzcomm lib v0.4

#include <stdio.h>
#include <conio.h>
#include <allegro.h>
#include <dzcomm.h>
#include <dos.h>

inline void print_bin(int c)
{ int i,j;
  int mask=0x01;
  printf ("%c : ",c);
  for (i=0;i<4;i++)
   { for(j=0;j<8;j++)
      if (c&(mask<<(j+i*8))) printf("1");
      else printf("0");
      printf(".");
   }
  printf("\n");
  fflush(stdout);
}

inline void dz_print_comm_err() {printf("%s",szDZCommErr);fflush(stdout);}

comm_port *port1; //mouse
comm_port *port2; //modem
comm_port *cur_port;

int com2_wrapper(void)
{ dz_comm_port_interrupt_handler(port2);
  return(0);
}
END_OF_FUNCTION(com2_wrapper);

void com2_at_exit(void)
{ comm_port_delete(port2);
}

int com1_wrapper(void)
{ dz_comm_port_interrupt_handler(port1);
  return(0);
}
END_OF_FUNCTION(com1_wrapper);

void com1_at_exit(void)
{ comm_port_delete(port1);
}

void main(void)
{
  comm_port_init();

  LOCK_FUNCTION(com2_wrapper);
  LOCK_FUNCTION(com1_wrapper);

  allegro_init();
  install_keyboard();

//------------------- comm2 ---------------------

  if ((port2=comm_port_new(com2,com2_wrapper))==NULL)
   { dz_print_comm_err();
     exit(1);
   }
//  strcpy(port2->szName,"COM2-Modem (type command) :");
  atexit(com2_at_exit);
  comm_port_load_settings(port2,"term.ini");

  if (!comm_port_install_handler(port2))
   { dz_print_comm_err();
     exit(1);
   }

//------------------- comm1 ---------------------

  if ((port1=comm_port_new(com1,com1_wrapper))==NULL)
   { dz_print_comm_err();
     exit(1);
   }
  strcpy(port1->szName,"COM1-Mouse (move mouse): ");
  atexit(com1_at_exit);

  if (!comm_port_install_handler(port1))
   { dz_print_comm_err();
     exit(1);
   }

  cur_port=port2;

  printf("Press Ctrl-Q for quit.\n");
  printf("Press Ctrl-M for switch between comm ports.\n\n");
  printf("Current port is com2.\n");
  printf("Ready.\n");

  while(1)
   { int c;
     byte ch;

     if (keypressed())
      { c=readkey();
        ch=ascii_(c);
        comm_port_out(cur_port,ch);

        if (ctrl_(c,'Q')) return;
        if (ctrl_(c,'M'))
         { if (cur_port==port2) cur_port=port1;
           else cur_port=port2;

           printf("\n%s\n",cur_port->szName);
         }
       }
     if ((c=comm_port_test(cur_port))!=-1)
      { putch(data_(c));
      }
   }

}
