#include "setup.h"

void read_comm_ini_file(void *)
{
  comm_port_init(_com1);
  comm_port_init(_com2);
  comm_port_init(_com3);
  comm_port_init(_com4);
  comm_port_init(_com5);
  comm_port_init(_com6);
  comm_port_init(_com7);
  comm_port_init(_com8);

  if (comm_port_load_settings(com1,"ports.ini")==1) CommLst->m_check_item(1);
  if (comm_port_load_settings(com2,"ports.ini")==1)  CommLst->m_check_item(2);
  if (comm_port_load_settings(com3,"ports.ini")==1) CommLst->m_check_item(3);
  if (comm_port_load_settings(com4,"ports.ini")==1) CommLst->m_check_item(4);
  if (comm_port_load_settings(com5,"ports.ini")==1) CommLst->m_check_item(5);
  if (comm_port_load_settings(com6,"ports.ini")==1) CommLst->m_check_item(6);
  if (comm_port_load_settings(com7,"ports.ini")==1) CommLst->m_check_item(7);
  if (comm_port_load_settings(com8,"ports.ini")==1) CommLst->m_check_item(8);

  update_comm_dialog(com2);

}
void update_comm_dialog(device *port)
{ char *s="                ";
  comm_port *cp=cdport_(port);
  if (port==NULL) return;

  switch (cp->nBaud)
   { case _110	 : BaudBox.m_set_string_from_list_item(1); break;
     case _150	 : BaudBox.m_set_string_from_list_item(2); break;
     case _300	 : BaudBox.m_set_string_from_list_item(3); break;
     case _600	 : BaudBox.m_set_string_from_list_item(4); break;
     case _1200	 : BaudBox.m_set_string_from_list_item(5); break;
     case _2400	 : BaudBox.m_set_string_from_list_item(6); break;
     case _4800	 : BaudBox.m_set_string_from_list_item(7); break;
     case _9600	 : BaudBox.m_set_string_from_list_item(8); break;
     case _19200 : BaudBox.m_set_string_from_list_item(9); break;
     case _38400 : BaudBox.m_set_string_from_list_item(10); break;
     case _57600 : BaudBox.m_set_string_from_list_item(11); break;
     case _115200: BaudBox.m_set_string_from_list_item(12); break;
   }
  switch (cp->nData)
   { case BITS_8 : DataBox.m_set_string_from_list_item(1); break;
     case BITS_7 : DataBox.m_set_string_from_list_item(2); break;
     case BITS_6 : DataBox.m_set_string_from_list_item(3); break;
     case BITS_5 : DataBox.m_set_string_from_list_item(4); break;
   }
  switch (cp->nStop)
   { case STOP_1 : StopBox.m_set_string_from_list_item(1); break;
     case STOP_2 : StopBox.m_set_string_from_list_item(2); break;
   }
  switch (cp->nParity)
   { case EVEN_PARITY : ParityBox.m_set_string_from_list_item(1); break;
     case ODD_PARITY  : ParityBox.m_set_string_from_list_item(2); break;
     case NO_PARITY   : ParityBox.m_set_string_from_list_item(3); break;
   }
  switch (cp->control_type)
   { case XON_XOFF   : FlowBox.m_set_string_from_list_item(1); break;
     case RTS_CTS    : FlowBox.m_set_string_from_list_item(2); break;
     case NO_CONTROL : FlowBox.m_set_string_from_list_item(3); break;
   }

  itoa(cp->nIRQ,s,16);
  IRQEdit.m_set_string(s);
  itoa(cp->nPort,s,16);
  AddrEdit.m_set_string(s);
  NameEdit.m_set_string(port->szName);

}

//-------------------- CommBoxValidatedCB ----------------------

void CommBoxValidateCB(PObject obj,char	*arg)
{ device *port;
  int i;

  i=CommLst->m_get_selected_item_index();
  if (i==1) port=com1;
  else if (i==2) port=com2;
  else if (i==3) port=com3;
  else if (i==4) port=com4;
  else if (i==5) port=com5;
  else if (i==6) port=com6;
  else if (i==7) port=com7;
  else if (i==8) port=com8;

  update_comm_dialog(port);

}

//------------------ CommAppButPressedCB -------------------

void CommAppButPressedCB(TObject *obj,char *arg)
{ device *port;
  comm_port *cp;
  int i;

  i=CommLst->m_get_selected_item_index();
  if (i==1) port=com1;
  else if (i==2) port=com2;
  else if (i==3) port=com3;
  else if (i==4) port=com4;
  else if (i==5) port=com5;
  else if (i==6) port=com6;
  else if (i==7) port=com7;
  else if (i==8) port=com8;
  else
   { MessageBox("Error","Error : port number not in range!",ALERT,MB_OK,NO_SOUND);
     return;
   }

  cp=cdport_(port);
  { comm com=cp->nComm;
    char com_name[7]={'[','C','O','M',com+49,']',0};
    char com_end[11]={'[','C','O','M',com+49,' ','E','N','D',']',0};
    char s[8][30]={{"baud="},{"data="},{"parity="},{"stop="},
                   {"control="},{"name="},{"irq="},{"address="}};
    char *str,ss[270];
    ss[0]=0;

    switch (BaudLst->m_get_selected_item_index())
     { case 1 : cp->nBaud=_110;strcat(s[0],"110;\n");break;
       case 2 : cp->nBaud=_150;strcat(s[0],"150;\n");break;
       case 3 : cp->nBaud=_300;strcat(s[0],"300;\n");break;
       case 4 : cp->nBaud=_600;strcat(s[0],"600;\n");break;
       case 5 : cp->nBaud=_1200;strcat(s[0],"1200;\n");break;
       case 6 : cp->nBaud=_2400;strcat(s[0],"2400;\n");break;
       case 7 : cp->nBaud=_4800;strcat(s[0],"4800;\n");break;
       case 8 : cp->nBaud=_9600;strcat(s[0],"9600;\n");break;
       case 9 : cp->nBaud=_19200;strcat(s[0],"19200;\n");break;
       case 10 : cp->nBaud=_38400;strcat(s[0],"38400;\n");break;
       case 11 : cp->nBaud=_57600;strcat(s[0],"57600;\n");break;
       case 12 : cp->nBaud=_115200;strcat(s[0],"115200;\n");break;
     }
  
    switch (DataLst->m_get_selected_item_index())
     { case 1 : cp->nData=BITS_8;strcat(s[1],"8;\n");break;
       case 2 : cp->nData=BITS_7;strcat(s[1],"7;\n");break;
       case 3 : cp->nData=BITS_6;strcat(s[1],"6;\n");break;
       case 4 : cp->nData=BITS_5;strcat(s[1],"5;\n");break;
     }
    switch (StopLst->m_get_selected_item_index())
     { case 1 : cp->nStop=STOP_1;strcat(s[2],"1;\n");break;
       case 2 : cp->nStop=STOP_2;strcat(s[2],"2;\n");break;
     }
    switch (ParityLst->m_get_selected_item_index())
     { case 1 : cp->nParity=EVEN_PARITY;strcat(s[3],"Even;\n");break;
       case 2 : cp->nParity=ODD_PARITY;strcat(s[3],"Odd;\n");break;
       case 3 : cp->nParity=NO_PARITY;strcat(s[3],"No;\n");break;
     }
    switch (FlowLst->m_get_selected_item_index())
     { case 1 : cp->control_type=XON_XOFF;strcat(s[4],"XON/XOFF;\n");break;
       case 2 : cp->control_type=RTS_CTS;strcat(s[4],"RTS/CTS;\n");break;
       case 3 : cp->control_type=NO_CONTROL;strcat(s[4],"No;\n");break;
     }

    strcat(s[5],NameEdit.m_get_string());
    strcat(s[5],";\n");

    if (IRQChk.m_is_checked()==JP_FALSE) s[6][0]=0;
    else
     { strcat(s[6],IRQEdit.m_get_string());
       strcat(s[6],";\n");
       cp->nIRQ=atoi(IRQEdit.m_get_string());
     }

    if (AddrChk.m_is_checked()==JP_FALSE) s[7][0]=0;
    else
     { str=AddrEdit.m_get_string();
       if (!(str[0]=='0'&&(str[1]=='x'||str[1]=='X')))
        { str[5]=0;
          str[4]=str[2];
          str[3]=str[1];
          str[2]=str[0];
          str[1]='x';
          str[0]='0';
        }
       strcat(s[7],str);
       strcat(s[7],";\n");
       cp->nPort=atoi(str);
     }
    strcat(ss,s[0]);strcat(ss,s[1]);strcat(ss,s[2]);strcat(ss,s[3]);
    strcat(ss,s[4]);strcat(ss,s[5]);strcat(ss,s[6]);strcat(ss,s[7]);

    switch (set2file(ss,com_name,com_end,"ports.ini"))
     { case SET_ADDED :
        MessageBox("Apply result","OK : new settings for current\nport were added !",DIALOG1,MB_OK,NO_SOUND);
        CommLst->m_check_item(cp->nComm+1);
        break;
       case SET_REPLACED :
        MessageBox("Apply result","OK : old settings for current\nport were replaced !",DIALOG1,MB_OK,NO_SOUND);
        break;
       case SET_ERROR :
        MessageBox("Error","Error : error writing to 'ports.ini' !",ALERT,MB_OK,NO_SOUND);
        break;
     }
  }
}
