#include <dos.h>
#include <iostream.h>
#include <stdlib.h>

#include "setup.h"

/*ͻ*/
/*                                 CONSTANTS                              */
/*ͼ*/

//-- String numbers (used by multi-language support)

#define VOC_LANGUAGE 1000
#define VOC_HELLO    1001

/*ͻ*/
/*                                WIDGETS                                 */
/*ͼ*/


//-- APPLICATION -------------------------------------------------------------

TApplication  XTrekerSetup(ENGLISH);

//-- MAIN WINDOW -------------------------------------------------------------

TWindow MainWin (DIALOG1,1,1,80,25,"XTreker setup.",INFO_BAR,MODAL);

TPushButton QuitButton (&MainWin,66,22,10,"~Quit",PB_CANCEL);

//-- TAB GROUP ---------------------------------------------------------------

TTabGroup TabGroup (&MainWin,2,2,76,19,DIALOG1);

//-- Comm Tab-----------------------------------------------------------------

TTab CommTab (&TabGroup,"~Comm ports");
void CommTabCB (TObject *obj,char *arg)
{ MainWin.m_set_info_message(arg);
}

TPushButton CommAppBut (&CommTab,1,15,10,"~Apply",PB_NORMAL);

TFrame    GenFrame (&CommTab,1,1,30,9,"General parameters");

TListItem CommBoxItem[]={{"COM1",LI_NOATTR},{"COM2",LI_NOATTR},
                         {"COM3",LI_NOATTR},{"COM4",LI_NOATTR},
                         {"COM5",LI_NOATTR},{"COM6",LI_NOATTR},
                         {"COM7",LI_NOATTR},{"COM8",LI_NOATTR},
                         {NULL,LI_NOATTR}};

TComboBox CommBox (&GenFrame,14,1,-13,0,"~Port number",9,10,"COM2",10,CommBoxItem,JP_TRUE,JP_FALSE,JP_TRUE);

TListItem BaudBoxItem[]={{"110",LI_NOATTR},{"150",LI_NOATTR},
                         {"300",LI_NOATTR},{"600",LI_NOATTR},{"1200",LI_NOATTR},
                         {"2400",LI_NOATTR},{"4800",LI_NOATTR},{"9600",LI_NOATTR},
                         {"19200",LI_NOATTR},{"38400",LI_NOATTR},{"57600",LI_NOATTR},
                         {"115200",LI_NOATTR},
                         {NULL,LI_NOATTR}};

TComboBox BaudBox (&GenFrame,14,2,-13,0,"~Baud rate",9,10,"9600",14,BaudBoxItem,JP_TRUE,JP_FALSE,JP_TRUE);

TListItem DataBoxItem[]={{"8",LI_NOATTR},{"7",LI_NOATTR},{"6",LI_NOATTR},
                         {"5",LI_NOATTR},
                         {NULL,LI_NOATTR}};

TComboBox DataBox (&GenFrame,14,3,-13,0,"~Data bits",9,10,"7",6,DataBoxItem,JP_TRUE,JP_FALSE,JP_TRUE);

TListItem ParityBoxItem[]={{"Even",LI_NOATTR},{"Odd",LI_NOATTR},{"None",LI_NOATTR},
                           {NULL,LI_NOATTR}};

TComboBox ParityBox (&GenFrame,14,4,-13,0,"Pari~ty",9,10,"Even",5,ParityBoxItem,JP_TRUE,JP_FALSE,JP_TRUE);

TListItem StopBoxItem[]={{"1",LI_NOATTR},{"2",LI_NOATTR},
                           {NULL,LI_NOATTR}};

TComboBox StopBox (&GenFrame,14,5,-13,0,"~Stop",9,10,"1",5,StopBoxItem,JP_TRUE,JP_FALSE,JP_TRUE);

TListItem FlowBoxItem[]={{"XON/XOFF",LI_NOATTR},{"RTS/CTS",LI_NOATTR},{"NONE",LI_NOATTR},
                         {NULL,LI_NOATTR}};

TComboBox FlowBox (&GenFrame,14,6,-13,0,"~Flow control",9,10,"XON/XOFF",5,FlowBoxItem,JP_TRUE,JP_FALSE,JP_TRUE);
TEditZone NameEdit (&GenFrame,14,7,-13,0,"P~ort name",13,25,"",JP_TRUE);

TFrame    OptFrame (&CommTab,1,10,30,5,"Optional parameters");
TEditZone IRQEdit  (&OptFrame,14,1,-13,0,"~IRQ (dec)",5,10,"",JP_TRUE);
TCheckBox IRQChk   (&OptFrame,21,1,8,"Save",JP_FALSE,JP_TRUE);
TEditZone AddrEdit (&OptFrame,14,2,-13,0,"Add~r. (hex)",5,10,"",JP_TRUE);
TCheckBox AddrChk  (&OptFrame,21,2,8,"Save",JP_FALSE,JP_TRUE);


PSimpleList CommLst;
PSimpleList BaudLst;
PSimpleList DataLst;
PSimpleList ParityLst;
PSimpleList StopLst;
PSimpleList FlowLst;

//-- Logs Tab-----------------------------------------------------------------

//TTab LogTab (&TabGroup,"~Log files");
//TPushButton LogAppBut (&LogTab,1,15,10,"~Apply",PB_NORMAL);
//void LogTabCB (TObject *obj,char *arg)
//{ MainWin.m_set_info_message(arg);
//}

/*ͻ*/
/*                               CALLBACKS                                */
/*ͼ*/

void QuitCall(PObject /*sender*/,char */*arg*/)
{
  JPStop();
}

void do_JPTUI(void*)
{
  JPRun();
  palantir_deinit();
}

/*ͻ*/
/*                            MAIN PROGRAM                                */
/*ͼ*/


int main(int argc, char* /*argv*/[])
{

  palantir_init(DEV_COMMS|DEV_KEYBOARD|DEV_MOUSE);
  JPInit();

  SetFullScreenMode();
  // Callbacks declaration
//  SetMousePointerAspect(MPA_MOUSE_DRIVER);

  MainWin.m_set_close_button_pressed_callback(QuitCall,"");
  QuitButton.m_set_pressed_callback(QuitCall,"");

  MainWin.m_set_info_message("Comm ports setup dialog.");
  CommTab.m_set_visible_callback(CommTabCB,"Comm ports setup dialog.");
//  LogTab.m_set_visible_callback(LogTabCB,"Log files setup dialog.");
  CommBox.m_set_string_changed_callback(CommBoxValidateCB,"");
  CommAppBut.m_set_pressed_callback(CommAppButPressedCB,"");

  CommLst   = CommBox.m_get_list();
  BaudLst   = BaudBox.m_get_list();
  DataLst   = DataBox.m_get_list();
  ParityLst = ParityBox.m_get_list();
  StopLst   = StopBox.m_get_list();
  FlowLst   = FlowBox.m_get_list();

  MainWin.m_open();

  lwp_spawn(do_JPTUI,16384,1,NULL,NULL);
  lwp_spawn(read_comm_ini_file,16384,1,NULL,NULL);

  lwp_wait_true(&exit_program);

  // Once the program has been stopped (see QuitCall)...

  exit(EXIT_SUCCESS);
  return(0);
}


