/*
 * General purpose FIFO queue functions set.
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : queue.c
 * this file is part of DZComm v0.5
 */

#include "dzcomm.h"
#include "internal.h"

//------------------------- FIFO QUEUE -----------------------------
// 'first in first out' queue functions

inline void queue_reset(fifo_queue *q)
{ q->tail=0;
  q->head=0;
}
END_OF_FUNCTION(queue_reset);

int queue_resize(fifo_queue *q,uint new_size)
{ int *tmp;
  if ((tmp=(int*)realloc(q->queue,sizeof(int)*new_size))==NULL) return(0);

  if (new_size>q->size) q->resize_counter++;
  else if (new_size<=q->initial_size) q->resize_counter=0;
  else q->resize_counter--;

  q->queue=tmp;
  q->size=new_size;
  q->fill_level=3*(q->size>>2); // 3/4
  return(1);
}

void queue_delete(fifo_queue *q)
{ if (q==NULL) return;
  free(q->queue);
  free(q);
}


//---------------------- QUEUE PUT ----------------------------

inline int queue_put(fifo_queue *q,int c)
{ int t;
  int n=0;

  DISABLE();
  t=q->tail;
  q->tail++;
  ENABLE();
  if(t>=q->size)
   { q->resize_counter=0;
     queue_reset(q);
   }
  q->queue[t]=c;

  if (q->tail>=q->fill_level) n=1; //more then 3/4 of queue
  return(n);
}
END_OF_FUNCTION(queue_put);

//---------------------- QUEUE EMPTY ---------------------------

inline int queue_empty(fifo_queue *q)
{ if (q==NULL) return(1);
  if (q->head>=q->tail)
   { if (q->empty_handler!=NULL) return(-1);
     return(1);
   }
  return(0);
}
END_OF_FUNCTION(queue_empty);

inline int queue_get(fifo_queue *q)
{ int h;
  int c;

  DISABLE();
  h=q->head;
  q->head++;
  ENABLE();
  c=q->queue[h];
  if (q->head>=q->tail) queue_reset(q);
  return(c);
}
END_OF_FUNCTION(queue_get);

//------------------------------- QUEUE NEW --------------------------

fifo_queue* queue_new(uint size)
{ fifo_queue *q=(fifo_queue*)malloc(sizeof(fifo_queue));
  static n=0;

  if (q==NULL) return(NULL);
  if (!size) size=1024; //if illegal size, turn it to default size
  if ((q->queue=(int*)malloc(sizeof(int)*size))==NULL) return(NULL);

  q->size=size;
  q->initial_size=size;
  q->resize_counter=0;
  q->fill_level=3*q->size/4; // 3/4
  q->empty_handler=NULL;
  queue_reset(q);
  _go32_dpmi_lock_data(q->queue,sizeof(int)*size);
  _go32_dpmi_lock_data(q,sizeof(fifo_queue));

  if (n==0) //if call at first time
   { LOCK_FUNCTION(queue_empty);
     LOCK_FUNCTION(queue_put);
     LOCK_FUNCTION(queue_get);
     LOCK_FUNCTION(queue_reset);
     n=1;
   }
  return(q);
}

