/*

*
* MICHIS DIALOGKISTE V2.71
*
* 1997 BY Michi Schuster
* 
* email: Schuster@eev.e-technik.uni-erlangen.de 

*/

/* 
 * buttopti is for drawing text and text in buttons on a line
 * 
 * Allegroversion22 is mainly for listboxes, which have changed their 
 * look from the former verions. It saves the boxes a bit wider, so that
 * the space list-selector is added to the width. Also it is the plan 
 * to indicate the draw-style of the Dialogs (perhaps in the future)
 * 
 * */
int buttopti=0;
int Allegroversion22=0;

/*
 * _W/_H is the draw area 
 * 
 * */

int _W= 600;
int _H= 480;
/*
 * These variables should be self explaining- the default sizes of the objects
 * If you change the options, a CONFIG.CFG - file will be created.
 * 
 * */
int max_clearobj=2;
int max_keyobj=10;
int max_boxobj=10;
int max_sboxobj=10;
int max_buttonobj=10;
int max_textobj=30;
int max_ctextobj=10;
int max_checkobj=10;
int max_listobj=10;
int max_editobj=20;
int max_bitmapobj=10;
int max_radioobj=10;
int max_menobj=20;

int list_size=20;

int FG=251;
int BG=46;
int GRID=12;

int __W=800;
int __H=600;
int LEVELS=25;
int FUNC=30;

#include <allegro.h>
#include <stream.h>
#include <iostream.h>
#include <fstream.h>
#include <_string.h>
#include "pall.h"
#include "michi.h"

#include <string.h>
#define YES 'Y'
#define yes 'y'
#define no 'n'
#define NO 'N'
#define STRINGLENGTH 60
#define WAIT 1

#define ITEMS 20
//Some Commands

#define BLIT show_mouse(NULL);blit(Gui_area,screen,0,0,X_GUI,Y_GUI,_W,_H);show_mouse(screen)
#define str input_string(X_GUI,Y_GUI+_H+20,string_helper,251,125)
#define stri input_(X_GUI,Y_GUI+_H+20,string_helper,251,125)

int X_GUI;
int Y_GUI;

#define OUTPUTFILE "output.c"
#define EXPORTFILE "export.mdk"
#define INPUTFILE "input.c"

DATAFILE* set_up;
DATAFILE* picture;
DATAFILE* bitmaps;
BITMAP* Gui_area;
BITMAP* temp_area;
BITMAP* MICHI;
BITMAP* Schrift;


ofstream fout;
ifstream fin;
ofstream configout;
ifstream configin;

char string_helper[180];

/* 
 * The grid functions is responsible for the grid.
 * */
int grid(int x)
 {
    
    return (int(x/GRID)*GRID);
    
 }

void rebuild_screen()
     {
       show_mouse(NULL);
       BLIT;
       show_mouse(screen);
       };
/*
 * The next functions are mainly relicts from the former versions of MDK
 * I didn't kill them, perhaps I need them again for debugging in the
 * workprogress 
 */



void status(char* s)
     {

     /*   rebuild_screen();
         
        text_mode(-1);
	textout(screen,font,(unsigned char*) s,_W/3,__H-20,255);
        text_mode(1);
        */
     }

int ask_color()
     {
        return alert("Do you want to change colors?", NULL, NULL, "Yes", "Cancel", 'y', 27);
     }

int ask(char *s)
     {
      if (alert(s, NULL, NULL, "Yes", "No", 'y', 27)==1) return 0;
      else return 1;
     }
	

char* input_string(int x,int y, char* s,int fg,int bg)
     {

        int count=0;
        int k;
	int w;
	int h=text_height(font);
        clear_keybuf();
	status("Input a string");
        textout(screen, font,(unsigned char*) "INPUT:",x-text_length(font,(unsigned char*) "INPUT:"),y, fg);
	do
	{
	   k = readkey();
	   if ((k>>8)!=KEY_BACKSPACE)
	     {
                s[count]= k & 0xFF;
	     	count++;
	     	s[count]=0;
	     }
	   else
	     {
		count--;
		s[count]=0;
		rebuild_screen();
	     }
	   w=text_length(font,(unsigned char*) s);
	   textout(screen, font,(unsigned char*) s,x,y, fg);
	   
	}
	while (((k>>8)!= KEY_ENTER)&((k>>8)!=KEY_ESC));
        s[count-1]=0;
	rebuild_screen();

	return s;
      }

char* input_(int x,int y, char* s,int fg,int bg)
     {

        int count=0;
        int k;
	int w;
	int h=text_height(font);
        clear_keybuf();
        textout(screen, font,(unsigned char*) "INPUT:",x-text_length(font,(unsigned char*) "INPUT:"),y, fg);
	do
	{
	   k = readkey();
	   if ((k>>8)!=KEY_BACKSPACE)
	     {
                s[count]= k & 0xFF;
	     	count++;
	     	s[count]=0;
	     }
	   else
	     {
		count--;
		s[count]=0;
		rebuild_screen();
	     }
	   w=text_length(font,(unsigned char*) s);
	   textout(screen, font,(unsigned char*) s,x,y, fg);
	   
	}
	while (((k>>8)!= KEY_ENTER)&((k>>8)!=KEY_ESC));
        s[count-1]=0;
	rebuild_screen();
	
	return s;
     }


/* 
 * This is the error handler.
 * Mainly for loading and size errors. If you want to load more objects than you 
 * have enabled this will give a warning
 * */
void error(int a)
     {
	String error_text;
	switch (a)
	  {
	   case 1: error_text="Increase size of Menu-functions (OPTIONS-Objects) and restart porgramm!";
                break;
           case 2: error_text="File PALL.DAT not found. Cannot execute program.";
                break;
     	   case 3: error_text="File MICHI.DAT not found. Cannot execute program.";
                break;
	   case 4: error_text="Please increase number of Menus-objects (OPTIONS-Objects) and restart porgramm!";
                break;
           case 5: error_text="Please increase number of Menus-objects in Menu (OPTIONS-Objects) and restart porgramm!";
                break;
           case 6: error_text="Please increase number of shortcut-objects (OPTIONS-Objects) and restart porgramm!";
                break;
           case 7: error_text="Please increase number of objects (OPTIONS-Objects) and restart porgramm!";
                break;
	   case 8: error_text="Please increase objectsize (OPTIONS-Objects) and restart porgramm!";
                break;
       	   case 9: error_text="Please increase ListBox-objectsize (OPTIONS-Objects) and restart porgramm!";
               break;


	  }
	char gen[100]="WARNING:You want to create/load more objects than you have enabled with OPTIONS.";
	char gen2[100]="If the program hangs right now, restart, change and restart again.";
        char s[80];
        strcpy(s,error_text);
	alert(gen, s, gen2, "Ok", NULL, 'y', 27);

     }

class dialog
/*
 * The base class of all DIALOG- objects.
 * It has the same members, which are explained in the orginal DIALOG struct
 * of Allegro (see there).
 * The constructor needs a char* although not all derived classes need one.
 * I made this in order to get a better container template (see below).
 * The base class dialog will never be created, but all objects are derived from
 * it.
 * 
 * Also there are methods for handling the dialogs:
 * 
 * import()    
 *             reads the dialog of the specific mdk-file format
 * export()    
 *             saves the dialog in the specific mdk-file format
 * save()      
 *             saves the dialog in the C-style Allegro - Output file format
 * THIS(xm,ym) 
 *             checks if the point (xm,ym) is in the Dialog
 *
 * inside(xi,yi,wi,hi)
 *             checks if the area (xi,yi,wi,hi) is in the dialog
 *
 * copy(dialog& temp)
 *             copies the dialog temp into the current dialog
 * 
 * help() 
 *              only declared. Used in the derivats to call the specific
 *              help text (mostly the orginal Allegro text)
 * show_prop()
 *              showes the properties of the dialog, this means with this
 *              dialog you can display and modify all base members of a 
 *              dialog. Usually this envoked by a More-Button in MDK.
 *
 * char* input() 
 *              This function is not implemented on all dialog-derivats,
 *              but is thought for dialog-objects like the Listbox,
 *              where you can define and create the list items.
 * 
 * activate_func(BITMAP b=gui_area, int fgd=-1, int bg=0)
 *              Draws the dialog.
 *              MDK draws the dialog itself, this meant I had to copy 
 *              the drawing routine from the Allegro Source (GUI.C) into 
 *              there. THis might be a disadvantage, because if the 
 *              drawings are changed in a newer verion, I' ll have to 
 *              update it. But the advantage is that it's more flexible,
 *              and the whole program works more like a drawing program.
 *
 * 
 * */
     {
      public :
	
	int x,y,w,h,fg,bg,d1,d2;
        String name;
        String key;
        String flags;
        String dp;

        char* ask_for_input;

        dialog(char* dummy) {
             ask_for_input="Draw the size";
	     x=0;
	     y=0;
	     w=0;
	    h=0;
	     fg=FG;
	     bg=BG;
	     key="0";
	     flags="0";
	     d1=0;
	     d2=0;
	     dp="NULL";
	     name="dialog";
	  }
        ~dialog()
        {
         delete ask_for_input;
         }
        void export()
        {
	   fout<<"\n"<<name<<"\t"<<x<<"\t"<<y<<"\t"<<w<<"\t"<<h<<"\t"<<fg;
	   fout<<"\t"<<bg<<"\t"<<key<<"\t"<<flags<<"\t"<<d1<<"\t"<<d2;
	   fout<<"\t"<<dp<<"\n";
	}
	void import()
        {
	   fin>>name>>x>>y>>w>>h>>fg;
	   fin>>bg>>key>>flags>>d1>>d2;
	   fin>>dp;
	}
	
        int save()
	  {
	     fout<<"\n { "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\t"<<fg;
	     fout<<" ,\t"<<bg<<" ,\t"<<key<<" ,\t"<<flags<<" ,\t"<<d1<<" ,\t"<<d2;
	     fout<<" ,\t"<<dp<<"},";
          }
        int THIS(int xm,int ym)
          {
             int xt=xm-X_GUI;
             int yt=ym-Y_GUI;
             if ( ( (xt>x) && (xt<(x+w))) &&  ( (yt>y) && (yt<(y+h)))) return 1;
	     else return 0;
          }
        int inside(int xi,int yi,int wi,int hi)
         {
          if ( (x>=xi) && (y>=yi) && ((x+w)<(xi+wi)) && ( (y+h)<(yi+hi))) return 1;
          return 0;
         }
        void copy (dialog& temp, int& xc, int& yc)
	  {
             yc=yc+25;
             xc=xc+25;
	     x=temp.x+grid(xc);;
	     y=temp.y+grid(xc);
	     w=temp.w;
	     h=temp.h;
	     fg=temp.fg;
	     bg=temp.bg;
	     d1=temp.d1;
	     d2=temp.d2;
	     name=temp.name;
	     flags=temp.flags;
	     key=temp.key;
	     dp=temp.dp;

	  };
        void help();
        int show_prop(int sfg,int sbg)
	  {
   
	     char key_char[12];
             strcpy(key_char,key) ;
	     char flag_char[STRINGLENGTH];
             strcpy(flag_char,flags);
             char data_pointer[STRINGLENGTH];
             strcpy(data_pointer,dp);
	     char d1_feld[3];
             itoa(d1,d1_feld,10);
	     char d2_feld[3];
             itoa(d2,d2_feld,10);

             char xt[4];
             itoa(x,xt,10);
             char yt[4];
             itoa(y,yt,10);

             char wt[4];
             itoa(w,wt,10);
             char ht[4];
             itoa(h,ht,10);

             char fgt[4];
             itoa(sfg,fgt,10);
             char bgt[4];
             itoa(sbg,bgt,10);
             #define dpos 19
             #define DX 250
             #define dcol 20
             #define dhelp 23
             #define dmore 22
	     DIALOG prop_dialog[]= { 
		  { d_shadow_box_proc ,	304+DX ,	24 ,	228 ,	168 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		  { d_text_proc ,	316+DX ,	36 ,	72 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Type:" },
		  { d_text_proc ,	364+DX ,	36 ,	144 ,	12 ,	221 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 name },
		  { d_text_proc ,	316+DX ,	48 ,	84 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Postion:" },
		  { d_text_proc ,	400+DX ,	48 ,	36 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 xt },
		  { d_text_proc ,	424+DX ,	48 ,	12 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "," },
		  { d_text_proc ,	436+DX ,	48 ,	36 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 yt },
		  { d_text_proc ,	316+DX ,	60 ,	84 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Size<w,h>:" },
		  { d_text_proc ,	400+DX ,	60 ,	36 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 wt },
		  { d_text_proc ,	424+DX ,	60 ,	12 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "," },
		  { d_text_proc ,	436+DX ,	60 ,	36 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 ht },
		  { d_text_proc ,	460+DX ,	98 ,	36 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 fgt },
		  { d_text_proc ,	484+DX ,	98 ,	12 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "," },
		  { d_text_proc ,	496+DX ,	98 ,	36 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 bgt },
		  { d_text_proc ,	316+DX ,	120 ,	60 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Key:" },
		  { d_text_proc ,	316+DX ,	132 ,	60 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Flag:" },
		  { d_text_proc ,	316+DX ,	144 ,	84 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "<d1,d2>:" },
		  { d_text_proc ,	400+DX ,	144 ,	12 ,	12 ,	143 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "," },
		  { d_text_proc ,	316+DX ,	156 ,	120 ,	12 ,	31 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Datapointer:" },
		  { d_button_proc ,	376+DX ,	72 ,	144 ,	12 ,	31 ,	96 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Change:Pos/Size" },
		  { d_button_proc ,	316+DX ,	96 ,	120 ,	12 ,	31 ,	96 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Colors<fg,bg>" },
		  { d_button_proc ,	328+DX ,	168 ,	48 ,	12 ,	31 ,	96 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "OK" },
		  { d_button_proc ,	388+DX ,	168 ,	72 ,	12 ,	31 ,	96 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "More" },
		  { d_button_proc ,	472+DX ,	168 ,	48 ,	12 ,	31 ,	96 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
		  { d_edit_proc ,	352+DX ,	120 ,	132 ,	12 ,	140 ,	96 ,	0 ,	0 ,	STRINGLENGTH ,	1 ,	key_char},
		  { d_edit_proc ,	364+DX ,	132 ,	132 ,	12 ,	140 ,	96 ,	0 ,	0 ,	STRINGLENGTH ,	1 ,	flag_char},
		  { d_edit_proc ,	424+DX ,	156 ,	96 ,	12 ,	140 ,	96 ,	0 ,	0 ,	STRINGLENGTH ,	1 ,	data_pointer},
		  { d_edit_proc ,	388+DX ,	144 ,	48 ,	12 ,	140 ,	96 ,	0 ,	0 ,	STRINGLENGTH ,	1 ,	d1_feld},
		  { d_edit_proc ,	412+DX ,	144 ,	48 ,	12 ,	140 ,	96 ,	0 ,	0 ,	STRINGLENGTH ,	1 ,	d2_feld},
		  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	     };
	     popup_dialog(prop_dialog,-1);

             key=key_char;
             flags=flag_char;
             dp=data_pointer;
             d1=atoi(d1_feld);
             d2=atoi(d2_feld);

             if (prop_dialog[dhelp].flags==MSG_DCLICK) return -1;

             if (prop_dialog[dpos].flags==MSG_DCLICK)
               {
                pos();
                return 1;
               }

             if (prop_dialog[dmore].flags==MSG_DCLICK)
               {
                return 2;
               }
             if (prop_dialog[dcol].flags==MSG_DCLICK) return 0;

             return 1;



	  }

        pos();
        char* input() {};

        int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
 };

/*
 * 
 * The next classes explain themselves, the names are identical.
 * 
 * */
class gui_d_clear_proc: public dialog
/*
 * Clear-procs are unvisable. For better controlling I've drawn
 * a dotted rect.
 * 
 * */
     {
      public:
	int c;
        gui_d_clear_proc(char* dummy) : dialog(dummy)
	  {
	     c=0;
	     name="d_clear_proc";
             fg=33;
	  }
	int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
	  {

           if (fgd==33)
              {
            for (int tx=0;tx<=w;tx=tx+2)
                {
                 putpixel(b,x+tx, y,255);
                 putpixel(b,x+tx, y+h,255);
                 };
	    for (int ty=0;ty<=h;ty=ty+2)
                {
                 putpixel(b,x,y+ty,255);
                 putpixel(b,x+w, y+ty,255);
                 };
               }
            else rect(b,x,y,x+w,y+h,254);

              
             }
         void help();
	
     };


class gui_d_shadow_box_proc: public dialog
     {
      public:
	gui_d_shadow_box_proc(char* dummy) : dialog(dummy)
	  {
	     name="d_shadow_box_proc";
	  }
	int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
	  {
             if (fgd==-1) {fgd=fg;bgd=bg;};

	     rectfill(b, x+1, y+1, x+w-2, y+h-2, bgd);
	     rect(b, x, y, x+w-1, y+h-1, fgd);
	     vline(b, x+w, y+1, y+h, fgd);
	     hline(b, x+1, y+h, x+w, fgd);
              

	  }
        void help();

     };
class gui_d_box_proc: public dialog
     {
      public:
	gui_d_box_proc(char* dummy) : dialog(dummy)
	  {
	     name="d_box_proc";
	  }
      void help();
      int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
	  {
             if (fgd==-1) {fgd=fg;bgd=bg;};
             rectfill(b, x+1, y+1, x+w-1, y+h-1, bgd);
             rect(b, x, y, x+w, y+h, fgd);
              
            }

     };

class gui_d_text_proc:public dialog
/*
 * The next class is the base class of all text-dialog objects.
 * These are all dialog objects which contain a data in the dp 
 * field. 
 * The additional member char* s always contains text. For 
 * pure text objects s and dp is the same, but s was necessary 
 * for the textout-function.
 * 
 * _textout(): 
 *        the same as activate_ func()- draws the text, cares 
 *        about the &-charakter (underlining). It was done,
 *        for better reading the code, cause derivates need to
 *        draw text (e.g. button) and have another activate_func()
 *
 * the return value of char* input() is the content of s.
 * */
     {
      public:
	 char s[STRINGLENGTH];
	int centre;
      public:
	gui_d_text_proc( char* text):dialog(text)
	  {
	     dp=text;
	     strcpy(s,text);
	     centre=FALSE;
	     name="d_text_proc";
	  }
        void help();
        void rename(char* text)
	  {
	     dp=text;
	     strcpy(s,text);
	  }
        copy(gui_d_text_proc& from,int& xc, int& yc)
	  {
	     dialog::copy(from,xc,yc);
	     strcpy(s,from.s);
	  }
	
        void export()
	  {
             dp="DUMMY";
	     dialog::export();
             fout<<"\n"<<s<<"\t"; /* The s-argument can include spaces */
             dp=s;


	  }
        void import()
	  {
	     dialog::import();
             fin.getline(s,255); /* There is a newlinechar*/
             fin.getline(s,255);
             dp=s;
	  }
	void position()
	  {
	     set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
             position_mouse(X_GUI,Y_GUI);
	     
             if (WAIT) rest(500);
             while (!(mouse_b & 1));
	     x=grid(mouse_x)-X_GUI;
	     y=grid(mouse_y)-Y_GUI;
             set_mouse_range(0,0,__W,__H);
	  }
        char* input()
	  {

	     
	     // Allegro - C- code done with MichisDialogkiste 
	     
	     char id[STRINGLENGTH];
	     strcpy(id,name);
	     char input_string[STRINGLENGTH];
             strcpy(input_string,dp);

	     DIALOG id_dialog[]= {
		  { d_shadow_box_proc ,	208 ,	348 ,	216 ,	60 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		  { d_text_proc ,	220 ,	360 ,	156 ,	128 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 id },
		  { d_text_proc ,	220 ,	372 ,	48 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "name:" },
		  { d_button_proc ,	220 ,	384 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
		  { d_button_proc ,	364 ,	384 ,	48 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
		  { d_button_proc ,	292 ,	384 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "more" },
		  { d_edit_proc ,	268 ,	372 ,	150 ,	12 ,	12 ,	28 ,	0 ,	0 ,	28 ,	1 ,	input_string},
		  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	     };
	     
	     do
	       {
		  do_dialog(id_dialog,-1);
		  strcpy(s,input_string);
		  dp=input_string;
		  if (id_dialog[5].flags==MSG_DCLICK)
		    show_prop(128,255);
		  if (id_dialog[4].flags==MSG_DCLICK)
		    help();
	       } while (id_dialog[3].flags!=MSG_DCLICK);
	     
	     return input_string;
	     
	     
	  }
       	int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
	
	  {
             char s[STRINGLENGTH];
	     if (fgd==-1) {fgd=fg;bgd=bg;};
	     unsigned char tmp[160];
             int c;
	     int len = 0;
	     int pix_len;
	     int hline_pos = -1;
             int x_temp=x;
             //if the dialog is centered the x value is changed
	     strcpy(s,dp);

             text_mode(bgd);
	     for (c=0; (s[c]) && (len<159); c++) {
		if (s[c] == '&') {
		   if (s[c+1] != '&')
		     hline_pos = len;
		   else {
		      tmp[len++] = '&';
		      c++;
		   }
		}
		else
		  tmp[len++] = s[c];
	     }
	     
	     tmp[len] = 0;
	     pix_len = text_length(font,tmp);
	     
	     if (centre)
	       x -= pix_len / 2;
	     
	     if (b) {
		textout(b, font, tmp, x, y, fgd);
		
		if (hline_pos >= 0) {
		   c = tmp[hline_pos];
		   tmp[hline_pos] = 0;
		   hline_pos = text_length(font, tmp);
		   tmp[0] = c;
		   tmp[1] = 0;
		   c = text_length(font, tmp);
		   hline(b, x+hline_pos, y+text_height(font), x+hline_pos+c-1, fgd);
		}
	     }
             x=x_temp;
	     return pix_len;
	  }
	int _textout( char* s,int x, int y, int fg,int bg,BITMAP* b = Gui_area)

	  {
	     unsigned char tmp[160];
             int c;
	     int len = 0;
	     int pix_len;
	     int hline_pos = -1;
	     
             text_mode(bg);
	     for (c=0; (s[c]) && (len<159); c++) {
		if (s[c] == '&') {
		   if (s[c+1] != '&')
		     hline_pos = len;
		   else {
		      tmp[len++] = '&';
		      c++;
		   }
		}
		else
		  tmp[len++] = s[c];
	     }
	     
	     tmp[len] = 0;
	     pix_len = text_length(font, tmp);
	     
	     if (centre)
	       x -= pix_len / 2;
	     
	     if (b) {
		textout(b, font, tmp, x, y, fg);
		
		if (hline_pos >= 0) {
		   c = tmp[hline_pos];
		   tmp[hline_pos] = 0;
		   hline_pos = text_length(font, tmp);
		   tmp[0] = c;
		   tmp[1] = 0;
		   c = text_length(font, tmp);
		   hline(b, x+hline_pos, y+text_height(font), x+hline_pos+c-1, fg);
		}
	     }
	     return pix_len;
	  }
	int save()
	  {
	     fout<<"\n { "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\t"<<fg;
	     fout<<" ,\t"<<bg<<" ,\t"<<key<<" ,\t"<<flags<<" ,\t"<<d1<<" ,\t"<<d2;
	     fout<<" ,\t \""<<dp<<"\" },";
          }

	
     };

class gui_d_ctext_proc:public gui_d_text_proc

     {
      public:
	gui_d_ctext_proc( char* text):gui_d_text_proc(text)
	  {
	     centre=TRUE;
	     name="d_ctext_proc";

	  }
      void help();
     };
class gui_d_bitmap_proc:public gui_d_text_proc
     {
       int dehn;
       int num;
      public:
	gui_d_bitmap_proc( char* text):gui_d_text_proc(text)
	  {
	     centre=FALSE;
	     name="d_bitmap_proc";
             dp="NULL";
             dehn=1;
             num=0;

	  }
       int save(){dialog::save();}
       int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
        {
          if (fgd==-1) {fgd=fg;bgd=bg;};
          BITMAP *b1;
          b1=create_bitmap(w,h);
          if (dehn) stretch_blit( (BITMAP*) bitmaps[num].dat, b1, 0, 0, 194, 194,0, 0, w, h);
           else b1=(BITMAP*) bitmaps[num].dat;
          blit(b1, b,0,0,x,y, w, h);
      }

     char* input()
     {
       // Allegro - C- code done with MichisDialogkiste 


 	char file[STRINGLENGTH];
        itoa(num,file,10);

        DIALOG id_dialog[]= {
 	{ d_shadow_box_proc ,	68 ,	84 ,	224 ,	104 ,	96 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
        { d_text_proc ,	80 ,	96 ,	120 ,	12 ,	249 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Bitmap_proc:" },
 	{ d_text_proc ,	80 ,	144 ,	84 ,	12 ,	96 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Bitmap_no:" },
 	{ d_button_proc ,	80 ,	156 ,	48 ,	12 ,	96 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
 	{ d_button_proc ,	140 ,	156 ,	48 ,	12 ,	96 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "More" },
 	{ d_button_proc ,	200 ,	156 ,	48 ,	12 ,	96 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
	{ d_edit_proc ,	176 ,	144 ,	48 ,	12 ,	100 ,	28 ,	0 ,	0 ,	1,STRINGLENGTH,	file},
      	{ d_radio_proc ,80 ,	112 ,	100 ,	12 ,	96 ,	28 ,	0 ,	D_SELECTED ,     0 ,	0 ,	 "Stretch to fit"},
      	{ d_radio_proc ,80 ,	128 ,	100 ,	12 ,	96 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Orginal-sitze"},
        { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
 	};
        do  {
		  popup_dialog(id_dialog,-1);
		  strcpy(s,file);
		  dp=file;
//                  dp=dp+s;
                  num=atoi(file);
		  if (id_dialog[4].flags==MSG_DCLICK)
		    show_prop(128,255);
		  if (id_dialog[5].flags==MSG_DCLICK)
		    help();
/*                  if (id_dialog[6].flags==MSG_DCLICK)
                    {
		     if (file_select("Bitmap-File",s,"DAT") )
                       {
                        dp=s;
                        strcpy(file,s);
                        };
                      }
  */
                dehn=0;
  		if (id_dialog[7].flags==D_SELECTED) dehn=1;
	       } while (id_dialog[3].flags!=MSG_DCLICK);
	     
	     return file;
       }

      void help();
     };

class gui_d_edit_proc:public gui_d_text_proc

     {
      public:
	gui_d_edit_proc( char* pointer):gui_d_text_proc(pointer)
	  {
	     centre=FALSE;
	     name="d_edit_proc";
	     dp=String(pointer);
	     strcpy(s,"INPUT");
	   }
        void help();
	void export()
	  {
             dialog::export();
             fout<<"\n"<<s<<"\t"; /* The s-argument can include spaces */
          }
	void import()
	  {
	     dialog::import();
	     fin.getline(s,255); /* There is a newlinechar*/
             fin.getline (s,255);
          }
	
        void default_string(char* zu)
	  {
	     strcpy(s,zu);
	     activate_func();
	  }
        void save_string()
	  {
             fout<<"\n char "<<dp<<"["<<d1<<"]=\""<<s<<"\" ;\n";
	  };
	void save()
	  {
	     dialog::save();
          }
      	int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)

	  {
           if (fgd==-1) {fgd=fg;bgd=bg;};
            _textout(s,x,y,fgd,bgd,b);
	  }

        char* input()
       {


	  // Allegro - C- code done with MichisDialogkiste 
	  char d1_feld[3];
	  itoa(8,d1_feld,10);
	  char d2_feld[3];
	  itoa(1,d2_feld,10);
	  char id[STRINGLENGTH];
	  strcpy(id,name);
	  char input_string[STRINGLENGTH];
	  strcpy(input_string,dp);

	  DIALOG id_dialog[]= {
	       { d_shadow_box_proc ,	208 ,	288 ,	216 ,	120 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
	       { d_text_proc ,	220 ,	300 ,	156 ,	24 ,	136 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 id },
	       { d_text_proc ,	220 ,	312 ,	48 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "String-name:" },
	       { d_text_proc ,	220 ,	336 ,	48 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Default_Text:" },
	       { d_text_proc ,	220 ,	360 ,	132 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Startposition_d2:" },
	       { d_text_proc ,	220 ,	372 ,	144 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Maximum-Chars_d1:" },
	       { d_button_proc ,	220 ,	384 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
	       { d_button_proc ,	364 ,	384 ,	48 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
	       { d_button_proc ,	292 ,	384 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "More" },
	       { d_edit_proc ,	220 ,	324 ,	160 ,	12 ,	15 ,	28 ,	0 ,	0 ,	28 ,	1 ,	input_string},
	       { d_edit_proc ,	220 ,	348 ,	160 ,	12 ,	15 ,	28 ,	0 ,	0 ,	28 ,	1 ,	s},
	       { d_edit_proc ,	364 ,	360 ,	60 ,	12 ,	15 ,	28 ,	0 ,	0 ,	3 ,	1 ,	d2_feld},
	       { d_edit_proc ,	364 ,	372 ,	60 ,	12 ,	15 ,	28 ,	0 ,	0 ,	3 ,	1 ,	d1_feld},
	       { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	  };
	  do
	    {
	       do_dialog(id_dialog,-1);
	       dp=input_string;
	       
	       d1=atoi(d1_feld);
	       d2=atoi(d2_feld);
	       
	       if (id_dialog[8].flags==MSG_DCLICK)
	       	 show_prop(128,255);
	       if (id_dialog[7].flags==MSG_DCLICK)
	       	 help();
	    }
	  while (id_dialog[6].flags!=MSG_DCLICK);
	  
	  return input_string;
	  
	  
       }
	
	
     };


class gui_d_button_proc:public gui_d_text_proc
     {
      public:
	gui_d_button_proc( char* text):gui_d_text_proc(text)
	  {
	     centre=TRUE;
       	     flags="D_EXIT";
	     name="d_button_proc";
	  }
        void help();
		
	int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
	  {
             if (fgd==-1) {fgd=fg;bgd=bg;};
             int v=0;
             strcpy(s,dp);
	     text_mode(bgd);
             if (buttopti) v=-1;
     	     rectfill(b, x, y+v, x+w, y+v+h, bgd);
	     rect(b, x, y+v, x+w-1, y+v+h-1, fgd);
	     vline(b, x+w, y+v+1, y+v+h-1, fgd);
	     hline(b, x+1, y+v+h, x+w, fgd);
    	     _textout(s,x+w/2, y+v+h/2-text_height(font)/2, fgd,bgd,b);

	  }
        void save()
        {
         if (buttopti) y=y-1;
         gui_d_text_proc::save();
         }
     };

class gui_d_radio_proc:public gui_d_text_proc
     {
      public:
	gui_d_radio_proc( char* text):gui_d_text_proc(text)
	  {
	     centre=FALSE;
       	     flags="0";
	     name="d_radio_proc";
	  }
        void help();
        int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
        {
         if (fgd==-1) {fgd=fg;bgd=bg;};
         int center,r;
         text_mode(bgd);
	 _textout(s,x+h+text_height(font),y+(h-(text_height(font)-gui_font_baseline ))/2, fgd,bgd,b);
	 r = h/2;
	 center = x+r;
	 rectfill(b, x+1, y+1, x+h-1, y+h-1, bgd);

	 switch (d2) {

	    case 1:
	       rect(b, x,y, x+h, y+h, fgd);
	       if (flags == "D_SELECTED")
		  rectfill(b, x+r/2, y+r/2, x+h-r/2, y+h-r/2, fgd);
	       break;

	    default:
	       circle(b, center, y+r, r, fgd);
	       if (flags == "D_SELECTED")
		  circlefill(b, center, y+r, r/2, fgd);
	       break;
            }
         }
        char* input()
        {
          // Allegro - C- code done with MichisDialogkiste 


	 char d1f[25]="0" ;

	 char Button[25]="Buttontext" ;

	 DIALOG id_dialog[]= {
	 { d_shadow_box_proc ,	68 ,	96 ,	192 ,	132 ,	96 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
	 { d_text_proc ,	80 ,	108 ,	120 ,	12 ,	249 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Radio-Button" },
	 { d_text_proc ,	80 ,	132 ,	84 ,	12 ,	96 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Group_(d1):" },
	 { d_text_proc ,	80 ,	168 ,	84 ,	12 ,	96 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Button_Text:" },
	 { d_button_proc ,	80 ,	204 ,	48 ,	12 ,	96 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
	 { d_button_proc ,	140 ,	204 ,	48 ,	12 ,	96 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "More" },
	 { d_button_proc ,	200 ,	204 ,	48 ,	12 ,	96 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
	 { d_radio_proc ,	80 ,	144 ,	96 ,	12 ,	96 ,	28 ,	0 ,	D_SELECTED ,	0 ,	0 ,	 "Circle" },
	 { d_radio_proc ,	164 ,	144 ,	72 ,	12 ,	96 ,	28 ,	0 ,	0 ,	0 ,	1 ,	 "Rect" },
	 { d_edit_proc ,	176 ,	132 ,	48 ,	12 ,	100 ,	28 ,	0 ,	0 ,	8 ,	1 ,	d1f},
	 { d_edit_proc ,	80 ,	180 ,	144 ,	12 ,	100 ,	28 ,	0 ,	0 ,	28 ,	1,	Button},
	 { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	 };

             do
	       {
		do_dialog(id_dialog,-1);
		strcpy(s,Button);
                dp=Button;
		  if (id_dialog[6].flags==MSG_DCLICK)
		    help();
                d1=atoi(d1f);
                d2=0;
       	        if (id_dialog[8].flags==2) d2=1;


       	       if (id_dialog[5].flags==MSG_DCLICK)
		    show_prop(128,255);

	       } while (id_dialog[4].flags!=MSG_DCLICK);
	     
	     return Button;
	
        }


        void save()
        {
         if (buttopti) y=y-1;
         gui_d_text_proc::save();
         }
     };

class gui_d_check_button_proc:public gui_d_text_proc
     {
       public:
     gui_d_check_button_proc( char* text):gui_d_text_proc(text)
	  {
	     name="d_check_proc";
	  }
        void help();
	
        int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
	  {
             if (fgd==-1) {fgd=fg;bgd=bg;};
             int xbox;
             int ytext;
             text_mode(bgd);
     	     xbox=x+_textout(s,x,y+(h-8)/2, fgd,bgd,b)+4;
	     
	     rectfill(b, xbox, y, xbox+h-1, y+h-1, bgd);
	     rect(b, xbox, y, xbox+h, y+h, fgd);
	     

	  }

     };

/*
 * 
 * The next definition is because of the behaviour of Allegros 
 * list selector- function. The Pointer to the dp field of a 
 * list-box seems to have to be defined globally 
 * 
 * */
char** listobjects;
char* Liste5 (int index, int* listsize) {
    if (index < 0)
	 { *listsize =list_size;
	   return NULL;}
 else return listobjects[index];}

class gui_d_listbox_proc:public gui_d_text_proc
/* 
 * The ListboxObject has addtionally a String* for holding the Strings in the
 * Listboxes
 * 
 * The draw style of Listboxes is (still) Allegro 2.1 ...
 * 
 * */
     {

      public:
         int mxs;
         String* temps;

	int size;
	 char* data(int index)
	  { 
	     if ((index < 0)&&(index>mxs)) return NULL;
	      else 
 	       {
		  char s[STRINGLENGTH];
		  int len=0;
		  strcpy(s,temps[index]);
		  while (s[len]!=NULL) len++;
		  while (text_length(font,(unsigned char*) s) >w)
		     {
			s[len]=NULL;
			len--;
		     }
		  return s;
	       }
	  }
	
      gui_d_listbox_proc( char* text):gui_d_text_proc(text)
	  {
	     name="d_list_proc";
             mxs=list_size;
	     size=0;


            temps=new String[mxs] ("**EMPTY**");
	  }
      ~gui_d_listbox_proc()
      {
       delete[] temps;
       }
        void help();
	
        void save_items()
           {
	      if (size>0)
		{
		   fout<<"\nchar* "<<s<<" (int index, int* list_size) { \n";
		   fout<<"    static char* strings[]={";
		   for (int t=0;t<size-1;t++) fout<<"\""<<temps[t]<<"\" , ";
		   
		   fout <<"\""<<temps[size-1]<<"\" };\n";
		   fout<<"if (index < 0) \n\t { *list_size ="<<size<<";\n";
		   fout<<"\t   return NULL;}";
		   fout<<"\n else return strings[index];}\n\n";
		}
           }
	
        void export()
	  {
	     dialog::export();
             fout<<size;
	     for (int t=0;t<size;t++)
	       fout<<"\t"<<temps[t];
             fout<<"\n";
	     
          };
        void import()
	  {
	     dialog::import();
             fin>>size;
	     for (int t=0;t<size;t++)
               fin>>temps[t];
             strcpy(s,dp);
	  }
	void copy(gui_d_listbox_proc& from,int& xc, int& yc)
	  {
	     dialog::copy(from, xc, yc);
	     for (int t=0;t<from.size;t++)
	       temps[t]=from.temps[t];
	     size=from.size;
	  }
	
        char* input ()
	  {
	     int dial;
	     int list_selector=size;
	     
	     char list_name[STRINGLENGTH];
	     strcpy(list_name,dp);
	     for (int t=0;t<mxs;t++)
	       
	       {
		  //temps[t]=strings[t];
		  strcpy(listobjects[t],temps[t]);
		  
	       }
	     
	     DIALOG id_dialog[]= {
		  { d_shadow_box_proc ,	148 ,	180 ,	216 ,	216 ,	187 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		  { d_text_proc ,	160 ,	192 ,	156 ,	12 ,	16 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "ListBox" },
		  { d_text_proc ,	160 ,	216 ,	108 ,	12 ,	187 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "List-function:" },
		  { d_text_proc ,	160 ,	252 ,	180 ,	12 ,	187 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Objects_in_List:" },
		  { d_text_proc ,	160 ,	348 ,	180 ,	12 ,	187 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Double-Click-on-List" },
		  { d_button_proc ,	160 ,	372 ,	48 ,	12 ,	187 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
		  { d_button_proc ,	220 ,	372 ,	60 ,	12 ,	187 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "More" },
		  { d_button_proc ,	292 ,	372 ,	60 ,	12 ,	187 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
		  { d_edit_proc ,	160 ,	228 ,	156 ,	12 ,	200 ,	28 ,	0 ,	0 ,	1 ,	8 ,	list_name},
		  { d_list_proc ,	160 ,	276 ,	192 ,	60 ,	187 ,	28 ,	0 ,	D_EXIT ,	list_selector ,	0 ,	Liste5},
		  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	     };
	     
	     do{
		for (int t=0;t<mxs;t++)
		  strcpy(listobjects[t],temps[t]);
		popup_dialog(id_dialog,-1);
		dial=id_dialog[5].flags;
		
		if (id_dialog[6].flags==MSG_DCLICK)
		  show_prop(128,255);
		
		if (id_dialog[7].flags==MSG_DCLICK)
		  help();
		
		if (id_dialog[9].flags==MSG_DCLICK)
		  {
		     
		     list_selector=id_dialog[9].d1;
		     char temp_char[STRINGLENGTH]="None";
		     String helper_string;
		     if (list_selector>size) list_selector=size;
		     DIALOG item_dialog[]= {
			  { d_shadow_box_proc ,	208 ,	348 ,	216 ,	60 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
			  { d_text_proc ,	220 ,	360 ,	96 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Edit Item:" },
			  { d_button_proc ,	220 ,	384 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
			  { d_button_proc ,	352 ,	384 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Delete" },
			  { d_edit_proc ,	220 ,	372 ,	150 ,	12 ,	12 ,	28 ,	0 ,	0 ,	STRINGLENGTH ,	1 ,   temp_char},
			  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
		     };
		     popup_dialog(item_dialog,-1);
		     if (item_dialog[3].flags==MSG_DCLICK)
		       {
			  if (size) size--;
			  temps[size]="**EMPTY**";
		       }
		     else
		       {
			  temps[list_selector]=temp_char;
			  if (list_selector==size)  size++;
		       }
		     
		  }

		
		
		
	     }
	     while (dial!=MSG_DCLICK);
	     
	     
	     
	}
	int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)

	  {
             if (fgd==-1) {fgd=fg;bgd=bg;};
	     int height;
	     int listsize;
	     int i; 
	     char *s;
	     int y_;
           	     /* draw frame */
	     rectfill(b, x, y, x+w, y+h, bgd);
	     rect(b, x+1, y+1, x+w-1, y+h-1, fgd);
	     
	     height = (h-3) / text_height(font)-1;
	     y_=y+3;
	     
	     /* draw box contents */

	     for (i=0; i<size; i++)
	       {
		if (i<height)
		    {
		       
		       s =data(i);
		       text_mode(fgd);
		       _textout(s, x+2, y_, fgd,bgd,b);
		       y_=y_+text_height(font);
		    }
	     
                if (i>height)
		    {
		       s = "v v v v";
		       int len=0;
		       while (s[len]!=NULL) len++;
		       while (text_length(font,(unsigned char*) s) >w)
			 {
			    s[len]=NULL;
			    len--;
			 }
		       _textout(s, x+2, y_,bgd,fgd,b);
		    };
	       }
              

	  }
	void save()
	  {
            if (Allegroversion22) w=w+12;
            dialog::save();
	  }

     };


class gui_d_keyboard_proc: public gui_d_text_proc
     {
      public:
	gui_d_keyboard_proc(char* text,String keyt):gui_d_text_proc(text)
	  {
	     key=keyt;
	     name="d_keyboard_proc";
	  };
	int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0){};
        void help();
     };



class menu_item
/*
 * Allegro's MENUs items have a name, and are conntected to a
 * Function (function_name) or a Menu (connect_function) 
 *
 * clear() 
 *      clears the dependency and sets them to 0;
 * func_exe(char* func)
 *      connects to function_name
 * submenu(char* submen)
 *      connects to submenu
 * */


     {
	
      public:
	char name[STRINGLENGTH];
	char function_name[STRINGLENGTH];
	char connect_func[STRINGLENGTH];
	int connect;
	
      public:
	menu_item()
	  {
             strcpy(name,"NULL");
             strcpy(function_name,"NULL");
             strcpy(connect_func,"NULL");
             connect=0;
	     
	  }
        void clear()
        {
             strcpy(function_name,"NULL");
             strcpy(connect_func,"NULL");
             connect=0;
         }

        void name_item( char* title)
        {
         strcpy(name,title);
         }
        void func_exe( char* func)
          {
             strcpy(function_name,func);
             connect=1;
          }

        void submenu( char* menu_)
          {
             strcpy(connect_func,menu_);
             connect=2;
             }


	void save()
	  {
	     fout<<"\n { \""<<name<<"\"\t, "<<function_name<<" \t,"<<connect_func<<"},";
	  }

	void export()

        {
             if (!strcmp(name," ")) strcpy(name,"@");
             if (!strcmp(name,"")) strcpy(name,"@");

	     fout<<"\n "<<name<<"\n"<<function_name<<"\n"<<connect_func<<"\n"<<connect;
	  }
        void import()
	  {
	     fin>>name>>function_name>>connect_func>>connect;
             if (!strcmp(name,"@")) strcpy(name,"");

	  }



      };
/*
 * Just like  textout
 * */

int text( char* s,int x, int y, int fg,int bg,int DRAW,BITMAP* b = Gui_area)

     {
	unsigned char tmp[160];
	int c;
	int len = 0;
	int pix_len;
	int hline_pos = -1;
	
	text_mode(bg);
	for (c=0; (s[c]) && (len<159); c++) {
	   if (s[c] == '&') {
	      if (s[c+1] != '&')
	      	hline_pos = len;
	      else {
		 tmp[len++] = '&';
		 c++;
	      }
	   }
	   else
	     tmp[len++] = s[c];
	}
	
	tmp[len] = 0;
	pix_len = text_length(font, tmp);
	if (DRAW) {
	   textout(b, font,tmp, x, y, fg);
	   
	   if (hline_pos >= 0) {
	      c = tmp[hline_pos];
	      tmp[hline_pos] = 0;
	      hline_pos = text_length(font, tmp);
	      tmp[0] = c;
		   tmp[1] = 0;
	      c = text_length(font, tmp);
	      hline(b, x+hline_pos, y+text_height(font), x+hline_pos+c-1, fg);
	     
	   }
            
 	}
	return pix_len;
     }

#define MAXITEMS 20
class MainMenu:public dialog
/* 
 * Dialog Menu, necessary for menu handling.
 * Every menu will be started from the DIALOG, so the base MENU has 
 * to be called by a d_menu_proc (see Allegro-text)
 *
 * */
  
     {
       public:
     	MainMenu(String pointer):dialog("DUMMY" )
	  {
	     name="d_menu_proc";
	     dp=pointer;
	  }

	int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
	  {
	  }

     };

class Menu
/* 
 * Holds a number of menus, declared in the constructor,
 * this number is the global sub_menobj and defines how many 
 * items a Menu can maximal contain
 *
 * _level() 
 *          is for giving default names of the menus (strored in 
 *          char level[]) like "Menu0" up to Menu25 (if the maxium 
 *	    of Menus is 25). 
 * declare_main()
 *          declares the menu as the Main Menu,wich is pointed to 
 *          by the d_menu_proc dp-field
 * clear_main()
 * edit_item()
 * clear_item()
 *          These should explain themselves
 * 
 * *char show(int) 
 * *char type(int)
 *           These give back the type and the connections of the item[num]
 *      
 * draw()
 *          Draws the menu in Allegro v2.1 style
 * 					     
 * import()
 * export()
 * save()	
 *           The same as in dialog class
 * */

     {
	      private:
	menu_item* items;
	
      public:
	
        char level[STRINGLENGTH];
        int size;
	int main;
        int max;
	
	Menu(int num)
	  {
	     size=0;
	     main=FALSE;
             items=new menu_item[num];
             max=num;
	     
	  }
        ~Menu()
        {
         delete[] items;
         }
        level_(int num)
	  {
	     char levelnumber[STRINGLENGTH];
	     strcpy(level,"Menu");
	     itoa(num,levelnumber,10);
	     strcat(level,levelnumber);
	  }
	
        void clear(int num)
	  {
	     items[num].clear();
	  }
	
	void declare_main(MainMenu& con)
	  {
	     main=TRUE;
             con.dp=level;
	  }
	
	void clear_main()
	  {
	     main=FALSE;
	     
	  }
        void edit_item(int num,char* it)
	  {
	     if (num<size)
	       items[num].name_item(it);
	  }
	
	void add_item(char* it)
	  {
	     items[size].name_item(it);
	     size++;
	  }
	void del()
	  {
	     if (size>0)
               {
		  size--;
		  items[size].name_item("NULL");
		  items[size].connect=0;
	       }
	     
	  }
	
        void submenu(char* menu,int num)
	  {
	     items[num].func_exe("NULL");
	     items[num].submenu(menu);
          }
	void func_exe(char* func,int num)
	  {
	     items[num].submenu("NULL");
	     items[num].func_exe(func);
	  }
        char* show(int num)
	  {
	     int a=items[num].connect;
	     if (a)
	       {
		  if(a==1)  return items[num].function_name;
		  if (a==2) return items[num].connect_func;
		  
	       };
	     return "NULL";
	     
	  }
        char* type(int num)
	  {
	     int a=items[num].connect;
	     if (a)
	       {
		  if (a==1) return "Function";
		  if(a==2)  return "Menu";
	       };
	     return "undefined";
	     
	  }
	void help();
        String name(int order)
	  {
	     return String(items[order].name);
	  }
	
	
	void draw()
	  {
	     if (size>0)
	       {
		  show_mouse(NULL);
		  if(main==FALSE)
		    {
		       int x,y,w,h,bg,fg;
		       w=0;
		       y=50;
		       x=50;
		       fg=FG;
		       bg=BG;
		       for(int t=0;t<size;t++)
			 {
			    if (text( items[t].name,0,0,0,0,0)>w)
			      w=text( items[t].name,0,0,0,0,0);
			 }
		       
		       ;
		       h=text_height(font);
		       rectfill(Gui_area, x-1, y-1, x+w, y+h*size+1, bg);
                       rectfill(Gui_area, x-1, y-1, x+w, y+h*size+1, bg);
		       rect(Gui_area, x-1, y-1, x+w, y+h*size+2, fg);

		       for(int t=0;t<size;t++)
			 {
			    text(items[t].name,x,y+t*h,fg,bg,1);
			 }
		       
		       
		    }
		  else
	    {
		       int x,y,w,h,bg,fg;
		       w=0;
		       y=2;
		       x=2;
		       fg=FG;
		       h=text_height(font);
		       
		       bg=BG;
		       
		       for(int t=0;t<size;t++)
			 {
			    w=w+text(items[t].name,0,0,0,0,0);
			    
			 }
		       w=w+12*(size-1);
		       
		       rectfill(Gui_area, x-1, y-1, x+w+1, y+h+1, bg);
		       rect(Gui_area, x-1, y-1, x+w, y+h+2, fg);
		       
		       for(int t=0;t<size;t++)
			 {
			    x=x+text(items[t].name,x,y,fg,bg,1)+12;
			 }
		       
		       
		       
		    }
		  
		  show_mouse(screen);
	       }
	  }
	
	void save()
	  {
	     if (size)
	       {
		  fout<<"\n MENU "<<level<<"[] ={";
		  for ( char t=0;t<size;t++)
		    items[t].save();
		  fout<<"\n { NULL,\t NULL,\t NULL },\n };";
	       }
	  }
        void export()
	  {

	     fout<<"\n"<<size;
             fout<<"\n"<<level;
	     for ( char t=0;t<size;t++)
	       items[t].export();
             }
	
	void import()
	  {
	     
	     fin>>size;
             if (size>max) error(5);

             fin>>level;
	     for ( char t=0;t<size;t++)
	       items[t].import();

	  }
	
	
     };


void setup_bitmap()
     {
	clear_to_color(Gui_area,121);
	for (int tx=GRID/2-1;tx<_W;tx=tx+GRID)
	  {
	     for (int ty=0;ty<_H;ty=ty+GRID)
	       putpixel(Gui_area,tx,ty,255);
          }
	BLIT;
     }


int Setup(void)
     {
	set_up=load_datafile("pall.dat");
        picture=load_datafile("michi.dat");
        bitmaps=load_datafile("BITMAPS.DAT");

	if (!set_up)
	  {
	     allegro_exit();
	     error(2);//Fehler beim Laden von PALL.DAT!;
	     exit(1);
	  }
        if (!picture)
          {
             allegro_exit();
	     error(3);//Fehler beim Laden von MICHI.DAT!
	     exit(1);
	  }

        X_GUI = (__W-_W)/2;
	Y_GUI = (__H-_H)/2;
        set_pallete( (PALETTE) set_up[MichisDialogKiste].dat);

        Gui_area=create_bitmap(_W,_H);
        MICHI=create_bitmap(80,106);
        Schrift=create_bitmap(640,480);
        MICHI=(BITMAP*) picture[MichiBild].dat;
        Schrift=(BITMAP*) picture[schift].dat;



       	temp_area=create_bitmap(_W,_H);
	clear_to_color(temp_area,121);
        clear_to_color(screen,0);
	BLIT;
        set_mouse_speed(1,1);
	show_mouse(screen);
        setup_bitmap();
	return 1;
     }

class pall_obj
/* 
 * This class and its methods are for color handling
 * 
 * run()
 *       does the pallette popup and returns the number of the 
 *       selected color
 */
     {
     private:
       BITMAP* Palette_;
       int X,Y;
     public:
       pall_obj ()
	 {
            Palette_=create_bitmap(20*15,20*17);
            int x=0;
	    int y=0;
	    clear_to_color(Palette_,121);
	    for (int c=0;c<256;c++)
	      {
		 
        		 rectfill(Palette_, x, y,x+20, y+20, c);
		 if ((x=x+20)>300)
		   { x=0;
		      y=y+20;
		   }

		 
	      }
	 }

       ~pall_obj()
           {
	      destroy_bitmap(Palette_);
	   };
       void change_fg_color(dialog& temp)
	 {
	    temp.fg=run();
	 }
       void change_bg_color(dialog& temp)
       	 {
	    temp.bg=run();
	 }
       
       int run()
	 {
	    
            X=X_GUI;
            Y=Y_GUI;
            show_mouse(NULL);
            blit(Palette_,screen,0,0,X,Y,20*15,20*17);
            show_mouse(screen);
            set_mouse_range(X,Y,X+20*15,Y+20*17);
            position_mouse(X,Y);

            if (WAIT) rest(500);
            while (!(mouse_b & 1));
            rebuild_screen();
            int c;
            c=int((mouse_x-X)/20)+int((mouse_y-Y)/20)*16;
            show_mouse(screen);
            set_mouse_range(0,0,__H,__W);
            return c;

	 }
    };


class rect_preparer
/*
 * This class and its methods draw a rect on the screen
 * coordinate_transform(dialog& temp)
 *          transforms the size of temp to that of the drawn rect
 * 
 * */
     {
      private: 
	int w_h,h_h;
      public:
	int x,y,w,h;
	rect_preparer() 
	  {

           };
        void  run()
	  {
             set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
             show_mouse(NULL);
             while (!(mouse_b & 1)){
             x=grid(mouse_x);
             y=grid(mouse_y);
             blit(Gui_area,temp_area,0,0,0,0,_W,_H);
             triangle(temp_area, x-X_GUI,y-Y_GUI,x-X_GUI+8,y-Y_GUI+8,x-X_GUI-8,y-Y_GUI+8,200);
             line(temp_area,x-X_GUI,y-Y_GUI,x-X_GUI+10,y-Y_GUI+10,255);
	     blit(temp_area,screen,0,0,X_GUI,Y_GUI,_W,_H);

             }

	     w_h=3+x;
             h_h=3+y;
             w=grid(mouse_x)-x;
    	     h=grid(mouse_y)-y;

             while (mouse_b & 1)
	       {

		  blit(Gui_area,temp_area,0,0,0,0,_W,_H);
	          triangle(temp_area, x-X_GUI,y-Y_GUI,x-X_GUI+8,y-Y_GUI+8,x-X_GUI-8,y-Y_GUI+8,200);
                 // Neuer "Mauszeiger"
                  line(temp_area,x-X_GUI,y-Y_GUI,x-X_GUI+10,y-Y_GUI+10,255);
	    
  		  rect(temp_area, x-X_GUI, y-Y_GUI,w_h-X_GUI, h_h-Y_GUI, 255);
                  blit(temp_area,screen,0,0,X_GUI,Y_GUI,_W,_H);

		  w_h=grid(mouse_x);
 		  h_h=grid(mouse_y);
	       };
	     
	     x=x-X_GUI;
	     
	     y=y-Y_GUI;
	     
	     w=grid(mouse_x)-X_GUI-x;
	     h=grid(mouse_y)-Y_GUI-y;
	     blit(Gui_area,temp_area,0,0,0,0,_W,_H);
	     rect(temp_area, x, y, x+w, y+h, 255);
	     blit(temp_area,screen,0,0,X_GUI,Y_GUI,_W,_H);
	     show_mouse(screen);
             set_mouse_range(0,0,__W,__H);
	  }
	coordinate_transform (dialog& temp)
	
	  {
	     temp.x=x;
	     temp.y=y;
	     temp.w=w;
	     temp.h=h;
	  }
	
	
	
     };

/* 
 * This method does a coordinate transform within the dialog class.
 * 
 * */

dialog::pos()
     {
	rect_preparer p;
	p.run();
	x=p.x;
	y=p.y;
	w=p.w;
	h=p.h;
     }
/*
 * The next lists are for handling the different Listboxes
 * and should be seen as a perhaps not nice but a functional way to handle
 * dynamic listboxes in C++.
 * If someone can do it better, mail PLEASE
 * 
 * */

char** menustrings;

char* Liste2(int index, int* list_size)
     {
	if (index < 0)
	  { 
	     
             *list_size = max_menobj;
             return NULL;}
	else return menustrings[index];
     }

char** keystrings;

char* Liste1 (int index, int* list_size)
     {
	if (index < 0)
	  { 
	     *list_size =max_keyobj;
	     return NULL;}
	else return keystrings[index];
     }

char** functions;

int func_size=FUNC;

char* Liste3 (int index, int* list_size) {
   if (index < 0)
     {
	*list_size =func_size;
	return NULL;
     }
   else return functions[index];}

char** kids;

int kids_size=LEVELS;
char* Liste4 (int index, int* list_size) {
   if (index < 0)
     { *list_size =kids_size;
	return NULL;}
   else return kids[index];}



class gui_d_key_holder
/*
 * The key_holder is a container for the key_procs
 * methods (export,import...) have the same function as in the dialog class
 * 
 * */
     {
        gui_d_keyboard_proc* items;
        String* strings;
        int size;
        int mxs;
      public:
	
        gui_d_key_holder(int max)
	  {
	     items= new gui_d_keyboard_proc[max]("**EMPTY**","KEY");
	     
	     strings=new String[max]("**EMPTY**");
	     size=0;
	     mxs=max;
	  }
	
        ~gui_d_key_holder()
        {
         delete[] items;
         delete[] strings;
         }
	run()
	  {
	     for (int zu=0;zu<mxs;zu++)
	       strcpy(keystrings[zu],strings[zu]);

	#define DY -300
	     
 	     DIALOG key_dia[]= {
		  { d_shadow_box_proc ,	352 ,	288+DY ,	276 ,	182 ,	96 ,	142 ,	0 ,	0 ,	0 ,	0 ,	NULL},

		  { d_button_proc ,	496 ,	331+DY,	96 ,	12 ,	100 ,	9 ,	10 ,	D_EXIT ,	0 ,	0 ,	 "Add_New" },
		  { d_button_proc ,	496 ,	355+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Del_Last" },
		  { d_button_proc ,	496 ,	380+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Properties" },
		  { d_button_proc ,	496 ,	403+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Help" },
		  { d_button_proc ,	496 ,	428+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Exit"
                    },
		  { d_list_proc ,	364 ,	324+DY ,	108 ,	132 ,	100 ,	9 ,	0 ,	0 ,	0 ,	0 ,	(char*) Liste1},

      		  { d_text_proc ,	364 ,	312+DY ,	120 ,	12 ,	100,	142 ,	0 ,	0 ,	0 ,	0 ,	 "Keyboard shortcuts"},
		  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	     };
	     do{ 
		popup_dialog(key_dia,-1);
		if (key_dia[1].flags==MSG_DCLICK)
		  {
                    // Allegro - C- code done with MichisDialogkiste


		 char name_[STRINGLENGTH];
                 strcpy(name_,strings[size]);

 		DIALOG id_dialog[]= {
		 { d_shadow_box_proc ,	208 ,	348 ,	280 ,	60 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		 { d_text_proc ,	220 ,	360 ,	204 ,	24 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Function-Key-object:" },
		 { d_text_proc ,	220 ,	372 ,	120 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "dp-Field:" },
		 { d_button_proc ,	220 ,	384 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
		 { d_button_proc ,	292 ,	384 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Cancel" },
		 { d_edit_proc ,	302 ,	372 ,	140 ,	12 ,	5 ,	28 ,	0 ,	0 ,	8 ,	1 ,	name_},
		 { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
		 };

                 popup_dialog(id_dialog,-1);
                    if (id_dialog[4].flags==MSG_DCLICK)
                      {

	                strings[size]=name_;
                     	strcpy(keystrings[size],strings[size]);
       		     	items[size].dp=strings[size];
                        size++;
                       }

		  }
		
		if (key_dia[2].flags==MSG_DCLICK)
		  {
		  
                if (size>0)
		       {
			  strings[size-1]="**EMPTY**";
			  keystrings[size-1]="**EMPTY**";
			  
			  items[size].dp=strings[size];
			  size--;
		       }
		  }
		if (key_dia[3].flags==MSG_DCLICK)
		  {
		     if (key_dia[6].d1<size)
		       {
			  items[key_dia[6].d1].show_prop(0,0);
			  strings[key_dia[6].d1]=items[key_dia[6].d1].dp;
			  strcpy(keystrings[key_dia[6].d1],strings[key_dia[6].d1]);
		       }
		  }

       		if (key_dia[4].flags==MSG_DCLICK)
                  {
                   items[0].help();
                   }
	     }while (key_dia[5].flags!=MSG_DCLICK);
	     
	  }
	export()
	  {
	     fout<<"\n "<<size;
	     for (int t=0;t<size;t++)
            items[t].export();
	  }
	import()
	  {
	     fin>>size;
             if (size>mxs) error(6);
             for (int t=0;t<size;t++)
	       {
		  items[t].import();
		  strings[t]=items[t].dp;
	       }
	     
	  }
	save()
	  {
	     for (int t=0;t<size;t++)
	       items[t].save();
	  }
     };




template <class T> class container
/* 
 * This is the template for holding all DIALOG objects, which do not
 * contain text's, eg. boxes,shadowboxes....
 * methods (export,import...) have the same function as in the dialog class
 * 
 * item()
 *     add's a new object in the list of objects (member T* list)
 *     each item can have a name (not used til now)
 * copy(), delet(), select(), import() ... should be clear
 * 
 * Each object has a type list[index], a status ak[index] and a name
 * names[index]
 * The member int* ak is very important, cause it shows the status of an
 * object. If 0 the object is disaktivated and the next creation of an
 * object will overwrite this object. If 2 it shows object has selected status
 * and 1 is normal status.
 * The maximum size of the container is hold in max, and it's given with 
 * the constructor. That's the reason why you have to restart the program
 * if you want to have bigger containers. [This was just an esy way to
 * get rid of malloc (uups)].
 * 
 */ 

     {
      public:
	T* list;
	int* ak;
	int counter;
	int max;
        int* order;
        String* names;
	rect_preparer p;
	int x_copy,y_copy;
	container(int num,char* dummy)
	  {
	     list= new T[num](dummy);
             ak=new int[num];
             order=new int[num];
             names=new String[num]("**EMPTY**");
	     max=num;
             for (int t=0;t<max;t++) ak[t]=0;
	     counter=0;
             x_copy=0;
             y_copy=0;
	     
	     
          }
        ~container()
        {
         delete[] list;
         delete[] ak;
         delete[] names;
         }
        delete_items()
          {
             for (int t=0;t<counter;t++)
	       {
		  if (ak[t]==2) ak[t]=0;

	       }
	     
	  }
	void item (int nummer)   //creates a new item or fills in a space
	  {
	     if (counter<max)
	       {
		  int temp=counter;
		  for (int t=0;t<counter;t++)
		    // ckecking if there is a space in the boxes array
		  if (ak[t]==0)
		    {
		       counter=t;
		       break;
		    }

		  p.run();
		  p.coordinate_transform(list[counter]);
		  list[counter].activate_func();
                  ak[counter]=1;
                  order[counter]=nummer;
		  if (counter==temp) {
                    counter++;

                    }
                   else counter=temp;
                   rebuild_screen();
                   }
	     else error(7);
	  }
        void change_color(int a,int& fgc,int& bgc)
	  {
	     if (a<counter)
	       {
       		  list[a].fg=fgc;
                  list[a].bg=bgc;
	       }
	  }
	
	
        void change_color(int a)
	  {
	     if (a<counter)
	       {
		  
		  pall_obj te;
		  status("Select forground color");
		  te.change_fg_color(list[a]);
		  status("Select background color");
		  te.change_bg_color(list[a]);
		  list[a].activate_func();
                  status("			                    ");
	       }
	  }
	void save() //speichert im Allegro C- Code Format
	  {
	     for (int t=0;t<counter;t++)
	       if (ak[t])
	       {
		  list[t].save();
		  
	       }
	     
	  }
        void export() // speichert im eigenen Format alle Variablen

        {
             int numm=0;
             for (int t=0;t<counter;t++)
               { if (ak[t]) numm++;}

	     fout<<"\n"<<numm;

	     for (int t=0;t<counter;t++)
	       
	       {
		  if (ak[t]) list[t].export();
               }
	  }
	
        int import()
	  {
	     int nummer;
	     fin>>counter;
	     if (counter>max)
               {
		  error(7);
	       }
	     else
	       {
		  for (int t=0;t<counter;t++)
		    {
		       list[t].import();
		       ak[t]=1;
                       nummer=t;
		    }
		  
		  
	       }
             return nummer;
	  }

        void area(int xt,int yt,int wt,int ht)
        {
         for (int t=0;t<counter;t++)
            {
             if (ak[t])
               {
                if (list[t].inside(xt,yt,wt,ht))
                  {
                   ak[t]=2;
        	     x_copy=0;
	             y_copy=0;
                   }
                }
             }

         }

        void select(int a)
	  {
	     if ((a<counter)& (ak[a]!=0)) ak[a]=2;
	  }

        void select_desk(int mx, int my)
        {
          if (counter>0) {
	  for(int t=0;t<counter;t++)
		  {
		     
		     if (list[t].THIS(mx,my))
		       {
			  if (ak[t]==2) ak[t]=1;
                          else if (ak[t]==1)
                            {
                             ak[t]=2;
                             x_copy=0;
	            	     y_copy=0;
	                   }
                       }
		     
		  }
		draw();
	     }
	  }
    
		


        int select(char* sel)
	
	
	  {
	     int xs,ys;
	     if (counter>0) {
		status(sel);
		
		set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
		position_mouse(X_GUI,Y_GUI);
		
		
		if (WAIT) rest(500);

		while (!(mouse_b & 1));
		int mx=mouse_x;
		int my=mouse_y;
		
		for(int t=0;t<counter;t++)
		  {
		     
		     if (list[t].THIS(mx,my))
		       {
			  if (!ask("Select Item?"))
			    {
			       ak[t]=2;
                                x_copy=0;
			        y_copy=0;
                  	    }
                       	}
		     
		  }
               set_mouse_range(0,0,__W,__H);
		draw();
	     }
	  }
        void unselect()
	  {
	     for(int t=0;t<counter;t++)
	       {
		  if (ak[t]==2) ak[t]=1;
		  
	       }
	     draw();
	  }
	
        void show_props()
	  {
	     
	     for (int t=0;t<counter;t++)
	       {
		  if (ak[t]==2)
		    {
                       int tfg;
		       int tbg;
		       tfg=list[t].fg;
		       tbg=list[t].bg;
		       
                       list[t].fg=0;
		       list[t].bg=222;
		       list[t].activate_func();
		       BLIT;
                       int re=list[t].show_prop(tfg,tbg);

                       if (!re)
                         {

                          change_color(t);
	       

                          tfg=list[t].fg;
		          tbg=list[t].bg;

                          }
                       if (re==-1) list[t].help();
                       if (re==2) list[t].input();
                       list[t].fg=0;
                       list[t].bg=255;
		       list[t].activate_func();
                       BLIT;
                       list[t].bg=tbg;
       		       list[t].fg=tfg;
		       
		 }
              }
             }

        void draw(int options=0)
          {
	     for (int t=0;t<counter;t++)
	       {
		  if (ak[t]==1) list[t].activate_func();
                  if (!options)
                    {
                   if (ak[t]==2) list[t].activate_func(Gui_area,0,255);

                    }
		  
	    }
          }
        void draw_order(int nummer,int options=0)
         {

            if (nummer==order[nummer])
              {
               if (ak[nummer]==1) list[nummer].activate_func();
               if (!options)
                   {
                   if (ak[nummer]==2) list[nummer].activate_func(Gui_area,0,255);
                   }
              }

	     
	  }
        int mover(int& dx,int& dy)
	        {

                  for (int t=0; t<max;t++)
        	     {
	              if (!isvalid(t))
                        {
       			 list[t].x=list[t].x+dx;
                         list[t].y=list[t].y+dy;
                         list[t].activate_func(temp_area,0,255);
	              }
                  }

           	}

        int isvalid(int temp)
	  {
	     if (temp>=counter) return -1;
	     if (ak[temp]==1) return 1;
	     if (ak[temp]==2) return 0;
	     
	     else return -2;
	  }
	
	int copy()
	  {  int nummer=0;
             int last=counter;
	     if (counter<max)
               {
	     for (int t=0;t<counter;t++)
	       {
		  if (ak[t]==2)
		    {
                       ak[t]=1;
                       list[counter].copy(list[t],x_copy,y_copy);
                       ak[counter]=1;
       		       counter++;
                       nummer++;

		    }
	       }
             for (int t=0;t<last;t++) ak[t]=2;

              }
             return nummer;
	  }


	run()
	  {
	     for (int zu=0;zu<max;zu++)
	       strcpy(keystrings[zu],names[zu]);

             #define DY -300

             char header[STRINGLENGTH];
             strcpy(header,list[0].name);
	     status(header);
             strcat(header,"s");

             #define NEW 1
             #define DEL 2
             #define PROP 3
             #define HELPT 4
             #define SPECIAL 5
             #define EXIT 6

	     DIALOG key_dia[]= {
		  { d_shadow_box_proc ,	352 ,	288+DY ,	276 ,	200 ,	96 ,	142 ,	0 ,	0 ,	0 ,	0 ,	NULL},

		  { d_button_proc ,	496 ,	330+DY,	96 ,	12 ,	100 ,	9 ,	10 ,	D_EXIT ,	0 ,	0 ,	 "Add_New" },
		  { d_button_proc ,	496 ,	354+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Del_Last" },
		  { d_button_proc ,	496 ,	378+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Properties" },
		  { d_button_proc ,	496 ,	402+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Help" },
		  { d_button_proc ,	496 ,	426+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Special" },

		  { d_button_proc ,	496 ,	450+DY ,	96 ,	12 ,	100 ,	9 ,	0 ,	D_EXIT  ,	0 ,	0 ,	 "Exit"
                   },
		  { d_list_proc ,	364 ,	324+DY ,	108 ,	132 ,	100 ,	9 ,	0 ,	0 ,	0 ,	0 ,	(char*) Liste1},

      		  { d_text_proc ,	364 ,	312+DY ,	120 ,	12 ,	100,	142 ,	0 ,	0 ,	0 ,	0 ,header},
		  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	     };
	     do{ 
		popup_dialog(key_dia,-1);
		if (key_dia[NEW].flags==MSG_DCLICK)
		  {
                   readkey();
		  }
		
		if (key_dia[DEL].flags==MSG_DCLICK)
		  {
		  
                  }
		if (key_dia[PROP].flags==MSG_DCLICK)
		  {
		  }

       		if (key_dia[HELPT].flags==MSG_DCLICK)
                  {


                   }
                if (key_dia[SPECIAL].flags==MSG_DCLICK)
		  {
		  }

	     }while (key_dia[EXIT].flags!=MSG_DCLICK);
	     
	  }

     };

template <class T> class textcontainer:public container<T>
/*
 * The reason for this derivate was that item() had to be slightly 
 * changed for textboxes and its derivates
 * 
 * */

     
{
      public:
        textcontainer(int num, char* text):container<T>(num,text)
	  {
          }

        void item (int nummer)   //creates a new item or fills in a space
	  {
	     if (counter<max)
	       {
		  char tem[STRINGLENGTH];


		  int temp=counter;
		  
		  for (int t=0;t<counter;t++)
		    // ckecking if there is a space in the boxes array
		  if (ak[t]==0)
		    {
		       counter=t;
		 // wenn platz in Liste, waechst sie nicht an
		       break;
		    }
                  strcpy(tem,list[counter].input());
                  rebuild_screen();
//		  list[counter].rename(tem);
//		  status("Draw the Size");
		  p.run();
		  p.coordinate_transform(list[counter]);
		  list[counter].activate_func();
		  ak[counter]=1;
                  order[counter]=nummer;
		  if (counter==temp)
                    {
                     counter++;
                     }
                    else counter=temp;
                  rebuild_screen();
	       }
	     else error(7);
	  }

	

	
     };




template <class T> class listcontainer:public textcontainer<T>
/* 
 * Listboxes need their "own" container - you see why...
 * 
 * */
     {
      public:
	listcontainer(int num, char* tex):textcontainer<T>(num,tex)
	  { };
	
	void save_lists()
	  {
	     for (int t=0;t<counter;t++)
	       if (ak[t])
	       {
		  list[t].save_items();
		  
	       }
	  }
        void item(int nummer)
        {
         char temps[STRINGLENGTH]="Liste";
	 char st[5];
	 itoa(counter,st,10);
	 strcat(temps,st);


         if (counter<max)
	       {
		  int temp=counter;
		  
		  for (int t=0;t<counter;t++)
        	  if (ak[t]==0)
		    {
		       counter=t;
        	       break;
		    }
                  list[counter].rename(temps);
                  list[counter].input();
                  p.run();
		  p.coordinate_transform(list[counter]);
		  list[counter].activate_func();
		  ak[counter]=1;
                  order[counter]=nummer;
                  rebuild_screen();
		  if (counter==temp)
                    {
                     counter++;
                     }
                    else counter=temp;
	       }
	     else error(7);
          }


};

class menucontainer
/* 
 * This class holds the Menus and their handling
 * The number of *Menus is LEVEL (global), the depth of each Menu is 
 * sub_menobj (constructor num) the number of Functions is FUNCS
 * run() aktivates the do_levels() which is handles the Menus
 * 
 * do_dependencies()
 *         handels the connections inbetween the menus and functions
 * Again there is import(), export(), save()
 *
 * */
     {
	MainMenu mm;
	Menu* menues;
	String name;
	String* select;
	int max;
	int level;
	int size;
        String* functs;
        String* functs_type;
        int func_counter;
	
	
      public:
	menucontainer(int num,char* tex):mm("MainLevel")
	  {
	     name=tex;
	     level=0;
	     size=0;
	     max=num;
	     
	     select=new String[num]("**EMPTY**");
	     menues=new Menu[LEVELS](num);
             functs=new String[FUNC]("**EMPTY**");
             functs_type=new String[FUNC]("none");
             func_counter=0;
	     
	     
	     for (int t=0;t<LEVELS;t++) menues[t].level_(t);
	     menues[0].declare_main(mm);
	     
	     
	  }
      	~menucontainer()
        {
         delete[] select;
         delete[] menues;
         delete[] functs;
         delete[] functs_type;
         }
	int run()
	  {
	     int next=0;
	     
	     do
	       {
		  next=do_levels(next);
	       }
	     while ((next>-1)& (next<LEVELS));
	     
	  }
	
	int draw()
        {
//          if (size)
            menues[0].draw();
          }
	
	int do_levels(int num)
	
	  {
	     int next;
	     /* Allegro - C- code done with MichisDialogkiste */
	     
	     level=num;
	     char Menu_name[STRINGLENGTH];
	     strcpy(Menu_name,menues[level].level);
	     
	     
             #define NEW2 7
             #define DEL2 8
             #define EDIT2 9
             #define EXIT2 12
             #define LISTE 13
             #define NEXT 10
             #define PROCEED 11
             #define DRAW2 14
	     #define HELP2 15
	    DIALOG menu_dialog[]= {
		 { d_shadow_box_proc ,	208 ,	96 ,	420 ,	252 ,	28 ,	16 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		 { d_shadow_box_proc ,	232 ,	132 ,	372 ,	180 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		 { d_shadow_box_proc ,	400 ,	156 ,	168 ,	108 ,	118 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		 { d_text_proc ,	388 ,	108 ,	120 ,	12 ,	9 ,	16 ,	0 ,	0 ,	0 ,	0 ,	 "MenuTree" },
		 { d_text_proc ,	244 ,	144 ,	108 ,	24 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Menu-Name:" },
                 { d_text_proc ,	412 ,	168 ,	132 ,	12 ,	97 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "ChangingthisMenu" },
		 { d_text_proc ,	256 ,	288 ,	108 ,	24 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Double-ClickonMenu-itemfordependecies" },
		 { d_button_proc ,	424 ,	192 ,	108 ,	12 ,	118 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "AddNew" },
		 { d_button_proc ,	424 ,	216 ,	108 ,	12 ,	118 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Delete" },
		 { d_button_proc ,	424 ,	240 ,	108 ,	12 ,	118 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Edit" },
		 { d_button_proc ,	256 ,	324 ,	84 ,	12 ,	144 ,	68 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "NextLevel" },
		 { d_button_proc ,	352 ,	324 ,	132 ,	12 ,	144 ,	68 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "ProceedingLevel" },
		 { d_button_proc ,	496 ,	324 ,	72 ,	12 ,	144 ,	68 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Done" },
		 { d_list_proc ,	244 ,	156 ,	144 ,	72 ,	188 ,	10 ,	0 ,	D_EXIT ,	0 ,	0 ,(char*) Liste2},
                 { d_button_proc ,	244 ,	252 ,	60 ,	12 ,	188 ,	10 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Draw" },
                 { d_button_proc ,	320 ,	252 ,	60 ,	12 ,	188 ,	10 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
                 { d_edit_proc ,	340 ,	144 ,	228 ,	12 ,	246 ,	96 ,	0 ,	0 ,	180 ,	1 ,	Menu_name},
		 { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	    };
	     do
	      {
       		 size=menues[level].size;
       		 for (int zu=0;zu<max;zu++) select[zu]="**EMPTY**";
		 for (int zu=0;zu<menues[level].size;zu++) select[zu]=menues[level].name(zu);
		 
		 for (int zu=0;zu<max;zu++) strcpy(menustrings[zu],select[zu]);
		 
		 popup_dialog(menu_dialog,-1);
		 
                 strcpy(menues[level].level,Menu_name);
                 if (!level) menues[0].declare_main(mm);
		 
		 if (menu_dialog[NEW2].flags==MSG_DCLICK)
		   {
		      
		      
		      /* Allegro - C- code done with MichisDialogkiste */
		      
		      
		      char name[STRINGLENGTH]="&" ;
		      
		      DIALOG obj_dialog[]= {
			   { d_shadow_box_proc ,	136 ,	180 ,	216 ,	60 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
			   { d_text_proc ,	148 ,	192 ,	156 ,	24 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Menu-object:" },
			   { d_text_proc ,	148 ,	204 ,	48 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "name:" },
			   { d_button_proc ,	148 ,	216 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
			   { d_button_proc ,	292 ,	216 ,	48 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
			   { d_button_proc ,	220 ,	216 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Cancel" },
			   { d_edit_proc ,	196 ,	204 ,	150 ,	12 ,	12 ,	28 ,	0 ,	0 ,	28 ,	1 ,	name},
			   { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
		      };
		      popup_dialog(obj_dialog,-1);
		      
		      if (obj_dialog[5].flags!=MSG_DCLICK)
			{
			   select[size]=name;
			   menues[level].add_item(name);
			   size++;
			}
		   }
                 if (menu_dialog[HELP2].flags==MSG_DCLICK)
                   menues[0].help();
		 if (menu_dialog[EDIT2].flags==MSG_DCLICK)
		   {
		      int dies=menu_dialog[LISTE].d1;
		      
		      if (dies<size)
			{
			   
			   char name[STRINGLENGTH];
			   strcpy(name,select[dies]);
			   
			   
			   DIALOG obj_dialog[]= {
				{ d_shadow_box_proc ,	136 ,	180 ,	216 ,	60 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
				{ d_text_proc ,	148 ,	192 ,	156 ,	24 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Menu-object:" },
				{ d_text_proc ,	148 ,	204 ,	48 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "name:" },
				{ d_button_proc ,	148 ,	216 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
				{ d_button_proc ,	292 ,	216 ,	48 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
				{ d_button_proc ,	220 ,	216 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Cancel" },
				{ d_edit_proc ,	196 ,	204 ,	150 ,	12 ,	5 ,	28 ,	0 ,	0 ,	28 ,	1 ,	name},
				{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
			   };
			   popup_dialog(obj_dialog,-1);
			   
			   if (obj_dialog[5].flags!=MSG_DCLICK)
			     {
				select[dies]=name;
				menues[level].edit_item(dies,name);
			     }

			}
		   }
		 
		 if (menu_dialog[DEL2].flags==MSG_DCLICK)
		   {
                    if (size)
			{
			   size--;
			   menues[level].del();
			   select[size]="**EMPTY**";
                      }
		   }
		 
		 if (menu_dialog[DRAW2].flags==MSG_DCLICK)
		   menues[level].draw();
		 
		 size=menues[0].size;
		 
		 if (menu_dialog[NEXT].flags==MSG_DCLICK)
		   {
		      next=level+1;
		      if (next==LEVELS) next=LEVELS-1;
		      return next;
		   }
		 if (menu_dialog[PROCEED].flags==MSG_DCLICK)
		   {
		      next=level-1;
		      if (next<0) next=0;
		      return next;
		      
		   }
     		 if (menu_dialog[LISTE].flags==MSG_DCLICK)
		   do_dependencies(menu_dialog[LISTE].d1);
		 
		 
	      }while (menu_dialog[EXIT2].flags!=MSG_DCLICK);
	     return -1;
	     
	 }
	do_dependencies(int num)
	  {
             String* temp=new String[LEVELS];
             int c=0;
             int dia_done;
	     for (int t=1;t<LEVELS;t++)
	       {
                  if (menues[t].size)
                    {
		       temp[c]=menues[t].level;
		       c++;
		    }
                  }
	     
             do{
		
		for (int t=0;t<FUNC;t++)
                  strcpy(functions[t],functs[t]);
		for (int t=0;t<c;t++)
		  
                 {
		    strcpy(kids[t],temp[t]);
		 }
		
                kids_size=c;
		char id[STRINGLENGTH];
                strcpy(id,menues[level].name(num));
		
		/* Allegro - C- code done with MichisDialogkiste */
	#define CLEAR2 11
	#define CANCEL 13
	#define NEW_FUNC 14
	#define LIST_func 15
	#define LIST_menu 16
	#define HELP3 12
		DIALOG dep_dialog[]= {
		     { d_shadow_box_proc ,	88 ,	120 ,	384 ,	276 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		     { d_text_proc ,	100 ,	132 ,	264 ,	12 ,	144 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Dependencies" },
		     { d_text_proc ,	112 ,	168 ,	108 ,	12 ,	144 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Functions" },
		     { d_text_proc ,	292 ,	168 ,	132 ,	12 ,	144 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Submenues" },
		     { d_text_proc ,	112 ,	156 ,	240 ,	12 ,	144 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Double-ClickonaListitemtoconnectit" },
		     { d_text_proc ,	112 ,	324 ,	180 ,	12 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Curent-Menuobject:" },
		     { d_text_proc ,	256 ,	324 ,	216 ,	12 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 id },
		     { d_text_proc ,	112 ,	336 ,	168 ,	12 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "CurrentConnection:" },
		     { d_text_proc ,	268 ,	336 ,	192 ,	12 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	  menues[level].show(num)},
		     { d_text_proc ,	112 ,	348 ,	72 ,	12 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Type:" },
		     { d_text_proc ,	160 ,	348 ,	180 ,	12 ,	128 ,	96 ,	0 ,	0 ,	0 ,	0 ,	  menues[level].type(num)},
		     { d_button_proc ,	256 ,	372 ,	192 ,	12 ,	220 ,	96 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Clear_all_dependencies" },
		     { d_button_proc ,	112 ,	372 ,	60 ,	12 ,	220 ,	96 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
		     { d_button_proc ,	184 ,	372 ,	60 ,	12 ,	220 ,	96 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Done" },
		     { d_button_proc ,	112 ,	300 ,	120 ,	12 ,	227 ,	100 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Edit_Function" },
		     { d_list_proc ,	112 ,	180 ,	144 ,	108 ,	227 ,	100 ,	0 ,	D_EXIT,	func_counter ,	0 ,	Liste3},
		     { d_list_proc ,	292 ,	180 ,	156 ,	108 ,	227 ,	100 ,	0 ,	D_EXIT ,	0 ,	0 ,	Liste4},
		     { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
		};
		
		
		
		popup_dialog (dep_dialog,-1);
		
		if (dep_dialog[LIST_func].flags==MSG_DCLICK)
		  {
		     menues[level].func_exe(functions[dep_dialog[LIST_func].d1],num);
		  }
		if (dep_dialog[CLEAR2].flags==MSG_DCLICK)
		  {
		     menues[level].clear(dep_dialog[LIST_func].d1);
		  }

                if (dep_dialog[HELP3].flags==MSG_DCLICK)
                  help_dep();
		if (dep_dialog[NEW_FUNC].flags==MSG_DCLICK)
		  {
		     
		     
		     /* Allegro - C- code done with MichisDialogkiste */
		     
		     dep_dialog[LIST_func].d1;

		     char type[STRINGLENGTH];
                     strcpy(type,functs_type[dep_dialog[LIST_func].d1]);
		     
		     char name[STRINGLENGTH];
                     strcpy(name,functs[dep_dialog[LIST_func].d1]);


		     DIALOG func_dialog[]= {
			  { d_shadow_box_proc ,	128 ,	180 ,	264 ,	72 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	NULL},
			  { d_text_proc ,	148 ,	192 ,	156 ,	24 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "Functions:" },
			  { d_text_proc ,	148 ,	204 ,	48 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "type" },
			  { d_text_proc ,	148 ,	216 ,	48 ,	12 ,	5 ,	28 ,	0 ,	0 ,	0 ,	0 ,	 "name:" },
			  { d_button_proc ,	152 ,	227 ,	48 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
			  { d_button_proc ,	284 ,	227 ,	48 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
			  { d_button_proc ,	212 ,	227 ,	60 ,	12 ,	5 ,	28 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Delete" },
			  { d_edit_proc ,	196 ,	204 ,	160 ,	12 ,	12 ,	28 ,	0 ,	0 ,	28 ,	1 ,	type},
			  { d_edit_proc ,	196 ,	216 ,	160 ,	12 ,	12 ,	28 ,	0 ,	0 ,	28 ,	1 ,	name},
			  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
		     };
		     
		     popup_dialog(func_dialog,-1);
                     if (func_dialog[6].flags==MSG_DCLICK)
                       {
		     	functs_type[func_counter]="none";
		        functs[func_counter]="**EMPTY**";
		        if (func_counter>0) func_counter--;
                        }
                     else {
                        functs_type[func_counter]=type;
		        functs[func_counter]=name;
                        func_counter++;
                        }
		  }
		
		if (dep_dialog[LIST_menu].flags==MSG_DCLICK)
		  {
		     menues[level].submenu(kids[dep_dialog[LIST_menu].d1],num);
		  }
		dia_done=dep_dialog[CANCEL].flags;
		
	     }while(dia_done!=MSG_DCLICK);
	     
	     
	     
	  }
	
	
	export()
	  {
       	     fout<<"\n"<<func_counter;
             fout<<"\n"<<max;
              for (int t=0;t<max;t++)
	       menues[t].export();

	     for (int t=0;t<func_counter;t++)
	       {
		  fout<<"\n"<<functs[t];
		  fout<<"\n"<<functs_type[t];
	       }
	     
	  }
        import()
	  {
             func_counter=0;//reload
             fin>>func_counter;
             fin>>max;
             if (max>LEVELS) error(4); //too little size

	     for (int t=0;t<max;t++)
	       menues[t].import();

	     if (func_counter>FUNC) error(1);
	     for (int t=0;t<func_counter;t++)
	       {
		  fin>>functs[t];
		  fin>>functs_type[t];
	       }
	     menues[0].declare_main(mm);
	     
	     
	  }
	
        save()
	  {
	     if (size) mm.save();
	  }
	
	void help_dep();
        save_menues()
	  {
	     
             for (int t=0;t<func_counter;t++)
	       fout<<"\n"<<functs_type[t]<<" "<<functs[t]<<"() {};";
	     
	     for (int t=LEVELS;t>0;t--)
	       menues[t-1].save();
	  }
	
	
	
     };
/*
 * 
 * For moving object and drawing a moving vektor
 * 
 * */

int move(int& x, int& y)
     {
	status("Draw moving vektor. holding mouse button ");
 	set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
	if (WAIT) rest(500);
	
	while (!(mouse_b & 1));
	
		 int mx=grid(mouse_x)-X_GUI;
		 int my=grid(mouse_y)-Y_GUI;
		 int mxs,mys;
		 status("Draw the vector,release mouse button when ready");
		 show_mouse(NULL);
		 
		 while(mouse_b &1)
		   {
		      mxs=grid(mouse_x)-X_GUI;
		      mys=grid(mouse_y)-Y_GUI;
		      
		      blit(Gui_area,temp_area,0,0,0,0,_W,_H);
		      line(temp_area,mx,my,mxs,mys,45);
		      blit(temp_area,screen,0,0,X_GUI,Y_GUI,_W,_H);
		      
		   }
		 x=mxs-mx;
		 y=mys-my;
		 show_mouse(screen);
                 set_mouse_range(0,0,__W,__H);
                 status("			                    ");
       		 return 1;

	 }
char* Liste0 (int index, int* list_size) {
		char* strings[]={"640x480" , "800x600" , "1024x768" };
		if (index < 0) 
		  { *list_size =3;
		     return NULL;}
		else return strings[index];}


class option_holder
/*
 * holds all options and the necessary menus
 * 
 * */
 
     {
      private:
	int r_W;
	int r_H;
	// int buttopti=1 if 1 the buttons are drawn with optimal position 
	// int Allegroversion22=1; if 1 the listbox objects are wider,
        //                         so, that v2.2 does not cut the endings with the selector
      public:
	options(){
	};


      run()
	  {
             int listsel=0;
             if (Allegroversion22) listsel=D_SELECTED;
             int butt=0;
             if (buttopti) butt=D_SELECTED;
	     char Fgc[4];
             itoa(FG,Fgc,10);
	     char Bgc[3];
             itoa(BG,Bgc,10);
	     char Gridg[3]="12" ;
             itoa(GRID,Gridg,10);
             DIALOG op_dia[]= {
		  { d_shadow_box_proc ,	172 ,	96 ,	348 ,	288 ,	91 ,	96 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		  { d_text_proc ,	256 ,	108 ,	180 ,	12 ,	240 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "GENERELOPTIONS" },
		  { d_text_proc ,	184 ,	120 ,	96 ,	12 ,	221 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Defaults:" },
		  { d_text_proc ,	184 ,	132 ,	156 ,	12 ,	91 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Foreground_Color:" },
		  { d_text_proc ,	184 ,	144 ,	156 ,	12 ,	91 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Backgorund_color:" },
		  { d_text_proc ,	184 ,	168 ,	240 ,	12 ,	221 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Gui_drawing_Resolution:" },
		  { d_text_proc ,	184 ,	216 ,	240 ,	12 ,	221 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Screen_Resolution:" },
		  { d_text_proc ,	184 ,	228 ,	72 ,	12 ,	91 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "800x600" },
		  { d_text_proc ,	256 ,	228 ,	156 ,	12 ,	91 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Auto-configured" },
		  { d_text_proc ,	184 ,	252 ,	60 ,	12 ,	220 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "Grid:" },
		  { d_text_proc ,	184 ,	324 ,	264 ,	12 ,	141 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "ChangeshaveeffektAFTERrestart!" },
		  { d_text_proc ,	184 ,	336 ,	252 ,	12 ,	141 ,	96 ,	0 ,	0 ,	0 ,	0 ,	 "GirdischangedafterREDREAW" },
		  { d_button_proc ,	400 ,	356 ,	96 ,	12 ,	141 ,	252 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "OK" },
		  { d_check_proc ,	184 ,	276 ,	348 ,	12 ,	221 ,	96 ,	0 ,	butt ,	0 ,	0 ,	 "FitPositionofButtonstoTextobjects" },
		  { d_check_proc ,	184 ,	300 ,	324 ,	12 ,	221 ,	96 ,	0 ,	listsel ,	0 ,	0 ,"ListboxesinAllegro2.2width" },
		  { d_edit_proc ,	328 ,	132 ,	48 ,	12 ,	128 ,	96 ,	0 ,	0 ,	4 ,	1 ,	Fgc},
		  { d_edit_proc ,	328 ,	144 ,	36 ,	12 ,	128 ,	96 ,	0 ,	0 ,	3 ,	1 ,	Bgc},
		  { d_edit_proc ,	232 ,	252 ,	36 ,	12 ,	128 ,	96 ,	0 ,	0 ,	3 ,	1 ,	Gridg},
		  { d_list_proc ,	184 ,	180 ,	120 ,	30 ,	91 ,	96 ,	0 ,	0 ,	0 ,	3 ,(char*) Liste0},
                  { d_button_proc ,	220 ,	356 ,	168 ,	12 ,	141 ,	252 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "More_Options" },
		  { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	     };
	     
	     popup_dialog(op_dia,-1);

	     if (op_dia[13].flags==D_SELECTED) buttopti=1;else buttopti=0;
	     if (op_dia[14].flags==D_SELECTED) Allegroversion22=1;else Allegroversion22=0;          FG=atoi(Fgc);
	     BG=atoi(Bgc);
	     GRID=atoi(Gridg);
             if (op_dia[18].d1==0)
               {
                r_W=640;
                r_H=480;
                __W=800;
                __H=600;
                }
             if (op_dia[18].d1==1)
               {
                r_W=800;
                __W=1024;
                r_H=600;
                __H=768;
                }


             if (op_dia[18].d1==2)
               {
                r_W=1024;
                __W=1024;
                r_H=768;
                __H=768;
                }


	     if (op_dia[19].flags==MSG_DCLICK)
	       {
                 run_size();

	       }
	     
	     makeconfig();
	     
	  }
        run_size()
	  {  
	     char clearobj[3];
	     itoa(max_clearobj,clearobj,10);
	     
	     char keyobj[3];
	     itoa(max_keyobj,keyobj,10);
	     
	     char boxobj[3];
	     itoa(max_boxobj,boxobj,10);
	     
	     char sboxobj[3];
	     itoa(max_sboxobj,sboxobj,10);
	     
	     char buttonobj[3];
	     itoa(max_buttonobj,buttonobj,10);
		  
	     char textobj[3];
	     itoa(max_textobj,textobj,10);
	     
	     char ctextobj[3];
	     itoa(max_ctextobj,ctextobj,10);
	     
	     char checkobj[3];
	     itoa(max_checkobj,checkobj,10);
	     
	     char listobj[3];
	     itoa(max_listobj,listobj,10);
	     
	     char editobj[3];
	     itoa(max_editobj,editobj,10);

            char bitmapobj[3];
	     itoa(max_bitmapobj,bitmapobj,10);
	
	     char submenobj[3];
	     itoa(max_menobj,submenobj,10);

             char maxfuncs[3];
	     itoa(FUNC,maxfuncs,10);

             char maxmenus[3];
             itoa(LEVELS,maxmenus,10);

             char radioobj[3];
             itoa(max_radioobj,radioobj,10);

            char maxlayers[3]="xx" ;
            char clipboard[3]="xx" ;

 	    char optional[3]="xx" ;

	     DIALOG more_dia[]= { 
               { d_shadow_box_proc ,	208 ,	24 ,	360 ,	456 ,	76 ,	141 ,	0 ,	0 ,	0 ,	0 ,	NULL},
                { d_shadow_box_proc ,	232 ,	60 ,	312 ,	192 ,	187 ,	219 ,	0 ,	0 ,	0 ,	0 ,	NULL},
                { d_shadow_box_proc ,	232 ,	276 ,	312 ,	72 ,	187 ,	219 ,	0 ,	0 ,	0 ,	0 ,	NULL},
		{ d_shadow_box_proc ,	232 ,	372 ,	312 ,	72 ,	187 ,	219 ,	0 ,	0 ,	0 ,	0 ,	NULL},
 		{ d_text_proc ,	240 ,	36 ,	196 ,	16 ,	98 ,	141 ,	0 ,	0 ,	0 ,	0 ,	 "Objects-size (Number of Objects)" },
 		{ d_text_proc ,	244 ,	96 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "Max_clear_objects:" },
	 	{ d_text_proc ,	244 ,	108 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "key_objects:" },
	 	{ d_text_proc ,	244 ,	120 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "box_objects:" },
	 	{ d_text_proc ,	244 ,	132 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "shadowbox_objects:" },
		{ d_text_proc ,	244 ,	144 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "text_objects:" },
 		{ d_text_proc ,	244 ,	156 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "cent-text_objects:" },
	 	{ d_text_proc ,	244 ,	168 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "button_objects:" },
 		{ d_text_proc ,	244 ,	180 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "radio_button_objects:" },
 		{ d_text_proc ,	244 ,	192 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "check_objects:" },
 		{ d_text_proc ,	244 ,	204 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "list_objects:" },
 		{ d_text_proc ,	244 ,	72 ,	276 ,	12 ,	249 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "Maximum_Size:DIALOG-Objects" },
 		{ d_text_proc ,	244 ,	216 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "edit_objects:" },
       		{ d_text_proc ,	244 ,	228 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "bitmap_objects:" },
 		{ d_text_proc ,	244 ,	288 ,	276 ,	12 ,	249 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "Maximum_Size:MENU-Objects" },
 		{ d_text_proc ,	244 ,	300 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "Max_Menu_objects:" },
 		{ d_text_proc ,	244 ,	312 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "Max_objects_in_Menus:" },
 		{ d_text_proc ,	244 ,	324 ,	252 ,	12 ,	137 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "Max_funcs_in_Menus:" },
 		{ d_text_proc ,	244 ,	384 ,	276 ,	12 ,	249 ,	219 ,	0 ,	0 ,	0 ,	0 ,	 "Layers:" },
 		{ d_text_proc ,	244 ,	396 ,	252 ,	12 ,	137 ,	219 ,	0 ,	D_DISABLED ,	0 ,	0 ,	 "Max_Layers:" },
 		{ d_text_proc ,	244 ,	408 ,	252 ,	12 ,	137 ,	219 ,	0 ,	D_DISABLED ,	0 ,	0 ,	 "Clipboard:" },
 		{ d_text_proc ,	244 ,	420 ,	252 ,	12 ,	137 ,	219 ,	0 ,	D_DISABLED ,	0 ,	0 ,	 "Extension" },
 		{ d_edit_proc ,	484 ,	96 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	clearobj},
 		{ d_edit_proc ,	484 ,	108 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	keyobj},
 		{ d_edit_proc ,	484 ,	120 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	boxobj},
 		{ d_edit_proc ,	484 ,	132 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	sboxobj},
 		{ d_edit_proc ,	484 ,	144 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	buttonobj},
 		{ d_edit_proc ,	484 ,	156 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	radioobj},
 		{ d_edit_proc ,	484 ,	168 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	textobj},
 		{ d_edit_proc ,	484 ,	180 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	ctextobj},
 		{ d_edit_proc ,	484 ,	192 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	checkobj},
 		{ d_edit_proc ,	484 ,	204 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1,	listobj},
 		{ d_edit_proc ,	484 ,	216 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	editobj},
 		{ d_edit_proc ,	484 ,	228 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	bitmapobj},
 		{ d_edit_proc ,	484 ,	300 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	maxmenus},
 		{ d_edit_proc ,	484 ,	312 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	submenobj},
 		{ d_edit_proc ,	484 ,	324 ,	24 ,	12 ,	192 ,	219 ,	0 ,	0 ,	3 ,	1 ,	maxfuncs},
	 	{ d_edit_proc ,	484 ,	396 ,	24 ,	12 ,	192 ,	219 ,	0 ,	D_DISABLED ,	1 ,	3 ,	maxlayers},
 		{ d_edit_proc ,	484 ,	408 ,	24 ,	12 ,	192 ,	219 ,	0 ,	D_DISABLED ,	1 ,	3 ,	clipboard},
 		{ d_edit_proc ,	484 ,	420 ,	24 ,	12 ,	192 ,	219 ,	0 ,	D_DISABLED ,	1 ,	3 ,	optional},
                { d_button_proc ,	328 ,	456 ,	108 ,	12 ,	137 ,	9 ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
                { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }

	     };
	     popup_dialog(more_dia,-1);
	     
	     max_clearobj=atoi(clearobj);
	     max_keyobj=atoi(keyobj);
	     max_boxobj=atoi(boxobj);
	     max_sboxobj=atoi(sboxobj);
	     max_buttonobj=atoi(buttonobj);
	     max_textobj=atoi(textobj);
	     max_ctextobj=atoi(ctextobj);
	     max_checkobj=atoi(checkobj);
	     max_listobj=atoi(listobj);
	     max_editobj=atoi(editobj);
     	     max_bitmapobj=atoi(bitmapobj);
	     max_menobj=atoi(submenobj);
      	     FUNC=atoi(maxfuncs);
             LEVELS=atoi(maxmenus);
             max_radioobj=atoi(radioobj);

	     makeconfig();
	  }
	
	int makeconfig()
	  {
	     
             configout.open("config.cfg");
	     
	     configout<<"Default_Background_color: "<<FG;
	     configout<<"\nDefault_Foreground_color: "<<BG;
	     configout<<"\nDraw_area_width: "<<r_W;
	     configout<<"\nDraw_area_height: "<<r_H;
       	     configout<<"\nscreen_area_width: "<<__W;
	     configout<<"\nscreen_area_height: "<<__H;
	     
       	     configout<<"\nDraw_Listbox_Allegro_2_2_Format: "<<Allegroversion22;
	     configout<<"\nDraw_Button_text_optimized: "<<buttopti;
       	     configout<<"\nDefault_Grid: "<<GRID;
	     configout<<"\nMaximum_Number_of_clear_objects: "<<max_clearobj;
	     configout<<"\nMaximum_Number_of_key_objects: "<<max_keyobj;
	     configout<<"\nMaximum_Number_of_box_objects: "<<max_boxobj;
	     configout<<"\nMaximum_Number_of_sbox_objects: "<<max_sboxobj;
	     configout<<"\nMaximum_Number_of_button_objects: "<<max_buttonobj;
	     configout<<"\nMaximum_Number_of_text_objects: "<<max_textobj;
	     configout<<"\nMaximum_Number_of_ctext_objects: "<<max_ctextobj;
    	     configout<<"\nMaximum_Number_of_check_objects: "<<max_checkobj;
	     configout<<"\nMaximum_Number_of_list_objects: "<<max_listobj;
	     configout<<"\nMaximum_Number_of_edit_objects: "<<max_editobj;
	     configout<<"\nMaximum_Number_of_submenus_objects: "<<LEVELS;
       	     configout<<"\nMaximum_Number_of_submenus_in_menus: "<<max_menobj;
       	     configout<<"\nMaximum_Number_of_functions_in_menus: "<<FUNC;
             configout<<"\nMaximum_Number_of_Radiobuttons: "<<max_radioobj;
             configout<<"\nMaximum_Number_of_Bitmaps: "<<max_bitmapobj;
             configout<<"\n";

	     configout.close();
	  };
	int readconfig()
	  {
	     String dummy;
	     configin.open("config.cfg");
	     configin>>dummy>>FG;
	     configin>>dummy>>BG;
	     configin>>dummy>>_W;
	     configin>>dummy>>_H;
       	     configin>>dummy>>__W;
	     configin>>dummy>>__H;

	     configin>>dummy>>Allegroversion22;

	     configin>>dummy>>buttopti;
	     configin>>dummy>>GRID;
	     configin>>dummy>>max_clearobj;
	     configin>>dummy>>max_keyobj;
	     configin>>dummy>>max_boxobj;
	     configin>>dummy>>max_sboxobj;
	     configin>>dummy>>max_buttonobj;
	     configin>>dummy>>max_textobj;
	     configin>>dummy>>max_ctextobj;
    	     configin>>dummy>>max_checkobj;
	     configin>>dummy>>max_listobj;
	     configin>>dummy>>max_editobj;
	     configin>>dummy>>LEVELS;
       	     configin>>dummy>>max_menobj;
 	     configin>>dummy>>FUNC;
      	     configin>>dummy>>max_radioobj;
      	     configin>>dummy>>max_bitmapobj;
             configin.close();
	     
	     r_W=_W;
	     r_H=_H;
	     
	  }
     };
char name[STRINGLENGTH]="*.h";
char name2[STRINGLENGTH]="*.MDK";
int changes;
int about(...)
     {
	set_pallete( (PALETTE) picture[michipal].dat);
	show_mouse(NULL);

	clear_to_color(screen,0);
	blit(Schrift,screen,0,0,(__W-_W)/2,(__H-_H)/2,_W,_H);
	
	blit(MICHI,screen,0,0,X_GUI+_W/2-40,Y_GUI+_H/2-53,80,106);
	show_mouse(screen);
	DIALOG ok_dialog[]={
	     { d_button_proc ,	618 ,	266 ,	60 ,	12 ,	120 ,25 ,	0 ,	D_EXIT ,0 ,	0 ,	 "OK" },
	     { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	};
	popup_dialog(ok_dialog,-1);
	set_pallete( (PALETTE) set_up[MichisDialogKiste].dat);
	BLIT;
     }

class holder
/*
 * This is the overall class, which handles all objects.
 * as you see there is a member layer, which will allow 
 * handling more than one complete Allegro DIALOG at a time.
 * 
 * This is for future releases, if you encourage me to do so ;-))) 
 * 
 * */

     {
      private:
        int sele;
        int layer;
        int max_layers;
        gui_d_key_holder* keys;
	container<gui_d_clear_proc>* clear;
	container<gui_d_box_proc>* box;
	container<gui_d_shadow_box_proc>* sbox;
	textcontainer<gui_d_text_proc>* textbox;
	textcontainer<gui_d_ctext_proc>* ctextbox;
	textcontainer<gui_d_button_proc>* button;
	textcontainer<gui_d_check_button_proc>* check;
	textcontainer<gui_d_radio_proc>* radio;
	textcontainer<gui_d_edit_proc>* edit;
        textcontainer<gui_d_bitmap_proc>* bitmap;
	listcontainer<gui_d_listbox_proc>* liste;
	menucontainer* menus;
	option_holder opt;
        int obj_no;
	
	
      public:

	holder(int num)
	  {  sele=0;
             changes=0;
             layer=0;
             max_layers=1;
             obj_no=0;
	     opt.readconfig();
	     keys= new gui_d_key_holder[max_layers](max_keyobj);
	     clear=new  container<gui_d_clear_proc>[max_layers](max_clearobj,"DUMMY");
	     box=new container<gui_d_box_proc>[max_layers](max_boxobj,"DUMMY");
	     sbox=new container<gui_d_shadow_box_proc>[max_layers] (max_sboxobj,"DUMMY");
	     textbox=new textcontainer<gui_d_text_proc>[max_layers] (max_textobj,"TEXT");
	     ctextbox=new textcontainer<gui_d_ctext_proc>[max_layers](max_ctextobj,"CTEXT");
	     button=new textcontainer<gui_d_button_proc>[max_layers] (max_buttonobj,"Button");
	     radio =new textcontainer<gui_d_radio_proc>[max_layers] (max_radioobj,"Button");
	     check=new textcontainer<gui_d_check_button_proc>[max_layers] (max_checkobj,"Check");
	     edit=new  textcontainer<gui_d_edit_proc> (max_editobj,"EDIT");
	     bitmap=new  textcontainer<gui_d_bitmap_proc> (max_editobj,"BITMAP");
	     liste=new  listcontainer<gui_d_listbox_proc>[max_layers] (max_listobj,"LIST");
	     menus=new  menucontainer[max_layers](max_menobj,"MENUS");
	  }
	
	
	int save()
	  {
	     // Speichern des Hauptdialogs
	     fout.close();
	     
	     
	     if (file_select("Outputfile (Allegro C-format",name,"C;H;CC"))
	       {
		  
                  fout.open(name);
                  fout<<"\n\n // Allegro - C- code done with MichisDialogkiste \n\n";
		  // Speichern der Listenobjekte
		  
                  liste[0].save_lists();
		  
                  // Speichern des Defaultsstrings
                  int t=0;
                  while (edit[0].isvalid(t)>0)
                    {
		       edit[0].list[t].save_string();
		       t++;
		    }
                  menus[0].save_menues();
                  fout<<"\n DIALOG main_dialog[]= { ";
                  clear[0].save();
                  bitmap[0].save();
                  box[0].save();
		  sbox[0].save();
		  
                  textbox[0].save();
                  ctextbox[0].save();
		  
                  button[0].save();
                  radio[0].save();
                  check[0].save();
                  edit[0].save();
		  
                  liste[0].save();
		  
                  menus[0].save();
                  fout<<"\n { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }";
		  fout<<"\n };";
		  
                  fout.close();
	       }
	     
	     if (file_select("Outputfile (MDK-format)",name2,"MDK"))
	       {
		  
		  
                  fout.open(name2);
		  
                  box[0].export();
                  sbox[0].export();
		  
                  textbox[0].export();
                  ctextbox[0].export();
                  button[0].export();
                  check[0].export();
                  edit[0].export();
                  liste[0].export();
                  clear[0].export();
                  keys[0].export();
		  menus[0].export();
                  radio[0].export();
                  bitmap[0].export();
                  fout.close();
		  
		  changes=0;
                  }
               redraw();
	  }
	int load(...) //for c++ pointers
	  {
	     fin.close();
	     if (file_select("Inputfile (MDK-format)",name2,"MDK"))
	       {
		  fin.open(name2);
                  obj_no=box[0].import();
		  obj_no=obj_no+sbox[0].import();
                  obj_no=obj_no+textbox[0].import();
                  obj_no=obj_no+ctextbox[0].import();
                  obj_no=obj_no+button[0].import();
		  obj_no=obj_no+check[0].import();
                  obj_no=obj_no+edit[0].import();
                  obj_no=obj_no+liste[0].import();
                  obj_no=obj_no+clear[0].import(); // Am Ende !
                  obj_no=obj_no+keys[0].import();
                  obj_no=obj_no+menus[0].import();
                  obj_no=obj_no+radio[0].import();
                  obj_no=obj_no+bitmap[0].import();
		  redraw();
		  fin.close();
                  }
	  }
	int area(...)
	  {  	
	     rect_preparer p;
	     status ("Draw the Area, which contains objectes to be selected");
	     p.run();
	     clear[0].area(p.x,p.y,p.w,p.h);
	     box[0].area(p.x,p.y,p.w,p.h);
	     sbox[0].area(p.x,p.y,p.w,p.h);
	     textbox[0].area(p.x,p.y,p.w,p.h);
	     ctextbox[0].area(p.x,p.y,p.w,p.h);
	     button[0].area(p.x,p.y,p.w,p.h);
	     radio[0].area(p.x,p.y,p.w,p.h);
	     check[0].area(p.x,p.y,p.w,p.h);
	     edit[0].area(p.x,p.y,p.w,p.h);
             bitmap[0].area(p.x,p.y,p.w,p.h);
	     liste[0].area(p.x,p.y,p.w,p.h);
             status("		                  			 	  ");
	     redraw();
	     changes=1;
	     sele=1;

	  }
	
	int copy(...)
	  {
	     
	     if (!sele)
	       {
		  status("SELECT Object before doing this!");
                 rest(500);

	       }
	     else
	       {
		  
       		  obj_no=obj_no+clear[0].copy();
		  obj_no=obj_no+box[0].copy();
		  obj_no=obj_no+sbox[0].copy();
		  obj_no=obj_no+textbox[0].copy();
		  obj_no=obj_no+ctextbox[0].copy();
		  obj_no=obj_no+edit[0].copy();
		  obj_no=obj_no+button[0].copy();
		  obj_no=obj_no+radio[0].copy();
		  obj_no=obj_no+check[0].copy();
		  obj_no=obj_no+liste[0].copy();
      		  obj_no=obj_no+bitmap[0].copy();
                  redraw();
                  changes=1;

                  }
	     
	  }
	
	
	int delet(...)
	  {
	     
	     if (!sele)
	       {
		  status("SELECT Object before doing this!");
		  rest(500);
                  status("			                    ");
		 
	       }
	     else
	       {
		  
		  
		  if (!ask("Sure you want to delete selected items?"))
		    {
                       clear[0].delete_items();
		       box[0].delete_items();
		       sbox[0].delete_items();
		       textbox[0].delete_items();
		       ctextbox[0].delete_items();
		       button[0].delete_items();
		       radio[0].delete_items();
		       check[0].delete_items();
		       edit[0].delete_items();
		       liste[0].delete_items();
       		       bitmap[0].delete_items();
                       changes=1;
                       unselect();
		       redraw();
		    }
	       }
	  }
	int select(...)
	  {
	     clear[0].draw();
	     clear[0].select("Select Clear-Proc's by clicking mouse on it");
	     bitmap[0].draw();
	     bitmap[0].select("Select Bitmaps by clicking mouse on it");
             box[0].draw();
	     box[0].select("Select Boxes by clicking mouse on it");
	     sbox[0].draw();
	     sbox[0].select("Select Shadowboxes by clicking mouse on it");
	     textbox[0].draw();
	     textbox[0].select("Select Textboxes by clicking mouse on it");
	     ctextbox[0].draw();
	     ctextbox[0].select("Select centered Textboxes by clicking mouse on it");
	     edit[0].draw();
	     edit[0].select("Select Editboxes by clicking mouse on it");
	     button[0].draw();
	     button[0].select("Select Buttons by clicking mouse on it");
	     radio[0].draw();
	     radio[0].select("Select Radio-Buttons by clicking mouse on it");
	     check[0].draw();
	     check[0].select("Select Checkboxes by clicking mouse on it");
	     liste[0].draw();
	     liste[0].select("Select Listboxes by clicking mouse on it");
             redraw();
             sele=1;
	  }
        int select_desk(int mx, int my)
	  {
	     clear[0].select_desk(mx,my);
	     bitmap[0].select_desk(mx,my);
             box[0].select_desk(mx,my);
	     sbox[0].select_desk(mx,my);
	     textbox[0].select_desk(mx,my);
	     ctextbox[0].select_desk(mx,my);
	     edit[0].select_desk(mx,my);
	     button[0].select_desk(mx,my);
	     radio[0].select_desk(mx,my);
	     check[0].select_desk(mx,my);
	     liste[0].select_desk(mx,my);
             redraw();
             sele=1;
	  }
	
	int select_all(...)
	  {
	     for (int t=0;t<40;t++)
	       {
		  clear[0].select(t);
		  box[0].select(t);
		  sbox[0].select(t);
		  textbox[0].select(t);
		  ctextbox[0].select(t);
		  edit[0].select(t);
		  button[0].select(t);
		  radio[0].select(t);
		  check[0].select(t);
		  bitmap[0].select(t);
		  liste[0].select(t);
	       }
	     sele=1;
	     
	     redraw();
	  }
	int colors(...)
	  {
	     int x,y;
	     if (!sele)
	       {
		  status("SELECT Object before doing this!");
		  rest(500);
                  status("			                    ");
		 
	       }
	     else
	       {
		  
		  
		  if (ask_color())
		    { int fgc,bgc;
		       pall_obj te;
		       status("Select forground color of selected items");
		       fgc=te.run();
		       status("Select background color of selected items");
		       bgc=te.run();
                       status("			                    ");
		 
		       for (int t=0;t<40;t++)
		       	 
			 {

                            if (!clear[0].isvalid(t)) clear[0].change_color(t,fgc,bgc);
                            if (!bitmap[0].isvalid(t)) bitmap[0].change_color(t,fgc,bgc);
                            if (!box[0].isvalid(t)) box[0].change_color(t,fgc,bgc);
			    if (!sbox[0].isvalid(t)) sbox[0].change_color(t,fgc,bgc);
			    if (!edit[0].isvalid(t)) edit[0].change_color(t,fgc,bgc);
			    if (!check[0].isvalid(t)) check[0].change_color(t,fgc,bgc);
			    if (!button[0].isvalid(t))  button[0].change_color(t,fgc,bgc);
       			    if (!radio[0].isvalid(t))  radio[0].change_color(t,fgc,bgc);
                            if (!ctextbox[0].isvalid(t)) ctextbox[0].change_color(t,fgc,bgc);
			    if (!textbox[0].isvalid(t)) textbox[0].change_color(t,fgc,bgc);
			    if (!liste[0].isvalid(t)) liste[0].change_color(t,fgc,bgc);

			 }
                    	                    changes=1;
		       
                    }
		  
		  
	       }
	  }
	int properties(...)
	  {
	     if (!sele)
	       {
		  status("SELECT Object before doing this!");
                  rest(1000);
                  status("					");
	       }
	     else
	       {
		  
		  
		  clear[0].show_props();
                  bitmap[0].show_props();
		  box[0].show_props();
		  sbox[0].show_props();
		  textbox[0].show_props();
		  ctextbox[0].show_props();
		  edit[0].show_props();
		  button[0].show_props();
		  radio[0].show_props();
		  check[0].show_props();
		  liste[0].show_props();
                  unselect();
		  redraw();
	       }
	  }
	int unselect(...)
	  {
	     clear[0].unselect();
	     bitmap[0].unselect();
	     box[0].unselect();
	     sbox[0].unselect();
	     textbox[0].unselect();
	     ctextbox[0].unselect();
	     edit[0].unselect();
	     button[0].unselect();
	     radio[0].unselect();
	     check[0].unselect();
	     liste[0].unselect();
             redraw();
	     sele=0;
	     
	  }
        int mover(...)
        {

          int x,y,dx,dy;
          x=grid(mouse_x);
          y=grid(mouse_y);
          blit(Gui_area,temp_area,0,0,0,0,_W,_H);
          redraw(1); // nur nicht selektierte Objekte zeichnen
            show_mouse(NULL);
             while (mouse_b & 1)
	       {

                  dx=grid(mouse_x)-x;
	          dy=grid(mouse_y)-y;
                   x=grid(mouse_x);
                  y=grid(mouse_y);
                  clear[0].mover(dx,dy);
       	          bitmap[0].mover(dx,dy);
                  box[0].mover(dx,dy);
       	          sbox[0].mover(dx,dy);
	          textbox[0].mover(dx,dy);
	          ctextbox[0].mover(dx,dy);
	          edit[0].mover(dx,dy);
	          button[0].mover(dx,dy);
	          radio[0].mover(dx,dy);
	          check[0].mover(dx,dy);
	          liste[0].mover(dx,dy);
                  triangle(temp_area, x-X_GUI,y-Y_GUI,x-X_GUI+3,y-Y_GUI+3,x-X_GUI-3,y-Y_GUI+3,200);
                  // Neuer "Mauszeiger"
                  line(temp_area,x-X_GUI,y-Y_GUI,x-X_GUI+5,y-Y_GUI+5,200);
	          blit(temp_area,screen,0,0,X_GUI,Y_GUI,_W,_H);
                  blit(Gui_area,temp_area,0,0,0,0,_W,_H);
             	}

          show_mouse(screen);
          redraw();
         };
	int redraw(int t =0)
	  {

	     setup_bitmap();
             /*
             for (int j=0;j<obj_no;j++)
                {
                 clear[0].draw_order(j,t);
	     	 bitmap[0].draw_order(j,t);
		 box[0].draw_order(j,t);
		 sbox[0].draw_order(j,t);
	         textbox[0].draw_order(j,t);
	         ctextbox[0].draw_order(j,t);
	         edit[0].draw_order(j,t);
	         button[0].draw_order(j,t);
	         radio[0].draw_order(j,t);
	         check[0].draw_order(j,t);
	         liste[0].draw_order(j,t);
                 menus[0].draw();
                }
                */
                clear[0].draw(t);
	     	 bitmap[0].draw(t);
		 box[0].draw(t);
		 sbox[0].draw(t);
	         textbox[0].draw(t);
	         ctextbox[0].draw(t);
	         edit[0].draw(t);
	         button[0].draw(t);
	         radio[0].draw(t);
	         check[0].draw(t);
	         liste[0].draw(t);
                 menus[0].draw();
             rebuild_screen();

	     
	  }

	int opt_rungeneral(){opt.run();}
	int opt_runsize(){opt.run_size();}
	int clears(...) {  clear[0].item(obj_no);obj_no++; changes=1;}
	int key(...) { keys[0].run();changes=1;}
	int boxs(...) { box[0].item(obj_no);obj_no++; changes=1;}
	int sboxs(...) { sbox[0].item(obj_no);obj_no++; changes=1;}
	int text(...){textbox[0].item(obj_no); obj_no++;changes=1;}
	int ctext(){ctextbox[0].item(obj_no); obj_no++;changes=1;}
	int buttons(...){ button[0].item(obj_no);obj_no++; changes=1;}
	int checks(...) { check[0].item(obj_no); obj_no++;changes=1;}
	int edits(...) {edit[0].item(obj_no);obj_no++;changes=1;}
	int radios(...) {radio[0].item(obj_no);obj_no++;changes=1;}
        int bitmapf(...) {bitmap[0].item(obj_no);obj_no++;changes=1;}
	int menu(...) {changes=1; menus[0].run();}
        int list(...) { changes=1;  liste[0].item(obj_no);}

	
	
     };
#include "help.h"

holder all(1);

int quit(...)
     {
	if (alert("Really want to quit?", NULL, NULL, "Yes", "Cancel", 'y', 27) == 1)
	  {
	     if (changes)
	       {
		  if (alert("Do you want to save changes?(y/N)", NULL, NULL, "Yes", "No", 'y', 27) == 1)
                    {
		       all.save();
		       //                        text_mode(-1);
		       //	               	textout(screen,font,(unsigned char*) "Schoenen Tag noch!",X_GUI+_W/2-100,Y_GUI+_H/2-24,255);
		       //                   	textout(screen,font,(unsigned char*) "Ade!",X_GUI+_W/2-100,Y_GUI+_H/2-0,255);
		       //                        rest(2000);
		       
		    }
		  
	       }
	     return D_CLOSE;

	  }
	else
	  return D_O_K;

     }

/*
 * There was no other way to handle the menus with an Allegro 
 * MENU- dialog in C++ than with extern "C". If you have a better C++
 * solution - tell me.
 * 
 * */
extern "C"{

   
   int all_load() {all.load();return 0;};
   int all_save() {all.save();return 0;};
   int all_moves() {all.mover();return 0;};
   int all_select() {all.select();return 0;};
   int all_delet() {all.delet();return 0;};
   int all_select_all() {all.select_all();return 0;};
   int all_draw() {clear(screen);all.redraw();;return 0;};
   int all_keys() {all.key();return 0;};
   int all_clear() {all.clears();return 0;};
   int all_box() {all.boxs();return 0;};
   int all_sbox() {all.sboxs();return 0;};
   int all_button() {all.buttons();return 0;};
   int all_check() {all.checks();return 0;};
   int all_edit() {all.edits();return 0;};
   int all_text() {all.text();return 0;};
   int all_ctext() {all.ctext();return 0;};
   int all_list() {all.list();return 0;};
   int all_properties() {all.properties();return 0;};
   int all_opt_rungeneral() {all.opt_rungeneral();return 0;};
   int all_opt_runsize() {all.opt_runsize();return 0;};
   int all_radio() {all.radios();return 0;};
   int all_copy() {all.copy();return 0;};
   int all_colors() {all.colors();return 0;};
   int all_unselect() {all.unselect();return 0;};
   int all_area() {all.area();return 0;};
   int Menus_run() {all.menu();return 0;};
   int all_bitmap() {all.bitmapf(); return 0;};
   int menues_defaults() {status("Not implemented yet.");
                                rest(1000);
                   		rebuild_screen();
                                return 0;};
   int objecthelp() {status("Not implemented yet.");
                                rest(1000);
                   		rebuild_screen();
                                return 0;};
   int copy() {all.copy();};
   int selectthis()
    {
      int mx=mouse_x;
      int my=mouse_y;
      set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
      show_mouse(NULL);
      all.select_desk(mx,my);
      show_mouse(screen);

     };
   int redr() {all.redraw();};
   // If the screen would be clear from within the menu, the
   // Mainmenu would not be drawn
   int draganddrop() {};
MENU MenuDraw[] ={
 { "&Clear-Box"	, all_clear 	,NULL},
 { "&Shortcut"	, all_keys 	,NULL},
 { ""	, NULL 	,NULL},
 { "&Box"	, all_box 	,NULL},
 { "&ShadowBox"	, all_sbox 	,NULL},
 { ""	, NULL 	,NULL},
 { "&Text"	, all_text 	,NULL},
 { "C&entered-Text"	, all_ctext 	,NULL},
 { "&Edit-proc"	, all_edit 	,NULL},
 { ""	, NULL 	,NULL},
 { "C&heck-Box"	, all_check 	,NULL},
 { "&Button"	, all_button 	,NULL},
 { "&Radio-Button"	, all_radio 	,NULL},
 { ""	, NULL 	,NULL},
 { "&List-Box"	, all_list 	,NULL},
 { ""	, NULL 	,NULL},
 { "B&itmap"	, all_bitmap 	,NULL},
 { NULL,	 NULL,	 NULL },
 };

   MENU PULLUP_DESKTOP[] ={
	{ "&Draw"	, NULL 	,MenuDraw},
        { "&Copy"	, copy 	,NULL},
        { "D&elete"	, all_delet 	,NULL},
	{ "&Redraw"	, redr 	,NULL},
	{ ""	, NULL 	,NULL},
       	{ "&Properties"	, all_properties	,NULL},
        { ""	, NULL 	,NULL},
        { "Select_&All"	, all_select_all 	,NULL},
	{ "S&elect_Area"	, all_area 	,NULL},
	{ "&Unselect_All"	, all_unselect      ,NULL},
        { NULL,	 NULL,	 NULL },
   };
   

int d_desktop_proc(int msg, DIALOG *d, int c)
{
 int mx,my;
 if (msg==MSG_DCLICK)
   {
    mx=mouse_x;
    my=mouse_y;
    set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
    show_mouse(NULL);
    all.select_desk(mx,my);
    show_mouse(screen);
    set_mouse_range(0,0,__W,__H);
    return D_O_K;
   }

 if (msg==MSG_CLICK)
   {

    mx=mouse_x;
    my=mouse_y;
    if  (!(mouse_b & 1))
      {
        do_menu(PULLUP_DESKTOP,mx,my);
       	set_mouse_range(0,0,__W,__H);
        rebuild_screen();
        return D_O_K;
        
      }
    rest(100);


    if  (mouse_b & 1)
      {
        set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
       all.mover();
       set_mouse_range(0,0,__W,__H);
       }
    return D_O_K;
   }


 return D_O_K;
}


   MENU MenuMeunues[] ={
	{ "&Objects"	, Menus_run 	,NULL},
	{ "&Defaults"	, menues_defaults 	,NULL},
	{ NULL,	 NULL,	 NULL },
   };
   MENU MenuHelp[] ={
	{ "&Help"	, help 	,NULL},
	{ "&Object-Help"	, objecthelp 	,NULL},
	{ ""	, NULL 	,NULL},
	{ "&About"	, about 	,NULL},
	{ NULL,	 NULL,	 NULL },
   };
   MENU MenuOptions[] ={
	{ "&General"	, all_opt_rungeneral 	,NULL},
	{ "&Objects"	, all_opt_runsize 	,NULL},
	{ NULL,	 NULL,	 NULL },
   };
   MENU MenuSelect[] ={
	{ "Select-&All"	, all_select_all 	,NULL},
	{ "&Select-&Single"	, all_select 	,NULL},
	{ "Select-A&rea"	, all_area 	,NULL},
	{ ""	, NULL 	,NULL},
	{ "&Unselect-All"	, all_unselect 	,NULL},
	{ NULL,	 NULL,	 NULL },
   };
   MENU MenuEdit[] ={
	{ "&Select"	, NULL 	,MenuSelect},
	{ ""	, NULL 	,NULL},
	{ "&Copy"	, all_copy 	,NULL},
	{ "&Move"	, all_moves 	,NULL},
	{ "&Delete"	, all_delet 	,NULL},
	{ ""	, NULL 	,NULL},
	{ "&Colors"	, all_colors 	,NULL},
	{ "&Properties"	, all_properties 	,NULL},
	{ ""	, NULL 	,NULL},
	{ "&Redraw"	, all_draw 	,NULL},
	{ NULL,	 NULL,	 NULL },
   };
   MENU MenuFile[] ={
	{ "&Load"	, all_load 	,NULL},
	{ "&Save"	, all_save 	,NULL},
	{ "&Quit"	, quit 	,NULL},
	{ NULL,	 NULL,	 NULL },
   };

   MENU MenuMain[] ={
	{ "&File"	, NULL 	,MenuFile},
	{ "&Draw"	, NULL 	,MenuDraw},
	{ "&Edit"	, NULL 	,MenuEdit},
	{ "&Menues"	, NULL 	,MenuMeunues},
	{ "&Options"	, NULL 	,MenuOptions},
	{ "&?"	, NULL 	,MenuHelp},
	{ NULL,	 NULL,	 NULL },
   };
   DIALOG main_dialog[]= { 
	{ d_menu_proc ,	0 ,	0 ,	0 ,	0 ,	128 ,	37 ,	0 ,	0 ,	0 ,	0 ,	MenuMain},
	{ d_desktop_proc ,(__W-_W)/2, (__H-_H)/2 ,	_W ,	_H ,	0 ,	0 ,	0 ,	0 ,	0 ,	0 ,NULL},
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   
}

	 


int main()
/*
 * As usuall in C++:
 * main() is pretty small
 *
 * */
     {

	allegro_init();
	install_keyboard();
	install_mouse();
	install_timer();
        set_gfx_mode(GFX_AUTODETECT,__W,__H, 0, 0);
        Setup();
        gui_fg_color=128;
	gui_bg_color=37;



        keystrings=(char**) malloc(sizeof(char*)* max_keyobj);
   	for (int t=0;t<max_keyobj;t++)
               keystrings[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);

 
        menustrings=(char**) malloc(sizeof(char*)* max_menobj);
   	for (int t=0;t<max_menobj;t++)
               menustrings[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);

        functions=(char**) malloc(sizeof(char*)* FUNC);
        for (int t=0;t<FUNC;t++)
               functions[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);


        kids=(char**) malloc(sizeof(char*)* LEVELS);
   	for (int t=0;t<LEVELS;t++)
               kids[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);

        listobjects=(char**) malloc(sizeof(char*)* list_size);
   	for (int t=0;t<LEVELS;t++)
               listobjects[t]=(char*) malloc(sizeof(char)*STRINGLENGTH);

	popup_dialog(main_dialog,-1);

	delete[] keystrings;
        delete[] menustrings;
        delete[] functions;
        delete[] kids;

        allegro_exit();

     };

/* 
 * By Michi Schuster 1997
 * If you use it, write postcard (see readme.txt)
 * */

