/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "text.h"

/* ----------------------------------------------------------------- */
static void _outtextxy(int *xx, int *yy, int XX, int YY, uchar *textstring)
{
  _DO_INIT_CHECK;
  __gr_text_init();
#ifdef GRX_VERSION
  if (TXT.font==DEFAULT_FONT) {
    if (DefaultFonts[TXT.charsize] == NULL)
      DefaultFonts[TXT.charsize] =
	GrBuildConvertedFont(
	  DefaultFonts[1],
	  GR_FONTCVT_RESIZE,
	  8*ZERO2ONE(TXT.charsize),
	  8*ZERO2ONE(TXT.charsize),
	  0, 0);
    __gr_text_bit(DefaultFonts[TXT.charsize],xx,yy,XX,YY,textstring);
  } else
#endif
  if (BITMAP(TXT.font))
    __gr_text_bit((GrFont *)Fonts[TXT.font],xx,yy,XX,YY,textstring);
  else
    __gr_text_vec(xx,yy,XX,YY,textstring);
}

/* ----------------------------------------------------------------- */
void outtext( char *textstring)
{
  _outtextxy(&X, &Y, X+VL, Y+VT+PY, (uchar *)textstring);
}

/* ----------------------------------------------------------------- */
void outtextxy(int x, int y, char *textstring)
{
  _outtextxy( &x, &y, x+VL, y+VT+PY, (uchar *)textstring);
}

