/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "text.h"

int __gr_text_ChrFontInfo(void *Font, CharInfo *fntptr, int *height) {
  int i, LstChar;
  char *cp;
  ushort *Offsets;
  uchar *Widths;
  char *Data;
  FontFileHeader *ffh;
  FontHeaderTyp *fht;

  cp = (char *)Font;
  i = 256;
  while (*cp != '\x1a' ) { /* \x1a = ^Z */
    ++cp;
    --i;
    if (i == 0)   /* Error, no ^Z at end of copyright */
      return FALSE;
  }
  ++cp;
  ffh = (FontFileHeader *)cp;
  fht = (FontHeaderTyp *)((char *)Font + ffh->header_size);
  if (fht->sig != '+')
    return FALSE; /* Magic failed */
  if (fht->scan_flag) {
    /* font may have DO_SCAN op, anything we should do ? */
  }
  Offsets = (ushort *)((char *)fht + sizeof(FontHeaderTyp));
  Widths  = (uchar *)Offsets + 2 * (int)fht->nchrs;
  Data    = (char *)Font + fht->cdefs + ffh->header_size;
  LstChar = fht->firstch + fht->nchrs - 1;

  *height = (int)fht->org_to_cap - (int)fht->org_to_dec;
  for (i=fht->firstch; i <= LstChar; ++i) {
    fntptr[i].width = Widths[i - fht->firstch];
    fntptr[i].cmd   = (ushort *)(Data + Offsets[i - fht->firstch]);
  }
  return TRUE;
}

