#include <stdio.h>
#include <pc.h>
#include <keys.h>
#include <dpmi.h>
#include "serio.h"

#define b1200        96
#define b2400        48
#define b4800        24
#define b9600        12
#define com1         0x3f8
#define com2         0x2f8
#define com3         0x3e8
#define com4         0x2e8


int main()
{
	int done=0, echo=0;
	int c;
	SioPort *comPort;

	/* Required by BCSerio */
	extern char sltext[] asm ("sltext");
	extern char eltext[] asm ("eltext");
	extern char sldata[] asm ("sldata");
	extern char eldata[] asm ("eldata");
	_go32_dpmi_lock_code(sltext,eltext-sltext);
	_go32_dpmi_lock_data(sldata,eldata-sldata);


	comPort = sio_openport(com2, 3);
	sio_setparms(comPort, sio8Bits, sioNoParity, sio1StopBit);
	sio_setspeed(comPort, b9600);
	do {
	   if (kbhit()) 
		{
		c = getkey();
		if (c > 0x100) 
			{
			switch (c) 
				{
				case K_Alt_E:
					echo=!echo;
					break;
				case K_Alt_X:
					done=1;
					break;
				case K_Alt_B:
					sio_sendbreak(comPort, 5);
					break;
				}
			} 
		else 
			{
			while (sio_put(comPort, c));
			if (echo) 
				{
				if (c == '\r') 
					{
					putchar('\n');
					}
				else
					{
					putchar(c);
					}
				fflush(stdout);
				}
			}
		}

	   if (sio_charready(comPort)) 
		{
		c = sio_get(comPort);
		if (c == '\r') 
			{
			putchar('\n');
			}
		else
			{
			/*putchar(c);*/
			printf("%02X ",c);
			}
		fflush(stdout);
		}
	} while (!done);

	printf("Closing COM port...\n");
	sio_closeport(comPort);
	printf("Exiting...\n");
	return(0);
}
