#
# BETATRON high level library for platform and action arcade games.
# Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
#
# DTCOLTIL.S: This file is part of the BETATRON library and can be used
#             and/or distributed only under the terms of the GNU Library
#             General Public License. See doc/readme.1st for details.
#



.extern _pl_a000h
.globl	_drawtcoltile

#/*
#----------------------------------------------------------------------------
# extern "C" void drawtcoltile(char *tile,unsigned char tilex,
#			       unsigned char tiley,unsigned short pageofs,
#			       unsigned char colno);
#
# drawttile =  draw thru tile
# 坜  椞 ⤘ tile,  妬  ᩜ 夘 1616
# tile:    填  ⤘ array[256] of byte
# tilex:    ⤞ ( 16ᛜ pixel) ᤠ  tile
# tiley:    ⤞ ....
# pageofs:  矬 ᡨ   video memory
#	    ᤠ  modex   㡦  352 pixel
#	   , 88 礩  video ram
#	    tile ਜ嫘   , 槦 ᨮ
#	   飘 0 夘 .
#----------------------------------------------------------------------------
#*/

.equ savedebp5	,   0
.equ retadr5	,   4
.equ tile5	,   8
.equ tilex5	,   12
.equ tiley5	,   16
.equ pageofs5	,   20
.equ colno5	,   24

_drawtcoltile:

	pushl	%ebp
	movl	%esp,%ebp
	pusha
	pushw %es

	mov _pl_a000h,%ax
	mov %ax,%es

	xorl	%ecx,%ecx
	movl	tile5(%ebp),%esi     # //tile

	movb	colno5(%ebp),%cl      # charno
	addl	%ecx,%esi

	xorl	%edi,%edi

	movw	$352,%ax
	movb	tiley5(%ebp),%bl      # //tiley
	xorb	%bh,%bh
	mulw	%bx
	movb	tilex5(%ebp),%bl      # //tilex
	addw	%bx,%ax
	shlw	$2,%ax	#  //ax = (tiley*16*22*16 + tilex*16) / 4

	movw	pageofs5(%ebp),%di    # //pageofs

	addw	%ax,%di # // o di  矬   tile  video ram
	addw	%cx,%di # sin apomakrinsi logo stilis
	movw	$0x03c4,%dx	# //sequencer controller  bitplane masking


	xorb	%cl,%cl # //proto bitplane

nextplane:

	movw	$16,%bx # // bx: , 16 grammes /tile

	movb	$0x02,%al	# // map mask register
	movb	$0x01,%ah	#
	shlb	%cl,%ah # // epelekse to katallilo bitplane
	outw	%ax,%dx
	pushl	%esi
	pushw	%di	#// sose tous di,si


nextline:
	movb	(%esi),%al
	testb	%al,%al
	jz	dontplotit0
	movb	%al,%es:(%edi)
dontplotit0:
	addw	$88,%di #//  di 室  棜 
	addl	$4,%esi # // epomeni grammi kai sto tile
	decw	%bx
	jnz	nextline



	popw	%di	# // o di na ksanadeiksei sthn proti grammi
	popl	%esi
	addl	$64,%esi	# o si sto epomeno bitplane
	incb	%cl
	cmpb	$4,%cl	# // ftasame sto 4o bitplane
	jne	nextplane      # // an oxi proxora sto epomeno


	popw	%es
	popa
	popl	%ebp

	ret

.END
