/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997	Liouros Thanasis, liouros@hotmail.com
 **
 ** ANIMATE.CC: This file is part of the BETATRON library and can be used
 **		and/or distributed only under the terms of the GNU Library
 **		General Public License. See doc/readme.1st for details.
 */


#include "world.h"
#include "plvga.h"
#include <dpmi.h>
#include "cb.h"
#include <string.h>


// to pl_videosize einai katholiki metavliti
#define INCOFS(ofs,val) { (ofs)+=(val); if ( (ofs) >= (pl_videosize>>2	))   (ofs)-=(pl_videosize>>2);}
#define DECOFS(ofs,val) { (ofs-=val); if ( (ofs) < 0) (ofs)+=(pl_videosize>>2); }

// to pl_screenbufsize einai katholiki metavliti sto cb.cc
#define INCBUF(ofs,val) { (ofs)+=(val); if ( (ofs) >= (pl_screenbufsize>>2)) (ofs)-=(pl_screenbufsize>>2); }
#define DECBUF(ofs,val) { (ofs)-=(val); if ( (ofs) < 0) (ofs)+=(pl_screenbufsize>>2); }




//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

short TOworld::animate()
{
 char ch;
 unsigned long value;
 short i;

 tilechanged=0;
 for (;!exitbit;)
 {


 if (Pframeready) *Pframeready=1;  // etoimo to frame


//------------------------- betatron kernel ------------------------------
 if (Pkernelproc) Pkernelproc(this);
 else
 {
  __dpmi_get_and_disable_virtual_interrupt_state();
  pageswap();
  setsadr();
  pl_retrace();
  sethpel();
  refreshpal();
 __dpmi_get_and_enable_virtual_interrupt_state();
 }
//---------------------------------------------------------------------


// ------------------ row & column update part 2------------------------

  if (horupdate)
  if (curmode==gmMODEX320x200)
    v2v(backofs,scrollcol,0,drawofs,scrollcol,0,SCROLLCOLLEN >> 2,240);
  else
  {
   Mcb2Vcbsolid( bufofs, scrollcol, 0,	drawofs, scrollcol, 0, SCROLLCOLLEN, Ylen);
   Mcb2Vcbsolid(bufofs,scrollcol,0,  backofs, scrollcol,0,  SCROLLCOLLEN, Ylen);
  }


  if (verupdate)
  if (curmode==gmMODEX320x200)
    v2v(backofs,0,scrollrow<<2,drawofs,0,scrollrow<<2,88,SCROLLROWHEI);
  else
  {
    Mcb2Vcbsolid( bufofs, 0,scrollrow,	drawofs, 0, scrollrow, Xlen, SCROLLROWHEI);
    Mcb2Vcbsolid(bufofs,0,scrollrow,  backofs,	 0, scrollrow, Xlen, SCROLLROWHEI);
  }

// ------------------------------------------------------------------------


// ---------------------   tilerefresh part 2 -----------------------------
 if (tilechanged)
 {
  if (curmode==gmMODEX320x200)
   refreshtiles2();    // antigrapse kai stin triti selida ta allagmena tiles
  else
   refreshtiles2vesa();

   memset((char *)tilerefresh[0],0,(MAXXTILES+2)*(MAXYTILES+2));
 }
// ------------------------------------------------------------------------


// --------------------- refresh part 2 ------------------------------
 if (refreshbit)
 {
   if (curmode==gmMODEX320x200)
    drawall(drawofs);
   else
   {
    Mcb2Vcbsolid(bufofs,0,0,   drawofs,0,0,  Xlen,Ylen);
    Mcb2Vcbsolid(bufofs,0,0,   backofs,0,0,  Xlen,Ylen);
   }
    refreshbit=0;
 };
//---------------------------------------------------------------------


// -------------------- update the background -------------------------
 if (curmode==gmMODEX320x200)
  erasesprites();  // svise ta sprites
 else erasespritesvesa();

// -------------------- update the background -------------------------


 // no new row or column
 horupdate=verupdate=0;


// ---------------------------- build in timing -------------------------

  // hipart:lopart += value
 unsigned long prevlo=lotimerpart;
 lotimerpart+=retraceticks;
 if (lotimerpart < prevlo) hitimerpart++; // ean iperxilisi prosthese sto hipart 1

#define TICKSDIVISOR	   10
 oldtimerticks=timerticks;
 // timerticks=low( hipart:lopart >> TICKSDIVISOR)
 unsigned long l=hitimerpart << (32-TICKSDIVISOR);
 timerticks = lotimerpart>>TICKSDIVISOR;
 timerticks|=l;

 dticks=timerticks-oldtimerticks;
// ----------------------------------------------------------------------


// -------------------------- Grids -------------------------------------
  for (i=0;i<MAXGRIDSNO;i++) if (grids[i]) grids[i]->clusterize();
// ----------------------------------------------------------------------



 tilechanged=0;
 wx0=wx;
 wy0=wy;		 // (wx0,wy0) antistoixei sto tilerefresh[1][1]

 callactionfunctions();  // kalese tis action functions

 if (drawofs > drawofslimit) swaplongs(drawofs,backofs);

//-------------------- VESA  refresh --------------------------------
 if (refreshbit)
 if (curmode!=gmMODEX320x200)
 {
   drawallvesa();
   Mcb2Vcbsolid(bufofs,0,0,	 drawofs,0,0,	Xlen,Ylen);
 }
//-------------------------------------------------------------------


//-------------------------- Vesa row & columd update----------------
 if (verupdate)
 if (curmode!=gmMODEX320x200)
 {
  drawrowvesa(scrollrow);
  Mcb2Vcbsolid(bufofs,0,scrollrow,  drawofs,   0, scrollrow, Xlen, SCROLLROWHEI);
 }

 if (horupdate)
 if (curmode!=gmMODEX320x200)
 {
   drawcolvesa(scrollcol);
   Mcb2Vcbsolid(bufofs,scrollcol,0,  drawofs, scrollcol,0,  SCROLLCOLLEN, Ylen);
 }
//-------------------------------------------------------------------


//------------------------ tilerefresh ------------------------------
 if (tilechanged)
  if (curmode==gmMODEX320x200)
 refreshtiles1();
  else
 refreshtiles1vesa();
//-------------------------------------------------------------------





 // katharise ton pinaka ananeosis background
 memset((char *)forerefresh[0],0,MAXXTILES*MAXYTILES);

 // zografise ta sprites mexri kai ton background layer

 drawsprites(0,backprior);


 if (curmode==gmMODEX320x200) drawbackground(LAY_BACK);
 else drawbackgroundvesa(LAY_BACK);

 if (backprior<foreprior) drawsprites(backprior+1,foreprior);


 if (curmode==gmMODEX320x200) drawbackground(LAY_FORE);
 else drawbackgroundvesa(LAY_FORE);

 if (foreprior<PRIORITIESNO-1) drawsprites(foreprior+1,PRIORITIESNO-1);

}



 exitbit=0;
}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
// prosoxi to mikos tou kosmou toulaxiston 22
// kai to ipsos tou toulaxiston 15
// auto isxuei gia olokliri ti mixani oxi mono
// gi auti ti routina

/////// allagi gia na leitourgei kai me VESA modes -------etoimi //////

short TOworld::jumpto(unsigned short newx,unsigned short newy)
{
 if (  (newx>= (length<<4)-(Xres-1)  ) || ( newy>= (height<<4)-(Yres-1)) )
  return ERR_OUTOFRANGE;

 x=newx;
 y=newy;
 wx=(x>>4);
 if (wx>length-Xtiles) wx = length-Xtiles;  // elegkse telos kosmou deksia
 wy=(y>>4);
 if (wy>height-Ytiles) wy = height-Ytiles;  // elegkse telos kosmou kato

 hadr = x - (wx<<4);
 vadr = y - (wy<<4);

 huplim=32;
 hdownlim=0;
 vuplim=32;
 vdownlim=0;

 sadr = (hadr >> 2) + vadr * (Xlen>>2);  // apomakrinsi apo thn arxi tis selidas

 hpel = (hadr & 3) << 1;    // (hadr mod 4 ) * 2

 if (palettechanged) { refreshpal(); palettechanged=0; }

 if (curmode==gmMODEX320x200)
 {
   drawall(drawofs);
   drawall(showofs);
   drawall(backofs);
 }
 else
 {
   drawallvesa();   // zografise ston screen buffer
   Mcb2Vcbsolid(bufofs, 0,0,	drawofs,0,0,  Xlen,Ylen);
   Mcb2Vcbsolid(bufofs, 0,0,	showofs,0,0,  Xlen,Ylen);
   Mcb2Vcbsolid(bufofs, 0,0,	backofs,0,0,  Xlen,Ylen);
 }

 return ERR_NOERR;
}
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

short TOworld::scrollRmx(signed char dx)  // ᨜ /  橣
{
  signed char realdx;

 //den mporo na skrollaro pano apo 4 pixel
 // epestrepse oti skrollarisa 0 pixel

 if ((dx > SCROLLCOLLEN) || (dx <-SCROLLCOLLEN) || (horupdate)) return 0;

 hadr+=dx;
 if  ((wx == 0) && (hadr < 0))	   //elekse telos kosmou aristera
  {
   realdx= -(hadr-dx);
   hadr=0;
  }
 else
 if ( (wx == length - 22) && (hadr > 32))  // elekse telos kosmou deksia
  {
   realdx=32-(hadr-dx);
   hadr=32;
  }
 else
  realdx = dx;


 if (hadr > 32)     // xreiazetai deksia enimerosi ?
 {
   hadr = hadr - 16;  // nea timi ths hadr
   if (hdownlim>16) hdownlim-=16; else hdownlim=0;
   huplim-=16;
   wx++;	// auksise sintetagmenes selidas
   INCOFS(drawofs,4);  // kathos kai apomakrinsi selidas
   INCOFS(showofs,4);
   INCOFS(backofs,4);
 }
 else
 if (hadr < 0 )    // xreiazetai aristera enimerosi
 {
   hadr = hadr + 16;
   if (huplim<16) huplim+=16; else huplim=32;
   hdownlim+=16;
   wx--;
   DECOFS(drawofs,4);  // kathos kai apomakrinsi selidas
   DECOFS(showofs,4);
   DECOFS(backofs,4);
  }

 if (hadr>huplim && !(hadr >32))   // prepei na tipothei mia nea tetrada
 {
   scrollcol= ((Xlen-32-1 + hadr) & (~( SCROLLCOLLEN - 1)) ) >> 2;
   drawcol(scrollcol, drawofs);
   v2v(drawofs,scrollcol,0,backofs,scrollcol,0,SCROLLCOLLEN >> 2,240);
   huplim+=SCROLLCOLLEN;
   horupdate=1;
 }
 else if (hadr<hdownlim)
 {
   scrollcol=(hadr & (~( SCROLLCOLLEN - 1)) )  >>2;
   drawcol(scrollcol,drawofs);
   v2v(drawofs,scrollcol,0,backofs,scrollcol,0, SCROLLCOLLEN >>2,240);
   hdownlim-=SCROLLCOLLEN;
   horupdate=2;
 }




 sadr = (hadr >> 2) + vadr * 88;  // apomakrinsi apo thn arxi tis selidas
				 // 88: platos grammis video ram

 hpel = (hadr & 3) << 1;    // (hadr mod 4 ) * 2
 x=(wx << 4) + hadr;
 y=(wy << 4) + vadr;

 return realdx;   // posa pixel katafera na skrollaro telika

}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

short TOworld::scrollDmx(signed char dy)  // ᨜ /  橣
{
  signed char realdy;
  char downend = 0;

 //den mporo na skrollaro pano apo 4 pixel
 // epestrepse oti skrollarisa 0 pixel

 if ((dy > SCROLLROWHEI) || (dy <-SCROLLROWHEI) || (verupdate)) return 0;

 vadr+=dy;
 if  ((wy == 0) && (vadr < 0))	   //elekse telos kosmou pano
  {
   realdy= -(vadr-dy);
   vadr=0;
  }
 else
 if ( wy == height - 15 )
 {
   downend = 1;     // ftasame sto telos pros ta kato

  // stin periptosi pou eimaste sto telos toy kosmoy pros ta kato
  // mporoume na emfanisoume miso akoma tile (8 pixel, 32 + 8 = 40)
  // afou h katheti analisi 200 pixel = 12,5 tiles

  if (vadr > 40)  // elekse telos kosmou kato
  {
   realdy=40-(vadr-dy);
   vadr=40;
  }
 }
 else
  realdy = dy;

 if ((vadr > 32) && (!downend))     // xreiazetai kato enimerosi ?
 {
   vadr = vadr - 16;  // nea timi ths vadr
   vuplim-=16;
   if (vdownlim>16) vdownlim-=16; else vdownlim=0;
   wy++;	// auksise sintetagmenes selidas
   INCOFS(drawofs,16*(Xlen >>2) );  // kathos kai apomakrinsi selidas
   INCOFS(showofs,16*(Xlen >>2) );
   INCOFS(backofs,16*(Xlen >>2) );
 }
 else
 if (vadr < 0 )    // xreiazetai aristera enimerosi
 {
   vadr = vadr + 16;
   vdownlim+=16;
   if (vuplim<16) vuplim+=16; else vuplim=32;
   wy--;
   DECOFS(drawofs,16L*(Xlen >>2) );  // kathos kai apomakrinsi selidas
   DECOFS(showofs,16L*(Xlen >>2) );
   DECOFS(backofs,16L*(Xlen >>2) );
  }

 if (vadr>vuplim && !(vadr >32) )   // prepei na tipothei mia nea tetrada
 {
   scrollrow= ( (Ylen-32-1 +vadr) & (~( SCROLLROWHEI - 1))  ) >> 2;
   drawrow(scrollrow, drawofs);
   v2v(drawofs,0,scrollrow<<2,backofs,0,scrollrow<<2,88,SCROLLROWHEI);
   vuplim+=SCROLLROWHEI;
   verupdate=1;
 }
 else if (vadr<vdownlim)
 {
   scrollrow=(vadr & (~( SCROLLROWHEI - 1)) ) >>2;
   drawrow(scrollrow,drawofs);
   v2v(drawofs,0,scrollrow<<2,backofs,0,scrollrow<<2,88,SCROLLROWHEI);
   vdownlim-=SCROLLROWHEI;
   verupdate=2;
 }





 sadr = (hadr >> 2) + vadr * 88;  // apomakrinsi apo thn arxi tis selidas
				 // 88: platos grammis video ram

 x=(wx << 4) + hadr;   // PROSOXI: an einai dinaton oi telestes +,-
 y=(wy << 4) + vadr;   // exoun megaliteri proteraiotita apo tous <<,>>

 return realdy;   // posa pixel katafera na skrollaro telika

}



//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

short TOworld::scrollRvesa(signed char dx)  // ᨜ /  橣
{
  signed char realdx;
  char rightend=0;

 //den mporo na skrollaro pano apo MAXSCROLLH pixel
 // epestrepse oti skrollarisa 0 pixel

 if ((dx > SCROLLCOLLEN) || (dx <-SCROLLCOLLEN) || (horupdate)) return 0;

 hadr+=dx;
 if  ((wx == 0) && (hadr < 0))	   //elekse telos kosmou aristera
  {
   realdx= -(hadr-dx);
   hadr=0;
  }
 else
 if ( (wx == length - Xtiles))	// elekse telos kosmou deksia
  {
    rightend=1;

   if (hadr > horborder)
   {
    realdx=horborder-(hadr-dx);
    hadr=horborder;
   }
  }
 else
  realdx = dx;


 if (hadr > 32	&& (!rightend))     // xreiazetai deksia enimerosi ?
 {
   hadr = hadr - 16;  // nea timi ths hadr
   if (hdownlim>16) hdownlim-=16; else hdownlim=0;
   huplim-=16;
   wx++;	// auksise sintetagmenes selidas
   INCOFS(drawofs,4);  // kathos kai apomakrinsi selidas
   INCOFS(showofs,4);
   INCOFS(backofs,4);
   INCBUF(bufofs,4);
 }
 else
 if (hadr < 0 )    // xreiazetai aristera enimerosi
 {
   hadr = hadr + 16;
   if (huplim<16) huplim+=16; else huplim=32;
   hdownlim+=16;
   wx--;
   DECOFS(drawofs,4);  // kathos kai apomakrinsi selidas
   DECOFS(showofs,4);
   DECOFS(backofs,4);
   DECBUF(bufofs,4);
  }

 if (hadr>huplim && !(hadr > 32))   // prepei na tipothei mia nea tetrada
 {
   // midenise ta xamilotera SCOLLCOLLEN2 bits
   scrollcol= ((Xlen-32-1) + hadr) & (~( SCROLLCOLLEN - 1));
   huplim+=SCROLLCOLLEN;
   horupdate=1;
 }
 else if (hadr<hdownlim)
 {
   scrollcol=hadr & (~( SCROLLCOLLEN - 1));
   hdownlim-=SCROLLCOLLEN;
   horupdate=2;
 }


 sadr = (hadr >> 2) + vadr * (Xlen>>2);  // apomakrinsi apo thn arxi tis selidas
					 // Xlen >> 2: platos grammis video ram

 hpel = (hadr & 3) << 1;    // (hadr mod 4 ) * 2
 x=(wx << 4) + hadr;
 y=(wy << 4) + vadr;

 return realdx;   // posa pixel katafera na skrollaro telika
}







short TOworld::scrollDvesa(signed char dy)
{
  signed char realdy;
  char downend=0;

 if ((dy > SCROLLROWHEI) || (dy <-SCROLLROWHEI) || (verupdate)) return 0;

 vadr+=dy;
 if  ((wy == 0) && (vadr < 0))	   //elekse telos kosmou pano
  {
   realdy= -(vadr-dy);
   vadr=0;
  }
 else
 if ( (wy == height - Ytiles))
 {
   downend=1;

   if ( vadr > verborder)
   {
    realdy=verborder-(vadr-dy);
    vadr=verborder;
   }
 }
 else
  realdy = dy;

 if ( vadr > 32  && (!downend))     // xreiazetai kato enimerosi ?
 {
   vadr = vadr - 16;  // nea timi ths vadr
   vuplim-=16;
   if (vdownlim>16) vdownlim-=16; else vdownlim=0;
   wy++;	// auksise sintetagmenes selidas
   INCOFS(drawofs,16*(Xlen >>2) );  // kathos kai apomakrinsi selidas
   INCOFS(showofs,16*(Xlen >>2) );
   INCOFS(backofs,16*(Xlen >>2) );
   INCBUF(bufofs, 16*(Xlen >>2) );
 }
 else
 if (vadr < 0 )    // xreiazetai aristera enimerosi
 {
   vadr = vadr + 16;
   vdownlim+=16;
   if (vuplim<16) vuplim+=16; else vuplim=32;
   wy--;
   DECOFS(drawofs,16L*(Xlen >>2) );  // kathos kai apomakrinsi selidas
   DECOFS(showofs,16L*(Xlen >>2) );
   DECOFS(backofs,16L*(Xlen >>2) );
   DECBUF(bufofs, 16L*(Xlen >>2) );
  }

// to vadr tha einai megaglitero apo 32 an to downend einai 1
// opote den tha paei sto parapano if
// an vadr > 32 tote Ylen -32 -1 + vadr > Ylen kai prospathei
// na tiposei ekso apo ton kosmo tile pou den iparxoun
 if (vadr>vuplim && !(vadr>32) )   // prepei na tipothei mia nea tetrada
 {
   // Theoroume oti i othoni exei ipsos akeraio pollaplasio tou 16
   // kai tiponoume ena neo row sto telos tis panta, akoma kai an den fainetai
   // tha fanei argotera
   scrollrow= ((Ylen-32-1)+vadr) & (~( SCROLLROWHEI - 1));
   vuplim+=SCROLLROWHEI;
   verupdate=1;
 }
 else if (vadr<vdownlim)
 {
   scrollrow=vadr & (~( SCROLLROWHEI - 1));
   vdownlim-=SCROLLROWHEI;
   verupdate=2;
 }


 sadr = (hadr >> 2) + vadr * (Xlen >>2);  // apomakrinsi apo thn arxi tis selidas

 x=(wx << 4) + hadr;   // PROSOXI: an einai dinaton oi telestes +,-
 y=(wy << 4) + vadr;   // exoun megaliteri proteraiotita apo tous <<,>>

 return realdy;   // posa pixel katafera na skrollaro telika
}
