/*  Example programs for BETATRON game library. 
 ** Copyright (C) 1997 Liouros Thanasis, liouros@hotmail.com
 **
 ** guyele.cc:  This file is part of the example programs for BETATRON game 
 **             library and can be used and/or distributed only under the terms 
 **             of the GNU General Public License. See doc/examples.txt for 
 **             details.
 */

#include "world.h"
#include "plkeys.h"
#include "guyele.h"

// --------------------------------------------------------------------------


void guyrun(TOguy *obj);
void guystartjump(TOguy *obj);
void guystartfall(TOguy *obj);
void guyjump(TOguy *obj);
void guyfall(TOguy *obj);
void guystand(TOguy *obj);



// this functions checks if the guy is on elevator ele or has just left
// elevator ele.

char TOguy::elevatorcheck(unsigned short x1,unsigned short x2,
                          unsigned short y1,unsigned short y2,char eleon)
{
 char res;

 if (eleon)
 {
   res=1;
   if ( (x<x1-13) || (x>x2-15) || (y+shei != y1) )
    res=onelevator=0;
 }
 else
 {
   res=0;
   if (
        (x>=x1-13) &&
        (x<=x2-15) &&
        (y+shei<=y1) &&
        (y+dy+shei >=y1)
       )
     {
      nextaction2=(TPaction) guystand;
      res=onelevator=1;
      y=y1-shei;
     }
  }

  return res;

}







// -------------------- action functions of our guy -------------------------
// --------------------------------------------------------------------------


void guygeneral(TOguy *o)
{
 static char i=0;
 TOworld *w=o->owner;

  if (w->gridcollision(0,o))
  {
    i++; if (i>2) i=0; 
         if (!i) w->rgbset(37, 63,17,17);
    else if (i==1) w->rgbset(37, 0,45,0);
    else  w->rgbset(37, 0,0,45);
  }

  o->nextaction=o->nextaction2;   
  o->nextaction(o);              // call the actual action function
  o->nextaction2=o->nextaction;  // save the active action function
  o->nextaction=(TPaction)guygeneral;      // tell BETATRON to call yourself 
}



void guyinit(TOguy *o)
{
  register TOworld *w=o->owner;
  o->slen=w->framesdescr[o->framebase]->len;
  o->shei=w->framesdescr[o->framebase]->hei;
  o->nextaction2=(TPaction)guystand;
  o->nextaction=(TPaction)guygeneral;
}


void guystand(TOguy *obj)
{
  TOworld *w=obj->owner;

  obj->dx=0;
  obj->dy=0;
  obj->framenow=0;


  if ( pl_testkey(mcNUM6) )	// right arrow
  {
   obj->framebase=obj->savedbase;
   obj->framenow=1;
   obj->time=0;
   obj->nextaction=(TPaction) guyrun;
   obj->dx=1;
  }
  else
  if (pl_testkey(mcNUM4) )   // left arrow
  {
   obj->framebase=obj->savedbase+9;
   obj->framenow=1;
   obj->time=0;
   obj->nextaction=(TPaction)guyrun;
   obj->dx=-1;
  }
  else
  if ( pl_testkey(mcNUM8) )
   obj->nextaction=(TPaction)guystartjump;
}



void guyrun(TOguy *obj)
{
 TOworld *w=obj->owner;

 Tdxy t;




 if ( w->howfarSD(obj,1) && (!obj->onelevator))
  obj->nextaction=(TPaction)guystartfall;
 else
 if ( pl_testkey(mcNUM6) )
 {
  obj->framebase=obj->savedbase;
  t=w->howfarSR(obj,abs(obj->dx));
  obj->dx=t.dx;
  obj->y+=t.dy;
  obj->x+=obj->dx;
 }
 else
 if ( pl_testkey(mcNUM4) )
 {
  obj->framebase=obj->savedbase+9;
  t=w->howfarSL(obj,abs(obj->dx));
  obj->dx=-t.dx;
  obj->y+=t.dy;
  obj->x+=obj->dx;
 }
 else
 obj->nextaction=(TPaction)guystand;

 if ( pl_testkey(mcNUM8) )
   obj->nextaction=(TPaction)guystartjump;

  obj->time+=obj->owner->dticks;
  if (obj->time > 51)
   {
      obj->framenow++;
      obj->time-=51;
      if (obj->framenow >8) obj->framenow=1;
    }

}


void guystartjump(TOguy *obj)
{
 obj->time=0;
 if ( pl_testkey(mcNUM6) || pl_testkey(mcNUM4) ) obj->gx=5;
 obj->dy=-3;
 obj->nextaction=(TPaction)guyjump;
}




void guyjump(TOguy *obj)
{
unsigned short wd;
TOworld *w=obj->owner;
Tdxy t;

 obj->time+=obj->owner->dticks;

 if ( obj->time > 119 )
 {
   obj->time-=119;
   obj->dy++;
 };


  if ( pl_testkey(mcNUM6) )
  {
   obj->framenow=1;
   obj->framebase=obj->savedbase;
   obj->dx=1;
   if (obj->gx > 0 ) obj->dx++;
   t=w->howfarSR(obj,obj->dx);
   obj->dx=t.dx;
   obj->y+=t.dy;
   obj->x+=obj->dx;
  }
  else
  if ( pl_testkey(mcNUM4) )
  {
   obj->framenow=1;
   obj->framebase=obj->savedbase+9;
   obj->dx=-1;
   if (obj->gx > 0 ) obj->dx--;

  t=w->howfarSL(obj,abs(obj->dx));
  obj->dx=-t.dx;
  obj->y+=t.dy;

   obj->x+=obj->dx;
  }


  obj->dy=-w->howfarU(obj,-obj->dy);
  obj->y+=obj->dy;
  obj->gx--;

  if ( obj->dy >= 0 ) obj->nextaction=(TPaction)guystartfall;
};


void guystartfall(TOguy *obj)
{
 obj->dy=1;
// obj->gx=2;
 if ( pl_testkey(mcNUM6) || pl_testkey(mcNUM4) ) obj->gx=10;
 obj->time=0;
 obj->nextaction=(TPaction)guyfall;
}



void guyfall(TOguy *obj)
{
 TOworld *w=obj->owner;
 short wd;
 Tdxy t;



  obj->time+=obj->owner->dticks;


  if ( pl_testkey(mcNUM6) )
  {
   obj->framebase=obj->savedbase;
   obj->framenow=1;
   obj->dx=abs(obj->dx);
   t=w->howfarSR(obj,obj->dx);
   obj->dx=t.dx;
   obj->y+=t.dy;
   obj->x+=obj->dx;
  }
  else if ( pl_testkey(mcNUM4) )
  {
   obj->framenow=1;
   obj->framebase=obj->savedbase+9;
   obj->dx=-abs(obj->dx);
   t=w->howfarSL(obj,abs(obj->dx));
   obj->dx=-t.dx;
   obj->y+=t.dy;
   obj->x+=obj->dx;
  }

  obj->gx--;
  wd=w->howfarSD(obj,obj->dy);


  if (wd!=obj->dy)
  {
   obj->dy=obj->dx=0;
   obj->y+=wd;
   obj->nextaction=(TPaction)guystand;
  }
  else
  {
   obj->y+=obj->dy;
   if ( (obj->time > 119) && (obj->dy<4) )
   {
    obj->dy++;
    obj->time-=119;
   }
  };


}

// --------------------------------------------------------------------------
// --------------------------------------------------------------------------

// --------------- elevator's action function -------------------------------

void elevatorgo(TOele *o)
{

 o->onelevator=o->pguy->elevatorcheck(o->x,o->x+o->slen,o->y,o->y+o->shei,o->onelevator);
 if ( (o->y > o->downlimit) || (o->y < o->uplimit)  )  o->dy=-o->dy;

 if (o->onelevator) o->pguy->incy(o->dy);
 o->y+=o->dy;
}

void eleinit(TOele *e)
{
  register TOworld *w=e->owner;
  e->slen=w->framesdescr[e->framenow]->len;
  e->shei=w->framesdescr[e->framenow]->hei;
  e->nextaction=(TPaction)elevatorgo;
}

// --------------------------------------------------------------------------

void TOguy::init(unsigned char id0,unsigned short x0,unsigned short y0,
             unsigned short framebase0)
{
  TOsprite::init(id0,x0,y0,0,0,0);
  nextaction=(TPaction) guyinit;
  dx=1;
  dy=1;
  time=0;
  onelevator=0;
  savedbase=framebase=framebase0;
}


void TOele::init(unsigned char id0,unsigned short x0,
             unsigned short y0, signed short framenow0,
             signed char dy0, TOguy *pguy0,
             unsigned short uplimit0,
             unsigned short downlimit0)
{
  TOsprite::init(id0,x0,y0,1,1,framenow0);
  dy=dy0;
  nextaction=(TPaction)eleinit;
  uplimit=uplimit0;
  downlimit=downlimit0;
  pguy=pguy0;
  time=0;
  onelevator=0;
}
