/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** PLDPMI.H: This file is part of the BETATRON library and can be used
 **           and/or distributed only under the terms of the GNU Library
 **           General Public License. See doc/readme.1st for details.
 */


#ifndef _pl_dpmi_h
#define _pl_dpmi_h

#include <dpmi.h>

inline short lock_region(short selector,void *addr, long size)
{
	unsigned long _l;
  __dpmi_meminfo _inf;

   if (__dpmi_get_segment_base_address(selector,&_l)==-1) return -1;
   _inf.address=_l+(long)addr;
   _inf.size=size;
   return __dpmi_lock_linear_region(&_inf);
}


inline short unlock_region(short selector,void *addr, long size)
{
	unsigned long _l;
  __dpmi_meminfo _inf;

   if (__dpmi_get_segment_base_address(selector,&_l)==-1) return -1;
   _inf.address=_l+(long)addr;
   _inf.size=size;
   return __dpmi_unlock_linear_region(&_inf);
}


#endif
