// DLX Dynamic Loading and eXecution V2.9
// Copyright (c) 1997, Nanosoft, Inc.
#ifndef __DLX_INCLUDED_2_
#define __DLX_INCLUDED_2_

struct dlxheader {
        long magic;
        long numimports;
        long numrelocs;
        long libmainpos;
        long extablepos;
        long libloadpos;
        long prgsize;
};
typedef long long hdlx_t;

struct dlxiddesc {  // applies only to V2.0 DLX
        hdlx_t MFID; //manufacturer ID
        hdlx_t PRID; //product ID
        hdlx_t VTBL; //version description ID
        hdlx_t UNID; //unique DLX ID
};
extern void(*dlx_first_ctor[])() __asm__("dlx_first_ctor");
extern void(*dlx_last_ctor[])() __asm__("dlx_last_ctor");
extern void(*dlx_first_dtor[])() __asm__("dlx_first_dtor");
extern void(*dlx_last_dtor[])() __asm__("dlx_last_dtor");

#define DLX_MAGIC 0x584c44
#define DLX2_MAGIC 0x32584c44
#define DLX_BUILD_DOS 0x534f444d4249LL
#ifdef __cplusplus
        #define DLXUSE_BEGIN extern "C" {
        #define DLXUSE_END }
        #define DLX_FN extern "C" {
        #define DLX_EF }
        #define DLX_IMPORT extern "C" {
        #define DLX_ENDIMPORT }
#else
        #define DLXUSE_BEGIN
        #define DLXUSE_END
        #define DLX_FN 
        #define DLX_EF 
        #define DLX_IMPORT 
        #define DLX_ENDIMPORT 
#endif
#define LIBLOADS_BEGIN char* _LIBTOLOAD[]={
#define LIBLOADS_END "\0\0"};
#define LIBEXPORT_BEGIN char* _LIBEXPORTTABLE[]= {
#define LIBEXPORT_END 0, 0 };
#define LIBEXPORT(x) "_"#x, (char *)&x,
#define LIBALIAS(x, y) "_"#x, (char *)&y,
#define LIBENTRY(x) (char*)0L, (char *)1L, #x, (char *)&x,
#define LIBWEAK(x) (char*)0L, (char *)2L, "_"#x, (char *)&x,
//#define LIBDPLUG(x) (char*)0L, (char *)3L, "_"#x, (char *)&x,
#define LIBLOAD(x) #x,
#define LIBCONSTRUCT  for (long i=0; i<dlx_last_ctor-dlx_first_ctor; i++)\
                      dlx_first_ctor[i]();
#define LIBDESTRUCT   for (long i=0; i<dlx_last_dtor-dlx_first_dtor; i++)\
                      dlx_first_dtor[i]();
#define LIBVERSION_BEGIN long long _DLXVERSIONTABL[]={
#define LIBVERSION_END 0,0,0,0};
#define LIBVERSION(x) x##LL,
#define LIBMYHANDLE _DLXVERSIONTABL[3]

#endif
