/* ASM code for the lwp package.  This is where the nitty gritty shtuff is */

.globl _lwp_yield
.globl __lwp_init_flags
.globl __lwp_init_fpu
.globl __lwp_dead_yield
tmp1: .long 0 
tmp2: .long 0
tmp3: .long 0
.globl tmp1
.globl tmp2
.globl tmp3

.align 4
.text
_lwp_yield:
	pushal   /* save state */
	pushfl

	movl __lwp_cur, %esi
	subl $1, 20(%esi)       /* decrement pcount */	
	cmp $0, 20(%esi)	/* pcount > 0 ? */
	ja P1

	movl 16(%esi), %eax	 /* pcount = priority */
	movl %eax, 20(%esi)

	subl $108, %esp
	fwait
	fsave (%esp)              /* fpushal */
	fwait

	movl %esp, 12(%esi)	
	movl 4(%esi), %esi      /* swap stacks */
	movl 12(%esi), %esp
	movl %esi, __lwp_cur	

	fwait
	frstor (%esp)           /* fpopal */
	fwait
	addl $108, %esp

	popl %eax
	andb $0xfe, %ah   /* mask off debug flag before poping */
	pushl %eax        /* the flags */
P1:
	popfl  
	popal  /* restore state */
	ret

__lwp_init_flags:
	pushfl
	popl %eax
	ret

__lwp_init_fpu:
	pushl %eax
	movl $__lwp_fpu_state, %eax
	finit
	fwait
	fsave (%eax)
	fwait
	popl %eax
	ret



__lwp_dead_yield:
	movl __lwp_cur, %esi
	movl 12(%esi), %esp    

	fwait
	frstor (%esp)           /* fpopal */
	fwait
	addl $108, %esp

	popl %eax
	andb $0xfe, %ah   /* mask off debug flag before poping */
	pushl %eax        /* the flags */
	popfl  
	popal  /* restore state */
	ret
