#include "lwp.h"
#define MAX_PROC 4 
void proc1(void)
{
   while(1)
     {
	printf("PROC 1\n");  /* printf disables tasking, and this loop */
	lwp_yield();         /* is too tight not to yield.  If printf  */
			     /* was re-entrant, then it would pre-empt */
			     /* much easier.                           */
     }
}

void proc2(void)
{
   while(1)
     {
	printf("PROC 2\n");
	lwp_yield();
     }
}

void proc3(void)
{
   while(1)
     {
	printf("PROC 3\n");
	lwp_yield();
     }
}

void proc4(void)
{
   while(1)
     {
	printf("PROC 4\n");
	lwp_yield();
     }
}

int main()
{
 int ids[MAX_PROC];
 if(lwp_init(8, RTC128)) /* doesn't really matter since each task yields */
 {
 ids[0] = lwp_spawn(proc1, 4096,1);
 ids[1] = lwp_spawn(proc2, 4096,1);
 ids[2] = lwp_spawn(proc3, 4096,1);
 ids[3] = lwp_spawn(proc4, 4096,1);
 while(!kbhit()) 
    {
    printf("MAIN\n");
    lwp_yield();
    }
 getch();
 lwp_kill(ids[0]);
 lwp_kill(ids[1]);
 lwp_kill(ids[2]);
 lwp_kill(ids[3]);
 }
 return(0);
}
