 #include "lwp.h"
#include <dpmi.h>
#include <dos.h>
#include <stdlib.h>
#include <math.h>
#include <sys/farptr.h>
#include <time.h>
#include <go32.h>

#define BLOB_COUNT 250  /* 50 threads */
volatile int plot_count = 0;
void putpixel(int x, int y, char col);
void blob_proc(void);
void waitVBL(void);

int main()
{
	int i;
	int ids[BLOB_COUNT];
	__dpmi_regs regs;
	regs.x.ax = 0x13;
	srandom(time(0));
	__dpmi_int(0x10, &regs);
	lwp_init(8,RTC1024);
	_farsetsel(_dos_ds);
	for(i=0;i<=BLOB_COUNT;i++)
		{
		ids[i] = lwp_spawn(blob_proc, 4096,1);
		}
	while(!kbhit())
		{
		if(plot_count == BLOB_COUNT)
			{
			plot_count = 0;
			waitVBL();
			}	
		plot_count++;
		}
	for(i=0;i<=BLOB_COUNT;i++)
		{
		lwp_kill(ids[i]);
		}

	lwp_thread_disable();
	getch();
	regs.x.ax = 0x3;
	__dpmi_int(0x10, &regs);
	lwp_thread_enable();
	return(0);
}

void blob_proc(void)
{
	int x, y, xspeed,yspeed;
	char col;
	lwp_thread_disable();
        x = random() & 319;
	y = random() & 199;
	col = random() & 0xF0;	
	xspeed = random() & 1;
	yspeed = random() & 1;
	lwp_thread_enable();
	while(1)
		{
		putpixel(x,y,0);
		plot_count++;
		x+=xspeed;
		if(x>=319)
			{
			xspeed=-xspeed;
			x = 319;
			}
		if(x<=0)
			{
			xspeed=-xspeed;
			x = 0;
			}	
		y+=yspeed;
		if(y>=199)
			{
			yspeed=-yspeed;
			y=199;
			}
		if(y<=0)
			{
			yspeed=-yspeed;
			y=0;
			}
		putpixel(x,y,col);	
		}
}	
 
void putpixel(int x, int y, char col)
{
	lwp_thread_disable();
	_farnspokeb(0xA0000+x+(y<<6)+(y<<8), col);
	lwp_thread_enable();
}

void waitVBL(void)
{
	lwp_thread_disable();
	while(!(inportb(0x3DA) & 8));
	while(inportb(0x3DA) & 8);
	lwp_thread_enable();
}
