#include "lwp.h"
#ifdef _LWP_
#define LWP_EXCPTN 0x99     /* arbitrary exception number */

#define IRQ8 0x70         /* used to start the 1khz timer */
#define IRQ0 0x8          /* used to start the variable timer */
#define PIT0 0x40
#define PIT1 0x41
#define PIT2 0x42
#define PITMODE 0x43
#define PITCONST 1193180L
#define PIT0DEF 18.2067597

#ifdef __cplusplus
extern "C" {
#endif
void _lwp_top_of_vars() {};
#ifdef __cplusplus
}
#endif

/*  Global Variables */
static volatile float tick_per_ms = 0.0182068;
static volatile float ms_per_tick = 54.9246551;
static volatile float freq8h = 18.2067597;
static volatile int counter_8h;
static volatile int counter_reset;
static int _lwp_irq_used = 0;
static int _lwp_speed_used = 0;
static int _lwp_on = 0;
char _lwp_fpu_state[108];
__dpmi_paddr _lwp_pm_old_handler, _lwp_pm_new_handler;
__dpmi_regs _lwp_regs;
void (*_lwp_old_handler)(int);
void (*_lwp_old_fpu_handler)(int);
lwp *_lwp_cur;
int _lwp_flags;
static volatile int _lwp_count;
volatile int _lwp_enable;
volatile int _lwp_interrupt_pending;
#ifdef __cplusplus
extern "C" {
#endif
void _lwp_bottom_of_vars() {};
#ifdef __cplusplus
}
#endif

/* Some function prototypes */
#ifdef __cplusplus
extern "C" {
#endif
extern void _lwp_scheduler(int signum);
extern void _lwp_init_fpu(void);
void _lwp_fpu_handler(int signum);
void lwp_deinit(void);
static int _lwp_lock_memory();
static int windoze();
static void setRTC(int value);
static void startIRQ8(void);
static void stopIRQ8(void);
extern int _lwp_init_flags();
extern void _lwp_dead_yield();
char *get_cmostime(void);
#ifdef __cplusplus
}
#endif


static void _lwp_top_of_functions() {};
static volatile void _lwp_dead_thread(void) 
{
 lwp_kill(_lwp_cur->lwpid);
 printf("PANIC!\n"); /* should never get here */
 exit(-1);
 }

int lwp_init(int irq, int speed)
{ 
	volatile unsigned int pit0_set, pit0_value;
	_lwp_irq_used = irq;
	_lwp_speed_used = speed; 
   if(atexit(lwp_deinit))
	return(0);
   if (!_lwp_lock_memory())
      {
      return(0);
      }
   if((_lwp_cur = (lwp *) malloc(sizeof(lwp))) == NULL)
      {
      #ifdef __DEBUG__
      printf("ERROR:  Couldn't malloc _lwp_cur\n");
      #endif
      return(0);
      }
   if(_lwp_lock_data(&_lwp_cur, sizeof(lwp)))
      {
      #ifdef __DEBUG__
      printf("couldn't lock _lwp_cur\n");
      #endif
      return(0);
      }
   _lwp_init_fpu();
   _lwp_flags = _lwp_init_flags();
   _lwp_cur->stack = NULL;	
   _lwp_cur->lwpid = LWP_MAIN;
   _lwp_cur->next = _lwp_cur;
   _lwp_cur->priority = 1;
   _lwp_cur->pcount = 1;
   _lwp_enable = 1;
   _lwp_interrupt_pending = 0;
   /* SIGILL is raised when an unhandled exception is raised */
   _lwp_old_handler = signal(SIGILL,_lwp_scheduler); 
   _lwp_count = 0;
   if(irq == 8)
     {
          _lwp_pm_new_handler.offset32 = (int)_lwp_pm_irq8_timer_hook;
          _lwp_pm_new_handler.selector = _my_cs();
          __dpmi_get_protected_mode_interrupt_vector(IRQ8, &_lwp_pm_old_handler);
          __dpmi_set_protected_mode_interrupt_vector(IRQ8, &_lwp_pm_new_handler);
	  _lwp_on = 1;
	  _lwp_enable = 0;
	  setRTC(speed); 
	  startIRQ8();
          return(1);
     }
   else if (irq == 0)
    {
    if(speed < 1)
       {
       return(0);
       }
    _lwp_pm_new_handler.offset32 = (int)_lwp_pm_irq0_timer_hook;
    _lwp_pm_new_handler.selector = _my_cs();

    __dpmi_get_protected_mode_interrupt_vector(IRQ0, &_lwp_pm_old_handler);
    __dpmi_set_protected_mode_interrupt_vector(IRQ0, &_lwp_pm_new_handler);

    outportb(PITMODE, 0x36);
    pit0_value = PITCONST / speed;  
    pit0_set = (pit0_value & 0x00ff);
    outportb(PIT0, pit0_set);
    pit0_set = (pit0_value >> 8);
    outportb(PIT0, pit0_set);
    freq8h = speed;
    counter_8h = 0;
    counter_reset = freq8h / PIT0DEF;
    tick_per_ms = freq8h / 1000;
    ms_per_tick = 1000 / freq8h;
    _lwp_on = 1;
    _lwp_enable = 0;
    return(1);
    }
   else 
    {
    return(0);
    }
}

int lwp_getpid(void)
{  
   return(_lwp_cur->lwpid);
}

int lwp_thread_count(void)
{
   return(_lwp_count);
}
/* spawns a light weight process.  Returns the lwpid of the proc or 0 on fail*/

int lwp_spawn(void (*proc)(void), int stack_length, int priority)
{
  lwp *tmp;
  int tmp2;
  tmp2 = _lwp_enable;
  _lwp_enable = 1;
  if((proc == NULL) || (stack_length < 256))
	{
        _lwp_enable = 0;
      	return(-1);
     	}
  if((tmp = (lwp *) malloc(sizeof(lwp))) == NULL)
	{
	_lwp_enable = 0;
       	return(-1);
	}

  if((stack_length % 2) != 0) 
	{
	stack_length++; /* make the stack even */
	}	

  if((stack_length %4) != 0) 
       {
       stack_length+=2; /* make the stack divisible by 4 */
       }
	
  if((tmp->stack = (unsigned long *) malloc(stack_length)) == NULL)
	{
	_lwp_enable = 0;
       	return(-1);
	}

  if(priority == 0) /* infinite priority! */
 	{
	_lwp_enable = 0;
	return(-1);
	}

 /* 8 regs +flags */

 tmp->stack[(stack_length/4) - 1] = (long) _lwp_dead_thread;
 tmp->stack[(stack_length/4) - 2] = (long) proc;
 tmp->stack[(stack_length/4) - 3] = 0; 
 tmp->stack[(stack_length/4) - 4] = 0;
 tmp->stack[(stack_length/4) - 5] = 0;  /* regs */
 tmp->stack[(stack_length/4) - 6] = 0;
 tmp->stack[(stack_length/4) - 7] = 0;
 tmp->stack[(stack_length/4) - 8] = 0;
 tmp->stack[(stack_length/4) - 9] = 0;
 tmp->stack[(stack_length/4) -10] = (long) _lwp_flags; /* flags */

/* copy initial FPU state to stack */
memcpy(tmp->stack + (stack_length/4) - 38, _lwp_fpu_state, 108);
  tmp->stack = tmp->stack + (stack_length/4) - 38;
  tmp->priority = priority;
  tmp->pcount = priority;
  tmp->lwpid = ++_lwp_count; 
  tmp->next = _lwp_cur->next;
  
  _lwp_cur->next = tmp; 
  _lwp_enable = tmp2;
  return(tmp->lwpid);
}


/* Kills a lwp (takes it out of the linked list of lwp's) , or 0 if it fails */

int lwp_kill(int lwpid)
{
  int i = 0, tmp;
  lwp *tmp1,*tmp2;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  tmp1 = _lwp_cur->next;
  tmp2 = _lwp_cur;

  if(lwpid == LWP_MAIN)
	{
	printf("PANIC, tried to kill main()!\n");
	exit(-1);
	}

  /* special case for the current thread */
  if(lwpid == _lwp_cur->lwpid)
	{
	tmp1 = _lwp_cur;


	while(tmp1->next != _lwp_cur) tmp1 = tmp1->next;

	tmp1->next = _lwp_cur->next;	

	free(_lwp_cur->stack);
	free(_lwp_cur);

	_lwp_cur = tmp1->next;
	_lwp_count--;
	_lwp_dead_yield();

	printf("PANIC!\n"); /* should never get here after the yield */
	exit(-1);
	}
	
  if((tmp1 == NULL) || (tmp2 == NULL))
	return(0);
  while((i<= _lwp_count+1) && (tmp1->lwpid != lwpid))
         {
         i++;
         tmp1 = tmp1->next;
         tmp2 = tmp2->next;
         }
  /* went through all of them and wasn't found */
  if(tmp1->lwpid != lwpid) 
     return(0);
  /* now tmp IS the right one to kill */
  tmp2->next = tmp1->next;
  free(tmp1->stack);
  free(tmp1);
  _lwp_count--;
  _lwp_enable = 0;
  
  return(1);
}



void lwp_deinit(void)
{
    volatile unsigned long   tick;
    volatile char *cmostime;
    _lwp_enable = 1;
    if(!_lwp_on)
	{
	return;
	}
        if(_lwp_irq_used == 8)
        {
	    stopIRQ8();
            __dpmi_set_protected_mode_interrupt_vector(IRQ8, &_lwp_pm_old_handler);
            signal(SIGILL, _lwp_old_handler);
            _lwp_unlock_data(&_lwp_cur, sizeof(lwp));
            free(_lwp_cur);
	    #ifdef __DEBUG__
	    printf("IRQ8 successfully uninstalled.\n");
	    #endif
            return;
        }
        else if(_lwp_irq_used == 0)
          {
           outportb(PITMODE, 0x36);
           outportb(PIT0, 0x00);
           outportb(PIT0, 0x00);
           __dpmi_set_protected_mode_interrupt_vector(IRQ0, &_lwp_pm_old_handler);
           signal(SIGILL, _lwp_old_handler);
           _lwp_unlock_data(&_lwp_cur, sizeof(lwp));
           free(_lwp_cur);
           cmostime = get_cmostime();
        tick = PIT0DEF *
            (
             (((float) *cmostime) * 3600) +
             (((float) *(cmostime + 1)) * 60) +
             (((float) *(cmostime + 2)))
            );
        biostime(1, tick);

        freq8h = PIT0DEF;
        counter_reset = freq8h / PIT0DEF;
        tick_per_ms = freq8h / 1000;
        ms_per_tick = 1000 / freq8h;
	#ifdef __DEBUG__
	printf("IRQ0 successfully uninstalled.\n");
	#endif
        return;
        }
 return;
}

char           *get_cmostime(void)
{
    /* used to fix the fast timer */
    char *buff;
    static char buffer[6];
    char ch;

    buff = buffer;
    memset(&_lwp_regs, 0, sizeof(_lwp_regs));
    _lwp_regs.h.ah = 0x02;
    __dpmi_int(0x1a, &_lwp_regs);

    ch = _lwp_regs.h.ch;
    buffer[0] = (char) ((int) (ch & 0x0f) + (int) ((ch >> 4) & 0x0f) * 10);
    ch = _lwp_regs.h.cl;
    buffer[1] = (char) ((int) (ch & 0x0f) + (int) ((ch >> 4) & 0x0f) * 10);
    ch = _lwp_regs.h.dh;
    buffer[2] = (char) ((int) (ch & 0x0f) + (int) ((ch >> 4) & 0x0f) * 10);
    buffer[3] = _lwp_regs.h.dl;
    buffer[4] = (char) (_lwp_regs.x.flags & 0x0001);
    buffer[5] = 0x00;

    return (buff);
}
static void _lwp_bottom_of_functions() {};

static int _lwp_lock_memory()
{
  if(_lwp_lock_code(_lwp_top_of_functions,  (long) &_lwp_bottom_of_functions - (long) &_lwp_top_of_functions))
     {
     /* fail */
     #ifdef __DEBUG__
     printf("ERROR:  DPMI error locking code segment functions\n");
     #endif
     return(0);
     }
  if(_lwp_lock_code(&_lwpasm_start, (long) &_lwpasm_end - (long) _lwpasm_start))
     {
     /* fail */
     #ifdef __DEBUG__
     printf("ERROR:  DPMI error locking code segment IRQ handlers\n");
     #endif
     return(0);
     }
  if(_lwp_lock_data(_lwp_top_of_vars, (long) &_lwp_bottom_of_vars - (long) &_lwp_top_of_vars))
    {
    #ifdef __DEBUG__
    printf("ERROR:  DPMI error locking data segment variables\n");
    #endif
    return(0);
    }
  return(1); 
}
void _lwp_fpu_handler(int signum)
{
	volatile int tmp = _lwp_enable;
	_lwp_enable = 1;
	_lwp_old_fpu_handler(signum);
	_lwp_enable = tmp;
}
/* returns true if windoze is running */
static int windoze()
{
   __dpmi_regs regs;
   regs.x.ax = 0x1600;
   __dpmi_int(0x2F, &regs);
   return((regs.x.ax - 0x1600));
}
/* copied from go32 lib funcs */
int _lwp_lock_data( void *lockaddr, unsigned long locksize )
    {
    unsigned long baseaddr;
    __dpmi_meminfo memregion;
    if(windoze()) return(0);
    if( __dpmi_get_segment_base_address( _my_ds(), &baseaddr) == -1 ) return( -1 );

    memset( &memregion, 0, sizeof(memregion) );

    memregion.address = baseaddr + (unsigned long) lockaddr;
    memregion.size    = locksize;

    if( __dpmi_lock_linear_region( &memregion ) == -1 ) return( -1 );

    return( 0 );
    }

int _lwp_unlock_data( void *lockaddr, unsigned long locksize )
    {
    unsigned long baseaddr;
    __dpmi_meminfo memregion;
    if(windoze()) return(0);
    if( __dpmi_get_segment_base_address( _my_ds(), &baseaddr) == -1 ) return( -1 );

    memset( &memregion, 0, sizeof(memregion) );

    memregion.address = baseaddr + (unsigned long) lockaddr;
    memregion.size    = locksize;

    if( __dpmi_unlock_linear_region( &memregion ) == -1 ) return( -1 );

    return( 0 );
    }

int _lwp_lock_code( void *lockaddr, unsigned long locksize )
    {
    unsigned long baseaddr;
    __dpmi_meminfo memregion;
    if(windoze()) return(0);
    if( __dpmi_get_segment_base_address( _my_cs(), &baseaddr) == -1 ) return( -1 );

    memset( &memregion, 0, sizeof(memregion) );

    memregion.address = baseaddr + (unsigned long) lockaddr;
    memregion.size    = locksize;

    if( __dpmi_lock_linear_region( &memregion ) == -1 ) return( -1 );

    return( 0 );
    }

int _lwp_unlock_code( void *lockaddr, unsigned long locksize )
    {
    unsigned long baseaddr;
    __dpmi_meminfo memregion;
    if(windoze()) return(0);
    if( __dpmi_get_segment_base_address( _my_cs(), &baseaddr) == -1 ) return( -1 );

    memset( &memregion, 0, sizeof(memregion) );

    memregion.address = baseaddr + (unsigned long) lockaddr;
    memregion.size    = locksize;

    if( __dpmi_unlock_linear_region( &memregion ) == -1 ) return( -1 );

    return( 0 );
    }

static void setRTC(int value)
{
	__asm__ __volatile__ ("cli\n\t"
		"movb $0x0A, %%al\n\t"
		"outb %%al, $0x70\n\t"  /* output status a   */
		"inb $0x71, %%al\n\t"  /* get current stats */
		"addb $0xF0, %%bl\n\t"   /* mask top 4 bits   */
		"andb %%bl, %%al\n\t"    /* output new div    */ 
		"subb $0xF0, %%bl\n\t"   /* only set bottom 4 bits */
		"orb  %%bl, %%al\n\t"
		"movb %%al, %%bl\n\t"
		"movb $0xA, %%al\n\t"
		"outb %%al, $0x70\n\t"  /* outputing to status a */
		"movb %%bl, %%al\n\t"
		"outb %%al, $0x71\n\t"  /* done */
		"sti\n\t"
		: /* none */ 
                : "b" (value) 
                : "%eax" , "%edx");
}	
static void startIRQ8(void)
{
	unsigned char shtuff;
	disable();
	outportb(0x70, 0x0B);  /* status B */
	shtuff = inportb(0x71); /* get status */
	shtuff = shtuff | 0x40; /* mask off interrupt enable bit */
	outportb(0x70, 0x0B);   /* status B again */
	outportb(0x71, shtuff);  /* output new value */ 
	outportb(0x70, 0x0C);    /* status C */
	inportb(0x71);           /* ack interrupt */
	enable();
}

static void stopIRQ8(void)
{
	unsigned char shtuff;
	disable();
	outportb(0x70, 0x0B);  /* status B */
	shtuff = inportb(0x71); /* get status */
	shtuff = shtuff & 0xBF; /* mask off interrupt enable bit */
	outportb(0x70, 0x0B);   /* status B again */
	outportb(0x71, shtuff);  /* output new value */ 
	outportb(0x70, 0x0C);    /* status C */
	inportb(0x71);           /* ack interrupt */
	enable();
}

#endif /* _LWP_ */ 
