/* LWP 1.0 :) */
#ifndef _LWP_
#define _LWP_
#include <crt0.h>
#include <dpmi.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/exceptn.h>
#include <string.h>
#include <sys/segments.h>
#include <string.h>
#include <bios.h>
#include <stdlib.h>     
#include <stdio.h>
#define LWP_MAIN -1
/* for programming IRQ8 */
#define RTC2		0xF	
#define RTC4		0xE	
#define RTC8		0xD
#define RTC16		0xC
#define RTC32		0xB
#define RTC64		0xA
#define RTC128		0x9
#define RTC256		0x8
#define RTC512		0x7
#define RTC1024		0x6
#define RTC2048		0x5
#define RTC4096		0x4
#define RTC8192		0x3
#ifdef __cplusplus
extern "C" {
#endif
/* Don't change this struct.  The scheduler needs to know their positions. */
/* If you have to add anything, add it AFTER stack */
typedef struct lwp_struct {
int lwpid;
struct lwp_struct *next;
int stklen;
unsigned long *stack;
int priority;
int pcount;
} lwp;
/* User functions */
int lwp_init(int irq, int speed);
int lwp_spawn(void (*proc)(void), int stack_length, int priority);
int lwp_kill(volatile int lwpid);
int lwp_getpid();
int lwp_thread_count();
void lwp_yield();

extern void _lwp_pm_irq8_timer_hook(void);
extern void _lwp_pm_irq0_timer_hook(void);

/* for locking critical code */
extern long  _lwpasm_start;
extern long  _lwpasm_end;
int _lwp_lock_data( void *lockaddr, unsigned long locksize );
int _lwp_unlock_data( void *lockaddr, unsigned long locksize );
int _lwp_lock_code( void *lockaddr, unsigned long locksize );
int _lwp_unlock_code( void *lockaddr, unsigned long locksize );

extern lwp *_lwp_cur;

/* for blocking a task switch */
void lwp_thread_enable( void );
void lwp_thread_disable( void );

#ifdef __cplusplus
}
#endif

#include "conio.h" 
#include "stdio.h"
#include "pc.h"
#endif   /* _LWP_ */
