#ifndef __LWP_CONIO_H__
#define __LWP_CONIO_H__
#include <conio.h>
extern int _lwp_enable;
#ifdef __cplusplus
extern "C" {
#endif

#ifndef __dj_ENFORCE_ANSI_FREESTANDING
#ifndef __STRICT_ANSI__
#ifndef _POSIX_SOURCE

__inline__ static char* _lwp_cgets(char *_str)
{ char* result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = cgets(_str);
  _lwp_enable = tmp;
  return result;
 }
#define cgets _lwp_gets

__inline__ static void _lwp_clreol(void)
 { 
 volatile int tmp;
 tmp = _lwp_enable; 
 _lwp_enable = 1;
 clreol();
 _lwp_enable = tmp;
 }
#define clreol _lwp_clreol

__inline__ static void _lwp_clrscr(void)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 clrscr();
 _lwp_enable = tmp;
 }
#define clrscr _lwp_clrscr

__inline__ static int _lwp__conio_kbhit(void)
{ volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = _conio_kbhit();
  _lwp_enable = tmp;
  return result; }
#define _conio_kbhit _lwp__conio_kbhit

#define cprintf #error "Not done in LWP_CONIO.h"
/*int   cprintf(const char *_format, ...) __attribute__((format(printf,1,2)));*/

__inline__ static int _lwp_cputs(const char *_str)
{ volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = cputs(_str);
  _lwp_enable = tmp; 
  return result;
 }
#define cputs _lwp_cputs

#define cscanf #error "Not done in LWP_CONIO.h"
/*int     cscanf(const char *_format, ...) __attribute__((format(scanf,1,2)));*/

__inline__ static void _lwp_delline(void)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  delline(); 
  _lwp_enable = tmp;
  }
#define delline _lwp_delline

__inline__ static int _lwp_getch(void)
{ volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = getch();
  _lwp_enable = tmp;
  return result;
  }
#define getch _lwp_getch

__inline__ static int _lwp_getche(void)
{ volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = getche();
  _lwp_enable = tmp;
  return result;
 }
#define getche _lwp_getche

__inline__ static int
     _lwp_gettext(int _left, int _top, int _right, int _bottom, void *_destin)
{
  volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = gettext(_left, _top, _right, _bottom, _destin);
  _lwp_enable = tmp;
  return result; 
  }
#define gettext _lwp_gettext

__inline__ static void _lwp_gettextinfo(struct text_info *_r)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  gettextinfo(_r);
  _lwp_enable = tmp;
}
#define gettextinfo _lwp_gettextinfo

__inline__ static void _lwp_gotoxy(int _x, int _y)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 gotoxy(_x,_y); 
 _lwp_enable = tmp;
 }
#define gotoxy _lwp_gotoxy

__inline__ static void _lwp_gppconio_init(void)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 gppconio_init(); 
 _lwp_enable = tmp;
}
#define gppconio_init _lwp_gppconio_init

__inline__ static void _lwp_highvideo(void)
 { 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 highvideo();
 _lwp_enable = tmp;
 }
#define highvideo _lwp_highvideo

__inline__ static void _lwp_insline(void)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 insline();
 _lwp_enable = tmp; 
 }
#define insline _lwp_insline

__inline__ static void _lwp_lowvideo(void)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 lowvideo();
 _lwp_enable = tmp; 
 }
#define lowvideo _lwp_lowvideo

__inline__ static int _lwp_movetext(int _left, int _top, int _right,
                                    int _bottom, int _destleft, int _desttop)
{ volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = movetext(_left, _top, _right, _bottom, _destleft, _desttop);
  _lwp_enable = tmp; 
  return result; 
 }
#define movetext _lwp_movetext

__inline__ static void _lwp_normvideo(void)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 normvideo(); 
 _lwp_enable = tmp;
 }
#define normvideo _lwp_normvideo

__inline__ static int _lwp_putch(int _c)
{
  volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = putch(_c);
  _lwp_enable = tmp;
  return result;
 }
#define putch _lwp_putch

__inline__ static
  int _lwp_puttext(int _left, int _top, int _right, int _bottom, void *_source)
{ 
  volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = puttext(_left, _top, _right, _bottom, _source);
  _lwp_enable = tmp;
  return result;
  }
#define puttext _lwp_puttext

__inline__ static void _lwp__setcursortype(int _type)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1; 
 _setcursortype(_type); 
 _lwp_enable = tmp;
}
#define _setcursortype _lwp__setcursortype

__inline__ static void _lwp__set_screen_lines(int _nlines)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 _set_screen_lines(_nlines); 
 _lwp_enable = tmp;
 }
#define _set_screen_lines _lwp__set_screen_lines

__inline__ static void _lwp_textattr(int _attr)
{
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  textattr(_attr); 
  _lwp_enable = tmp;
}
#define textattr _lwp_textattr

__inline__ static void _lwp_textbackground(int _colour)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 textbackground(_colour); 
 _lwp_enable = tmp;
}
#define textbackground _lwp_textbackground

__inline__ static void _lwp_textcolor(int _colour)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 textcolor(_colour); 
 _lwp_enable = tmp; 
 }
#define textcolor _lwp_textcolor

__inline__ static void _lwp_textmode(int _mode)
{ 
 volatile int tmp;
 tmp = _lwp_enable;
 _lwp_enable = 1;
 textmode(_mode); 
 _lwp_enable = tmp;
 }
#define textmode _lwp_textmode

__inline__ static int _lwp_ungetch(int _char)
{ volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = ungetch(_char);
  _lwp_enable = tmp;
  return result; 
  }
#define ungetch _lwp_ungetch

__inline__ static int _lwp_wherex( void )
{ 
  volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = wherex();
  _lwp_enable = tmp;
  return result;
  }
#define wherex _lwp_wherex

__inline__ static int _lwp_wherey( void )
{ 
  volatile int result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = wherey();
  _lwp_enable = tmp;
  return result; 
  }
#define wherey _lwp_wherey

__inline__ static void _lwp_window(int _left, int _top, int _right, int _bottom)
{ 
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  window(_left, _top, _right, _bottom);
  _lwp_enable = tmp;
 }
#define window _lwp_window

#define kbhit _conio_kbhit /* Who ever includes gppconio.h probably
                              also wants _conio_kbhit and not kbhit
                              from libc */

#endif /* !_POSIX_SOURCE */
#endif /* !__STRICT_ANSI__ */
#endif /* !__dj_ENFORCE_ANSI_FREESTANDING */

#ifdef __cplusplus
}
#endif

#endif /* !__LWP_CONIO_H__ */
