 #include "lwp.h"
#include <dpmi.h>
#include <dos.h>
#include <stdlib.h>
#include <math.h>
#include <sys/farptr.h>
#include <go32.h>
#include <time.h>
#include <ctype.h>

#define BLOB_COUNT 500  /* 50 threads */
#define CENTERY 1.0
#define CENTERX 1.0
volatile int plot_count = 0;
void putpixel(int x, int y, char col);
void blob_proc(void);
void waitVBL(void);
void getNewCoords(double *x, double *y,double *xspeed,double *yspeed,double centerx,double centery);
double gravConst = 0.0525;
int main()
{
	int i;
	char answer = 0;
	int ids[BLOB_COUNT];
	__dpmi_regs regs;
	clrscr();
	printf("LWP:  Example 4.  Pre-emptive/Coop\n");
	printf("This program spawns %d threads that each draw\n", BLOB_COUNT);
	printf("a dot on the screen that orbit around the center\n");
	printf("of the screen.  \n\n");
	printf("U = Increase gravitational constant\n");
	printf("D = Decrease gravitational constant\n");
	printf("N = Spawn a new thread. (Don't over due it!)\n");
	printf("Q = Quit.\n");
	printf("Press any key to continue...");
	fflush(stdout);
	getch();
	regs.x.ax = 0x13;
	srandom(time(0));
	__dpmi_int(0x10, &regs);
	lwp_init(8,RTC128);
	_farsetsel(_go32_conventional_mem_selector());
	for(i=0;i<BLOB_COUNT;i++)
		{
		ids[i] = lwp_spawn(blob_proc, 4096, 1);
		}
	while((toupper(answer) != 'Q'))
		{
		while(!kbhit())
			{
			if(plot_count >= BLOB_COUNT)
				{
				plot_count = 0;
				putpixel(0,0,90);
				waitVBL();
				}	
			lwp_yield();
			}
		lwp_thread_disable();
		answer = toupper(getch());
		lwp_thread_enable();
		if (answer == 'U')
			{
			gravConst+=0.001;
			}
		if (answer == 'D')
			{
			gravConst-=0.001;
			}
		if (answer == 'N')
			{
			lwp_spawn(blob_proc, 4096, 1);
			}
		}
	for(i=0;i<BLOB_COUNT;i++)
		{
		lwp_kill(ids[i]);
		}
	regs.x.ax = 0x3;
	__dpmi_int(0x10, &regs);
	return(0);
}

void blob_proc(void)
{
	double x, y, xspeed,yspeed;
	char col;
        x = (double) 70 * ((float) random()/ (float) RAND_MAX) -35.0;
	y = (double) 70 * ((float) random()/ (float) RAND_MAX) - 35.0;
	col = (char) 200 * ((float) random() / (float) RAND_MAX) + 50;	
	xspeed = (double) 2 * ((float) random()/ (float) RAND_MAX) - 1.0;
	yspeed = (double) 2 * ((float) random()/ (float) RAND_MAX) - 1.0;
	while(1)
		{
		putpixel((int) x,(int) y,col);	
		plot_count++;
		lwp_yield();
		putpixel((int) x,(int) y,0); 
		/* get new X,Y position from vector function */
		getNewCoords(&x,&y,&xspeed,&yspeed,CENTERX, CENTERY);
		}
}	
 
void putpixel(int x, int y, char col)
{
	lwp_thread_disable();
 	if(!((x < -159) || (x > 159) || (y < -99) || (y > 99)))	
		{
		x+=159;
		y+=99;
		_farnspokeb(0xA0000+x+(y<<6)+(y<<8), col);
		}
	lwp_thread_enable();
}

void waitVBL(void)
{
	lwp_thread_disable();
	while(!(inportb(0x3DA) & 8));
	while(inportb(0x3DA) & 8);
	lwp_thread_enable();
}

void getNewCoords(double *x, double *y,double *xspeed,double *yspeed,double centerx,double centery)
{
        double tmp1, tmp2, tmp3, tmp4;
	double divisor1, divisor2;
        tmp1 = (centerx)-(*xspeed)-(*x);
        tmp2 = (centery)-(*yspeed)-(*y);     
	divisor1 = sqrt((tmp1*tmp1)+(tmp2*tmp2));
	divisor2 = ((centerx-(*xspeed))*(centerx-(*xspeed)))+((centery-(*yspeed))*(centery-(*yspeed)));
        if((divisor1 != 0) && (divisor2 != 0))
                {
		tmp3 = tmp1/divisor1;
		tmp4 = tmp2/divisor1;
		(*xspeed) = ((*xspeed) + tmp3*gravConst/divisor2);
		(*yspeed) = ((*yspeed) + tmp4*gravConst/divisor2);
		(*x) += (*xspeed);
		(*y) += (*yspeed);
                }
        else
                {
		(*x) += (*xspeed);
		(*y) += (*yspeed);
                }
}
