/*
 * Copyright (C) Keith Whitwell 1996
 */

#ifndef InterfaceHeader
#define InterfaceHeader

#include <X11/Intrinsic.h>

int initialize( Widget w );
void shutdown();
int load_model( const char *filename, int type );
void render();
void arcBall( int dx, int dy );
void moveCamera( int dx, int dy, int dz );
void notifyResize();
void notifyExpose( int xmin, int ymin, int xmax, int ymax );
void setPipeline( int nr );
const char **getFileTypeArray( int *nr );
int renderToFile( int deviceNr, const char *filename );

typedef enum {
    FiletypeNff,
    FiletypeGeom
} Filetype;

#endif
