#include <Lib3d/Lib3d.H>
#include <Lib3d/internals/HrTimer.H>
#include <Lib3d/Devices/FileDevice.H>
#include <iostream.h>
#include <fstream.h>


main()
{
    int nr, idx;
    const char **filetype = FileDevice::getFileTypeArray( nr );
    
    cout << "Configured file devices: " << endl;
    for (int i = 0 ; i < nr ; i++) {
	cout << i << ": " << filetype[i] << endl;
    }
    do {
	cout << "\nChoice: " << flush;
	cin >> idx;
    } while (idx < 0 || idx >= nr);


    Viewport *viewport = Viewport::create(FileDevice::create(idx, 320, 200, 8));
    if (!viewport) {
	cout << "Failed to create viewport" << endl;
	exit(1);
    }
    cout << *viewport << endl;

    World world;
    ModelBuilder ob;

    ifstream in("../models/teapot.nff");
    if (in.bad()) {
	cerr << "Couldn't open teapot.nff" << endl;
	exit(-1);
    }

    ob.startModel();
    // ob.setColourfulMode(.2);	// Beachball mode
    ob.readNFF( in );

    Model *model = ob.endModel();
    world.adopt(model);

    cout << "Created object:\n" << *model << endl;

    Camera *camera = new Camera(world);
    camera->setParameters(3,100,15,1);
    world.setActiveCamera( *camera );

/*
    Vector3 colour(1,1,1);	
    Vector3 direction(0,1,.5);
    Light *light = new Light(world);
    light->setParameters(colour, colour, direction);
    world.registerLight( *light );
*/
    Vector3 colour2(1,0,0.5);
    Vector3 direction2(1,0,0.5);
    Light *light2 = new Light(world);
    light2->setParameters(colour2, colour2, direction2);
    world.registerLight( *light2 );

/*
    colour.assign(0,1,0);	
    direction.assign(0,-1,.5);
    light = new Light(world);
    light->setParameters(colour, colour, direction);
    world.registerLight( *light );
*/

    Matrix34 transform;
    transform.setIdentity();
    model->setTransform(transform);
    
    Matrix34 tmp;
    Matrix34 scale;
    scale.setIdentity();

    transform.setRotation(-90, 1,0,0);
    scale.setRotation((4.56), 0, 1, 0);

    tmp.setTranslation(0,-1,-10);
    camera->setTransform(tmp);

    transform.premul(scale);
    model->setTransform(transform);

    cout << "Creating output file..." << endl;

    world.renderHierarchy( *viewport );
    viewport->swapBuffers();

    delete viewport;
}










