#include <Lib3d/Viewport.H>
#include <Lib3d/Model.H>
#include <Lib3d/ModelBuilder.H>
#include <Lib3d/World.H>
#include <Lib3d/Camera.H>
#include <iostream.h>

main()
{

    ModelBuilder ob;

    ob.startModel();

    int ind[4];
    ind[0] = ob.addVertex(-10,-10,30);
    ind[1] = ob.addVertex(20,20,30);
    ind[2] = ob.addVertex(-10,40,30);
    ind[3] = ob.addVertex(20,-10,10);

    uint vl[4][3] = { { ind[0], ind[1], ind[2] },
		  {     ind[1], ind[0], ind[3] },
		  {     ind[3], ind[0], ind[2] },
		  {     ind[2], ind[1], ind[3] } };

    ob.calculatePolygonNormals();
    ob.setColourfulMode(1,0);	// cycle through 7 bright colours 

    for (int i = 0 ; i < 4 ; i++ ) {
	ob.addPolygon( 3, vl[i] );
    }

    Model *model = ob.endModel();

    cout << "Created object:\n" << *model << endl;

    World world;
    Camera *camera = new Camera(world);
    camera->setParameters(1,200,45,1);
    world.adopt(model);
    world.setActiveCamera(*camera);

    cout << "Rendering: " << endl;
    
    Matrix34 transform;
    transform.setIdentity();
    model->setTransform(transform);
    
    Matrix34 tmp;
    Matrix34 scale;
    scale.setIdentity();

    // Backwards.
    tmp.setRotation((3.14), 1, 2, 0);
    scale.premul(tmp);
    tmp.setRotation((1.14), 0, 0, 1);
    scale.premul(tmp);
 

    Viewport *viewport = Viewport::create(Device::create(320, 200, 8));
    if (!viewport) {
	cout << "Couldn't create viewport" << endl;
	exit(1);
    }

    Matrix34 t2;
    t2.setTranslation(0,0,-80);
    camera->setTransform(t2);

    for ( int i = 0 ; i < 4000 ; i++ ) {
	transform.premul(scale);
	model->setTransform(transform);
	world.renderHierarchy( *viewport );
	viewport->swapBuffers();
    }

    delete viewport;
}










