// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.


#ifndef MatrixInlines
#define MatrixInlines

#include <Lib3d/Matrix.H>

inline void 
Matrix34::transpose( const Matrix34 &m )
{
    v[0][0] = m.v[0][0];
    v[1][0] = m.v[0][1];
    v[2][0] = m.v[0][2];

    v[0][1] = m.v[1][0];
    v[1][1] = m.v[1][1];
    v[2][1] = m.v[1][2];

    v[0][2] = m.v[2][0];
    v[1][2] = m.v[2][1];
    v[2][2] = m.v[2][2];

    v[0][3] = 0;
    v[1][3] = 0;
    v[2][3] = 0;
}

#endif
