// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

 
#include "VpNew.H"
#include <Lib3d/Texture.H>
#include <Lib3d/ColourRamp.H>
#include <math.h>

class Vp16 : public VpNew
{
public:
    const char *getName() const { return "Vp16"; }
    Colour getColour( uint r, uint g, uint b );
    void drawColourSpace() {}

protected:
    virtual void doTextureTriangleZb( edge_major_texture&, 
				      edge_minor_step&,
				      edge_minor_step&,
				      const Texture & );

    virtual void doFlatTriangleZb( edge_major_flat&, 
				   edge_minor&,
				   edge_minor&,
				   Colour );

    virtual void doSmoothTriangleZb( edge_major_smooth&, 
				     edge_minor_step&,
				     edge_minor_step&,
				     const ColourRamp & );

    virtual void lineZb( const DeviceVector &, 
			 const DeviceVector &, 
			 Colour );

protected:
    Viewport *clone( Device *device );
    ~Vp16();
    Vp16( Exemplar e ) : VpNew( e, 100 ) {}
    Vp16( Device * );


protected:
    static Vp16 *advertisement;
};


Vp16::Vp16( Device *device )
    : VpNew( device )
{
}

Vp16::~Vp16()
{
}

Viewport *
Vp16::clone( Device *device ) 
{ 
    return (device->getDepth() == 16) ? new Vp16( device ) : 0;
}

Colour
Vp16::getColour( uint r, uint g, uint b ) 
{
    // For a 565 bit layout.

    return ((r & 0xf8) << 8) | ((g & 0xfc) << 3) | ((b & 0xf8) >> 3);
}

#define CLASS Vp16
#define PIXELTYPE ushort
#include "VpGeneric.cc"
